/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.api;

import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import dev.shadowsoffire.apothic_attributes.util.Comparators;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class AttributeHelper {
    public static final ResourceLocation BASE_ATTACK_DAMAGE = Item.BASE_ATTACK_DAMAGE_ID;
    public static final ResourceLocation BASE_ATTACK_SPEED = Item.BASE_ATTACK_SPEED_ID;
    public static final ResourceLocation BASE_ENTITY_REACH = ResourceLocation.withDefaultNamespace((String)"base_entity_reach");

    public static void modify(LivingEntity entity, Holder<Attribute> attribute, ResourceLocation id, double value, AttributeModifier.Operation operation) {
        AttributeInstance inst = entity.getAttribute(attribute);
        if (inst != null) {
            inst.addPermanentModifier(new AttributeModifier(id, value, operation));
        }
    }

    public static void addToBase(LivingEntity entity, Holder<Attribute> attribute, ResourceLocation id, double modifier) {
        AttributeHelper.modify(entity, attribute, id, modifier, AttributeModifier.Operation.ADD_VALUE);
    }

    public static void addXTimesNewBase(LivingEntity entity, Holder<Attribute> attribute, ResourceLocation id, double modifier) {
        AttributeHelper.modify(entity, attribute, id, modifier, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    public static void multiplyFinal(LivingEntity entity, Holder<Attribute> attribute, ResourceLocation id, double modifier) {
        AttributeHelper.modify(entity, attribute, id, modifier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> sortedMap() {
        return TreeMultimap.create(Comparator.comparing(Holder::value, Comparators.idComparator(BuiltInRegistries.ATTRIBUTE)), AttributeHelper.modifierComparator());
    }

    public static Comparator<AttributeModifier> modifierComparator() {
        return Comparators.chained(Comparator.comparing(AttributeModifier::operation), Comparator.comparing(AttributeModifier::amount), Comparator.comparing(AttributeModifier::id));
    }

    public static MutableComponent list() {
        return Component.literal((String)" \u2507 ").withStyle(ChatFormatting.GRAY);
    }

    public static Stream<ItemAttributeModifiers.Entry> getModifiers(ItemAttributeModifiers modifs, Holder<Attribute> attr) {
        return AttributeHelper.getModifiers(modifs.modifiers(), attr);
    }

    public static Stream<ItemAttributeModifiers.Entry> getModifiers(List<ItemAttributeModifiers.Entry> modifs, Holder<Attribute> attr) {
        return modifs.stream().filter(e -> e.attribute().equals((Object)attr));
    }
}

