/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.api;

import dev.shadowsoffire.apothic_attributes.api.AttributeHelper;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.jetbrains.annotations.Nullable;

public interface IFormattableAttribute {
    public static final DecimalFormat FORMAT = (DecimalFormat)Util.make((Object)new DecimalFormat("#.##"), fmt -> fmt.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));

    default public MutableComponent toValueComponent(@Nullable AttributeModifier.Operation op, double value, TooltipFlag flag) {
        if (this == Attributes.KNOCKBACK_RESISTANCE || this == NeoForgeMod.SWIM_SPEED.value()) {
            return Component.translatable((String)"apothic_attributes.value.percent", (Object[])new Object[]{FORMAT.format(value * 100.0)});
        }
        if (this == Attributes.MOVEMENT_SPEED && IFormattableAttribute.isNullOrAddition(op)) {
            return Component.translatable((String)"apothic_attributes.value.percent", (Object[])new Object[]{FORMAT.format(value * 1000.0)});
        }
        String key = IFormattableAttribute.isNullOrAddition(op) ? "apothic_attributes.value.flat" : "apothic_attributes.value.percent";
        return Component.translatable((String)key, (Object[])new Object[]{FORMAT.format(IFormattableAttribute.isNullOrAddition(op) ? value : value * 100.0)});
    }

    default public MutableComponent toComponent(AttributeModifier modif, TooltipFlag flag) {
        Attribute attr = this.ths();
        double value = modif.amount();
        MutableComponent comp = value > 0.0 ? Component.translatable((String)"apothic_attributes.modifier.plus", (Object[])new Object[]{this.toValueComponent(modif.operation(), value, flag), Component.translatable((String)attr.getDescriptionId())}).withStyle(attr.getStyle(true)) : Component.translatable((String)"apothic_attributes.modifier.take", (Object[])new Object[]{this.toValueComponent(modif.operation(), value *= -1.0, flag), Component.translatable((String)attr.getDescriptionId())}).withStyle(attr.getStyle(false));
        return comp.append(this.getDebugInfo(modif, flag));
    }

    default public Component getDebugInfo(AttributeModifier modif, TooltipFlag flag) {
        Component debugInfo = CommonComponents.EMPTY;
        if (flag.isAdvanced()) {
            double advValue = (double)(modif.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? 1 : 0) + modif.amount();
            String valueStr = FORMAT.format(advValue);
            String txt = switch (modif.operation()) {
                default -> throw new MatchException(null, null);
                case AttributeModifier.Operation.ADD_VALUE -> {
                    if (advValue > 0.0) {
                        yield String.format("[+%s]", valueStr);
                    }
                    yield String.format("[%s]", valueStr);
                }
                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> {
                    if (advValue > 0.0) {
                        yield String.format("[+%sx]", valueStr);
                    }
                    yield String.format("[%sx]", valueStr);
                }
                case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> String.format("[x%s]", valueStr);
            };
            debugInfo = Component.literal((String)" ").append((Component)Component.literal((String)txt).withStyle(ChatFormatting.GRAY));
        }
        return debugInfo;
    }

    @Nullable
    default public ResourceLocation getBaseID() {
        if (this == Attributes.ATTACK_DAMAGE.value()) {
            return AttributeHelper.BASE_ATTACK_DAMAGE;
        }
        if (this == Attributes.ATTACK_SPEED.value()) {
            return AttributeHelper.BASE_ATTACK_SPEED;
        }
        if (this == Attributes.ENTITY_INTERACTION_RANGE.value()) {
            return AttributeHelper.BASE_ENTITY_REACH;
        }
        return null;
    }

    default public MutableComponent toBaseComponent(double value, double entityBase, boolean merged, TooltipFlag flag) {
        Attribute attr = this.ths();
        Component debugInfo = CommonComponents.EMPTY;
        if (flag.isAdvanced() && !merged) {
            debugInfo = Component.literal((String)" ").append((Component)Component.translatable((String)"apothic_attributes.adv.base", (Object[])new Object[]{FORMAT.format(entityBase), FORMAT.format(value - entityBase)}).withStyle(ChatFormatting.GRAY));
        }
        MutableComponent comp = Component.translatable((String)"attribute.modifier.equals.0", (Object[])new Object[]{FORMAT.format(value), Component.translatable((String)attr.getDescriptionId())});
        return comp.append(debugInfo);
    }

    default public double getBonusBaseValue(ItemStack stack) {
        return 0.0;
    }

    default public void addBonusTooltips(ItemStack stack, Consumer<Component> tooltip, TooltipFlag flag) {
    }

    default public Attribute ths() {
        return (Attribute)this;
    }

    public static MutableComponent toComponent(Holder<Attribute> attr, AttributeModifier modif, TooltipFlag flag) {
        return IFormattableAttribute.cast(attr).toComponent(modif, flag);
    }

    public static MutableComponent toValueComponent(Holder<Attribute> attr, AttributeModifier.Operation op, double value, TooltipFlag flag) {
        return IFormattableAttribute.cast(attr).toValueComponent(op, value, flag);
    }

    public static MutableComponent toBaseComponent(Holder<Attribute> attr, double value, double entityBase, boolean merged, TooltipFlag flag) {
        return IFormattableAttribute.cast(attr).toBaseComponent(value, entityBase, merged, flag);
    }

    public static IFormattableAttribute cast(Holder<Attribute> attr) {
        return (IFormattableAttribute)attr.value();
    }

    public static boolean isNullOrAddition(@Nullable AttributeModifier.Operation op) {
        return op == null || op == AttributeModifier.Operation.ADD_VALUE;
    }
}

