/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apothic_attributes.ALConfig;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.apothic_attributes.api.IFormattableAttribute;
import dev.shadowsoffire.apothic_attributes.client.AttributeModifierComponent;
import dev.shadowsoffire.apothic_attributes.client.ModifierSource;
import dev.shadowsoffire.apothic_attributes.client.ModifierSourceType;
import dev.shadowsoffire.placebo.PlaceboClient;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.common.BooleanAttribute;

public class AttributesGui
implements Renderable,
GuiEventListener {
    public static final ResourceLocation TEXTURES = ApothicAttributes.loc("textures/gui/attributes_gui.png");
    public static final WidgetSprites SWORD_BUTTON_SPRITES = new WidgetSprites(ApothicAttributes.loc("sword"), ApothicAttributes.loc("sword_highlighted"));
    public static final int ENTRY_HEIGHT = 22;
    public static final int MAX_ENTRIES = 6;
    public static final int WIDTH = 131;
    public static boolean wasOpen = false;
    protected static float scrollOffset = 0.0f;
    protected static boolean hideUnchanged = false;
    protected static boolean swappedFromCurios = false;
    protected final InventoryScreen parent;
    protected final Player player;
    protected final Font font;
    protected final ImageButton toggleBtn;
    protected final ImageButton recipeBookButton;
    protected final HideUnchangedButton hideUnchangedBtn;
    protected int leftPos;
    protected int topPos;
    protected boolean scrolling;
    protected int startIndex;
    protected List<AttributeInstance> data;
    @Nullable
    protected AttributeInstance selected;
    protected boolean open;
    protected long lastRenderTick;
    private static DecimalFormat f = IFormattableAttribute.FORMAT;

    public AttributesGui(InventoryScreen parent) {
        ImageButton imgBtn;
        GuiEventListener btn2;
        this.font = Minecraft.getInstance().font;
        this.data = new ArrayList<AttributeInstance>();
        this.selected = null;
        this.open = false;
        this.lastRenderTick = -1L;
        this.parent = parent;
        this.player = Minecraft.getInstance().player;
        this.refreshData();
        this.leftPos = parent.getGuiLeft() - 131;
        this.topPos = parent.getGuiTop();
        this.toggleBtn = new ImageButton(this, parent.getGuiLeft() + 63, parent.getGuiTop() + 10, 10, 10, SWORD_BUTTON_SPRITES, btn -> this.toggleVisibility(), (Component)Component.translatable((String)"apothic_attributes.gui.show_attributes")){

            public void setFocused(boolean pFocused) {
            }
        };
        this.recipeBookButton = this.parent.children().size() > 1 ? ((btn2 = (GuiEventListener)this.parent.children().get(0)) instanceof ImageButton ? (imgBtn = (ImageButton)btn2) : null) : null;
        this.hideUnchangedBtn = new HideUnchangedButton(this, 0, 0);
    }

    public void refreshData() {
        this.data.clear();
        BuiltInRegistries.ATTRIBUTE.holders().map(arg_0 -> ((Player)this.player).getAttribute(arg_0)).filter(Objects::nonNull).filter(ai -> !ALConfig.hiddenAttributes.contains(((ResourceKey)ai.getAttribute().unwrapKey().get()).location())).filter(ai -> !hideUnchanged || ai.getBaseValue() != ai.getValue()).forEach(this.data::add);
        this.data.sort(this::compareAttrs);
        this.startIndex = (int)((double)(scrollOffset * (float)this.getOffScreenRows()) + 0.5);
    }

    public void toggleVisibility() {
        boolean bl = this.open = !this.open;
        if (this.open && this.parent.getRecipeBookComponent().isVisible()) {
            this.parent.getRecipeBookComponent().toggleVisibility();
        }
        this.hideUnchangedBtn.visible = this.open;
        int newLeftPos = this.open && this.parent.width >= 379 ? 177 + (this.parent.width - this.parent.imageWidth - 200) / 2 : (this.parent.width - this.parent.imageWidth) / 2;
        this.parent.leftPos = newLeftPos;
        this.leftPos = this.parent.getGuiLeft() - 131;
        this.topPos = this.parent.getGuiTop();
        if (this.recipeBookButton != null) {
            this.recipeBookButton.setPosition(this.parent.getGuiLeft() + 104, this.parent.height / 2 - 22);
        }
        this.hideUnchangedBtn.setPosition(this.leftPos + 7, this.topPos + 151);
    }

    protected int compareAttrs(AttributeInstance a1, AttributeInstance a2) {
        String name = I18n.get((String)((Attribute)a1.getAttribute().value()).getDescriptionId(), (Object[])new Object[0]);
        String name2 = I18n.get((String)((Attribute)a2.getAttribute().value()).getDescriptionId(), (Object[])new Object[0]);
        return name.compareTo(name2);
    }

    public boolean isMouseOver(double pMouseX, double pMouseY) {
        if (!this.open) {
            return false;
        }
        return this.isHovering(0, 0, 131, 166, pMouseX, pMouseY);
    }

    public void render(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        this.toggleBtn.setX(this.parent.getGuiLeft() + 63);
        this.toggleBtn.setY(this.parent.getGuiTop() + 10);
        if (this.parent.getRecipeBookComponent().isVisible()) {
            this.open = false;
        }
        wasOpen = this.open;
        if (!this.open) {
            return;
        }
        if (this.lastRenderTick != PlaceboClient.ticks) {
            this.lastRenderTick = PlaceboClient.ticks;
            this.refreshData();
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURES);
        int left = this.leftPos;
        int top = this.topPos;
        gfx.blit(TEXTURES, left, top, 0, 0, 131, 166);
        int scrollbarPos = (int)(117.0f * scrollOffset);
        gfx.blit(TEXTURES, left + 111, top + 16 + scrollbarPos, 244, this.isScrollBarActive() ? 0 : 15, 12, 15);
        for (int idx = this.startIndex; idx < this.startIndex + 6 && idx < this.data.size(); ++idx) {
            this.renderEntry(gfx, this.data.get(idx), this.leftPos + 8, this.topPos + 16 + 22 * (idx - this.startIndex), mouseX, mouseY);
        }
        this.renderTooltip(gfx, mouseX, mouseY);
        gfx.drawString(this.font, (Component)Component.translatable((String)"apothic_attributes.gui.attributes"), this.leftPos + 8, this.topPos + 5, 0x404040, false);
        gfx.drawString(this.font, (Component)Component.literal((String)"Hide Unchanged"), this.leftPos + 20, this.topPos + 152, 0x404040, false);
    }

    protected void renderTooltip(GuiGraphics gfx, int mouseX, int mouseY) {
        AttributeInstance inst = this.getHoveredSlot(mouseX, mouseY);
        if (inst != null) {
            Attribute attr = (Attribute)inst.getAttribute().value();
            boolean isDynamic = inst.getAttribute().is(ALObjects.Tags.DYNAMIC_BASE_ATTRIBUTES);
            IFormattableAttribute fAttr = (IFormattableAttribute)attr;
            ArrayList<Object> list = new ArrayList<Object>();
            MutableComponent name = Component.translatable((String)attr.getDescriptionId()).withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD).withUnderlined(Boolean.valueOf(true)));
            if (isDynamic) {
                name.append(CommonComponents.SPACE);
                name.append((Component)Component.translatable((String)"apothic_attributes.gui.dynamic").withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY).withUnderlined(Boolean.valueOf(false))));
            }
            if (ApothicAttributes.getTooltipFlag().isAdvanced()) {
                Style style = Style.EMPTY.withColor(ChatFormatting.GRAY).withUnderlined(Boolean.valueOf(false));
                name.append((Component)Component.literal((String)(" [" + String.valueOf(BuiltInRegistries.ATTRIBUTE.getKey((Object)attr)) + "]")).withStyle(style));
            }
            list.add(name);
            String key = attr.getDescriptionId() + ".desc";
            if (I18n.exists((String)key)) {
                txt = Component.translatable((String)key).withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC});
                list.add(txt);
            } else if (ApothicAttributes.getTooltipFlag().isAdvanced()) {
                txt = Component.literal((String)key).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
                list.add(txt);
            }
            int color = AttributesGui.getValueColor(inst, ChatFormatting.GRAY.getColor());
            MutableComponent valueComp = fAttr.toValueComponent(null, inst.getValue(), ApothicAttributes.getTooltipFlag()).withColor(color);
            MutableComponent baseComp = fAttr.toValueComponent(null, inst.getBaseValue(), ApothicAttributes.getTooltipFlag()).withStyle(ChatFormatting.GRAY);
            if (!isDynamic) {
                list.add(CommonComponents.EMPTY);
                list.add(Component.translatable((String)"apothic_attributes.gui.current", (Object[])new Object[]{valueComp}).withStyle(ChatFormatting.GRAY));
                MutableComponent base = Component.translatable((String)"apothic_attributes.gui.base", (Object[])new Object[]{baseComp}).withStyle(ChatFormatting.GRAY);
                if (attr instanceof RangedAttribute) {
                    RangedAttribute ra = (RangedAttribute)attr;
                    MutableComponent min = fAttr.toValueComponent(null, ra.getMinValue(), ApothicAttributes.getTooltipFlag());
                    min = Component.translatable((String)"apothic_attributes.gui.min", (Object[])new Object[]{min});
                    MutableComponent mutableComponent2 = fAttr.toValueComponent(null, ra.getMaxValue(), ApothicAttributes.getTooltipFlag());
                    mutableComponent2 = Component.translatable((String)"apothic_attributes.gui.max", (Object[])new Object[]{mutableComponent2});
                    list.add(Component.translatable((String)"%s \u2507 %s \u2507 %s", (Object[])new Object[]{base, min, mutableComponent2}).withStyle(ChatFormatting.GRAY));
                } else {
                    list.add(base);
                }
            }
            ArrayList<ClientTooltipComponent> finalTooltip = new ArrayList<ClientTooltipComponent>(list.size());
            for (Object txt : list) {
                this.addComp((Component)txt, finalTooltip);
            }
            if (inst.getModifiers().stream().anyMatch(modif -> modif.amount() != 0.0)) {
                this.addComp(CommonComponents.EMPTY, finalTooltip);
                this.addComp((Component)Component.translatable((String)"apothic_attributes.gui.modifiers").withStyle(ChatFormatting.GOLD), finalTooltip);
                HashMap modifiersToSources = new HashMap();
                for (ModifierSourceType modifierSourceType : ModifierSourceType.getTypes()) {
                    modifierSourceType.extract((LivingEntity)this.player, (modif, source) -> modifiersToSources.put(modif.id(), (ModifierSource<?>)source));
                }
                MutableComponent[] opValues = new MutableComponent[3];
                double[] dArray = new double[3];
                for (AttributeModifier.Operation op : AttributeModifier.Operation.values()) {
                    MutableComponent comp;
                    double baseValue = op == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? 1.0 : 0.0;
                    ArrayList modifiers = new ArrayList(inst.getModifiers(op).values());
                    double opValue = modifiers.stream().mapToDouble(AttributeModifier::amount).reduce(baseValue, (res, elem) -> op == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? res * (1.0 + elem) : res + elem);
                    modifiers.sort(ModifierSourceType.compareBySource(modifiersToSources));
                    for (AttributeModifier modif2 : modifiers) {
                        if (modif2.amount() == 0.0) continue;
                        MutableComponent comp2 = fAttr.toComponent(modif2, ApothicAttributes.getTooltipFlag());
                        ModifierSource src = (ModifierSource)modifiersToSources.get(modif2.id());
                        finalTooltip.add(new AttributeModifierComponent(src, (FormattedText)comp2, this.font, this.leftPos - 16));
                    }
                    color = AttributesGui.getValueColor(attr, opValue, baseValue, ChatFormatting.GRAY.getColor());
                    MutableComponent valueComp2 = fAttr.toValueComponent(op, opValue, ApothicAttributes.getTooltipFlag()).withStyle(Style.EMPTY.withColor(color));
                    opValues[op.ordinal()] = comp = Component.translatable((String)("apothic_attributes.gui." + op.name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{valueComp2}).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
                    dArray[op.ordinal()] = opValue;
                }
                this.addComp(CommonComponents.EMPTY, finalTooltip);
                this.addComp((Component)Component.translatable((String)"apothic_attributes.gui.formula").withStyle(ChatFormatting.GOLD), finalTooltip);
                MutableComponent base = isDynamic ? Component.translatable((String)"apothic_attributes.gui.formula.base") : baseComp;
                MutableComponent value = isDynamic ? Component.translatable((String)"apothic_attributes.gui.formula.value") : valueComp;
                Component formula = AttributesGui.buildFormula((Component)base, (Component)value, dArray, attr);
                this.addComp(formula, finalTooltip);
            } else if (isDynamic) {
                this.addComp(CommonComponents.EMPTY, finalTooltip);
                this.addComp((Component)Component.translatable((String)"apothic_attributes.gui.no_modifiers").withStyle(ChatFormatting.GOLD), finalTooltip);
            }
            gfx.renderTooltipInternal(this.font, finalTooltip, this.leftPos - 16 - finalTooltip.stream().map(c -> c.getWidth(this.font)).max(Integer::compare).get(), mouseY, DefaultTooltipPositioner.INSTANCE);
        }
    }

    private void addComp(Component comp, List<ClientTooltipComponent> finalTooltip) {
        if (comp == CommonComponents.EMPTY) {
            finalTooltip.add(ClientTooltipComponent.create((FormattedCharSequence)comp.getVisualOrderText()));
        } else {
            for (FormattedText fTxt : this.font.getSplitter().splitLines((FormattedText)comp, this.leftPos - 16, comp.getStyle())) {
                finalTooltip.add(ClientTooltipComponent.create((FormattedCharSequence)Language.getInstance().getVisualOrder(fTxt)));
            }
        }
    }

    private void renderEntry(GuiGraphics gfx, AttributeInstance inst, int x, int y, int mouseX, int mouseY) {
        boolean hover = this.getHoveredSlot(mouseX, mouseY) == inst;
        gfx.blit(TEXTURES, x, y, 142, hover ? 22 : 0, 100, 22);
        MutableComponent txt = Component.translatable((String)((Attribute)inst.getAttribute().value()).getDescriptionId());
        int splitWidth = 60;
        List lines = this.font.split((FormattedText)txt, splitWidth);
        while (lines.size() > 2) {
            lines = this.font.split((FormattedText)txt, splitWidth += 10);
        }
        PoseStack stack = gfx.pose();
        stack.pushPose();
        float scale = 1.0f;
        int maxWidth = lines.stream().map(arg_0 -> ((Font)this.font).width(arg_0)).max(Integer::compareTo).get();
        if (maxWidth > 66) {
            scale = 66.0f / (float)maxWidth;
            stack.scale(scale, scale, 1.0f);
        }
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
            float width = (float)this.font.width(line) * scale;
            float lineX = ((float)(x + 1) + (68.0f - width) / 2.0f) / scale;
            float lineY = (float)(y + (lines.size() == 1 ? 7 : 2) + i * 10) / scale;
            gfx.drawString(this.font, line, lineX, lineY, 0x404040, false);
        }
        stack.popPose();
        stack.pushPose();
        IFormattableAttribute attr = IFormattableAttribute.cast((Holder<Attribute>)inst.getAttribute());
        MutableComponent value = attr.toValueComponent(null, inst.getValue(), (TooltipFlag)TooltipFlag.Default.NORMAL);
        if (inst.getAttribute().is(ALObjects.Tags.DYNAMIC_BASE_ATTRIBUTES)) {
            value = Component.literal((String)"\ufffd");
        }
        scale = 1.0f;
        if (this.font.width((FormattedText)value) > 27) {
            scale = 27.0f / (float)this.font.width((FormattedText)value);
            stack.scale(scale, scale, 1.0f);
        }
        int color = AttributesGui.getValueColor(inst, ChatFormatting.WHITE.getColor());
        gfx.drawString(this.font, (Component)value, (int)(((float)(x + 72) + (27.0f - (float)this.font.width((FormattedText)value) * scale) / 2.0f) / scale), (int)((float)(y + 7) / scale), color, true);
        stack.popPose();
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (!this.open || !this.isScrollBarActive()) {
            return false;
        }
        this.scrolling = false;
        int left = this.leftPos + 111;
        int top = this.topPos + 15;
        if (pMouseX >= (double)left && pMouseX < (double)(left + 12) && pMouseY >= (double)top && pMouseY < (double)(top + 155)) {
            this.scrolling = true;
            int i = this.topPos + 15;
            int j = i + 138;
            scrollOffset = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            scrollOffset = Mth.clamp((float)scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(scrollOffset * (float)this.getOffScreenRows()) + 0.5);
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (!this.open) {
            return false;
        }
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.topPos + 15;
            int j = i + 138;
            scrollOffset = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            scrollOffset = Mth.clamp((float)scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(scrollOffset * (float)this.getOffScreenRows()) + 0.5);
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (!this.open) {
            return false;
        }
        if (this.isScrollBarActive()) {
            int i = this.getOffScreenRows();
            scrollOffset = (float)((double)scrollOffset - pScrollY / (double)i);
            scrollOffset = Mth.clamp((float)scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(scrollOffset * (float)i) + 0.5);
            return true;
        }
        return false;
    }

    private boolean isScrollBarActive() {
        return this.data.size() > 6;
    }

    protected int getOffScreenRows() {
        return Math.max(0, this.data.size() - 6);
    }

    @Nullable
    public AttributeInstance getHoveredSlot(int mouseX, int mouseY) {
        for (int i = 0; i < 6; ++i) {
            if (this.startIndex + i >= this.data.size() || !this.isHovering(8, 14 + 22 * i, 100, 22, mouseX, mouseY)) continue;
            return this.data.get(this.startIndex + i);
        }
        return null;
    }

    protected boolean isHovering(int pX, int pY, int pWidth, int pHeight, double pMouseX, double pMouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        return (pMouseX -= (double)i) >= (double)(pX - 1) && pMouseX < (double)(pX + pWidth + 1) && (pMouseY -= (double)j) >= (double)(pY - 1) && pMouseY < (double)(pY + pHeight + 1);
    }

    public static String format(int n) {
        int log = (int)StrictMath.log10(n);
        if (log <= 4) {
            return String.valueOf(n);
        }
        if (log == 5) {
            return f.format((double)n / 1000.0) + "K";
        }
        if (log <= 8) {
            return f.format((double)n / 1000000.0) + "M";
        }
        return f.format((double)n / 1.0E9) + "B";
    }

    public static int getValueColor(AttributeInstance inst, int fallbackColor) {
        return AttributesGui.getValueColor((Attribute)inst.getAttribute().value(), inst.getValue(), inst.getBaseValue(), fallbackColor);
    }

    public static int getValueColor(Attribute attr, double value, double base, int fallbackColor) {
        if (value == base) {
            return fallbackColor;
        }
        if (attr instanceof RangedAttribute) {
            boolean isPositive = value > base;
            return AttributesGui.translateColor(attr.getStyle(isPositive));
        }
        if (attr instanceof BooleanAttribute) {
            boolean isPositive = value > 0.0;
            return AttributesGui.translateColor(attr.getStyle(isPositive));
        }
        return fallbackColor;
    }

    private static int translateColor(ChatFormatting color) {
        return switch (color) {
            case ChatFormatting.BLUE -> 0x55DD55;
            case ChatFormatting.RED -> 0xFF6060;
            case ChatFormatting.GRAY -> 0xFFFFFF;
            default -> color.getColor();
        };
    }

    public static Component buildFormula(Component base, Component value, double[] numericValues, Attribute attr) {
        ChatFormatting color;
        Object withParens;
        double add = numericValues[0];
        double mulBase = numericValues[1];
        double mulTotal = numericValues[2];
        boolean isAddNeg = add < 0.0;
        boolean isMulNeg = mulBase < 0.0;
        String addSym = isAddNeg ? "-" : "+";
        add = Math.abs(add);
        String mulBaseSym = isMulNeg ? "-" : "+";
        mulBase = Math.abs(mulBase);
        String addStr = f.format(add);
        String mulBaseStr = f.format(mulBase);
        String mulTotalStr = f.format(mulTotal);
        Object formula = "%2$s";
        if (add != 0.0) {
            ChatFormatting color2 = AttributesGui.getColor(attr, isAddNeg);
            formula = (String)formula + " " + AttributesGui.colored(addSym + " " + addStr, color2);
        }
        if (mulBase != 0.0) {
            withParens = add == 0.0 ? formula : "(%s)".formatted(formula);
            color = AttributesGui.getColor(attr, isMulNeg);
            formula = (String)withParens + " " + AttributesGui.colored(mulBaseSym + " " + mulBaseStr + " * ", color) + (String)withParens;
        }
        if (mulTotal != 1.0) {
            withParens = add == 0.0 && mulBase == 0.0 ? formula : "(%s)".formatted(formula);
            color = AttributesGui.getColor(attr, mulTotal < 1.0);
            formula = AttributesGui.colored(mulTotalStr + " * ", color) + (String)withParens;
        }
        return Component.translatable((String)("%1$s = " + (String)formula), (Object[])new Object[]{value, base}).withStyle(ChatFormatting.GRAY);
    }

    private static ChatFormatting getColor(Attribute attr, boolean isNegative) {
        ChatFormatting color = attr.getStyle(!isNegative);
        return color == ChatFormatting.BLUE ? ChatFormatting.YELLOW : color;
    }

    private static String colored(String str, ChatFormatting color) {
        return "\u00a7" + color.getChar() + str + "\u00a7" + ChatFormatting.RESET.getChar();
    }

    public void setFocused(boolean pFocused) {
    }

    public boolean isFocused() {
        return false;
    }

    public class HideUnchangedButton
    extends AbstractButton {
        public HideUnchangedButton(AttributesGui this$0, int pX, int pY) {
            super(pX, pY, 10, 10, (Component)Component.literal((String)"Hide Unchanged Attributes"));
            this.visible = false;
        }

        public void onPress() {
            hideUnchanged = !hideUnchanged;
        }

        public void renderWidget(GuiGraphics gfx, int pMouseX, int pMouseY, float pPartialTick) {
            int vOffset;
            int u = 131;
            int v = 20;
            int n = vOffset = hideUnchanged ? 0 : 10;
            if (this.isHovered) {
                vOffset += 20;
            }
            RenderSystem.enableDepthTest();
            PoseStack pose = gfx.pose();
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 100.0f);
            gfx.blit(TEXTURES, this.getX(), this.getY(), (float)u, (float)(v + vOffset), 10, 10, 256, 256);
            pose.popPose();
        }

        protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
            this.defaultButtonNarrationText(pNarrationElementOutput);
        }
    }
}

