/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import dev.shadowsoffire.apothic_attributes.ALConfig;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.apothic_attributes.api.AttributeHelper;
import dev.shadowsoffire.apothic_attributes.api.IFormattableAttribute;
import dev.shadowsoffire.apothic_attributes.api.client.AddAttributeTooltipsEvent;
import dev.shadowsoffire.apothic_attributes.api.client.GatherSkippedAttributeTooltipsEvent;
import dev.shadowsoffire.apothic_attributes.client.AttributesGui;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.CritParticle;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.GatherEffectScreenTooltipsEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public class AttributesLibClient {
    private static final ResourceLocation FAKE_MERGED_ID = ApothicAttributes.loc("fake_merged_modifier");

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void tooltips(ItemTooltipEvent e) {
        ItemStack stack = e.getItemStack();
        List list = e.getToolTip();
        int markIdx1 = -1;
        int markIdx2 = -1;
        for (int i = 0; i < list.size(); ++i) {
            ComponentContents componentContents = ((Component)list.get(i)).getContents();
            if (!(componentContents instanceof PlainTextContents.LiteralContents)) continue;
            PlainTextContents.LiteralContents tc = (PlainTextContents.LiteralContents)componentContents;
            if ("APOTH_REMOVE_MARKER".equals(tc.text())) {
                markIdx1 = i;
            }
            if (!"APOTH_REMOVE_MARKER_2".equals(tc.text())) continue;
            markIdx2 = i;
            break;
        }
        if (markIdx1 == -1 || markIdx2 == -1) {
            return;
        }
        ListIterator<Component> it = list.listIterator(markIdx1);
        for (int i = markIdx1; i < markIdx2 + 1; ++i) {
            it.next();
            it.remove();
        }
        boolean shouldShow = ((ItemAttributeModifiers)stack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY)).showInTooltip();
        if (shouldShow) {
            AttributesLibClient.applyModifierTooltips(e.getEntity(), stack, it::add, e.getFlags());
        }
        NeoForge.EVENT_BUS.post((Event)new AddAttributeTooltipsEvent(stack, e.getEntity(), list, it, e.getFlags()));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void addAttribComponent(ScreenEvent.Init.Post e) {
        Screen screen;
        if (ALConfig.enableAttributesGui && (screen = e.getScreen()) instanceof InventoryScreen) {
            InventoryScreen scn = (InventoryScreen)screen;
            AttributesGui atrComp = new AttributesGui(scn);
            e.addListener((GuiEventListener)atrComp);
            e.addListener((GuiEventListener)atrComp.toggleBtn);
            e.addListener((GuiEventListener)atrComp.hideUnchangedBtn);
            if (AttributesGui.wasOpen || AttributesGui.swappedFromCurios) {
                atrComp.toggleVisibility();
            }
            AttributesGui.swappedFromCurios = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void effectGuiTooltips(GatherEffectScreenTooltipsEvent e) {
        String key;
        List tooltips = e.getTooltip();
        MobEffectInstance effectInst = e.getEffectInstance();
        Holder effect = effectInst.getEffect();
        MutableComponent name = (MutableComponent)tooltips.get(0);
        Component duration = (Component)tooltips.remove(1);
        duration = Component.translatable((String)"(%s)", (Object[])new Object[]{duration}).withStyle(ChatFormatting.WHITE);
        name.append(" ").append(duration);
        if (ApothicAttributes.getTooltipFlag().isAdvanced()) {
            name.append(" ").append((Component)Component.translatable((String)"[%s]", (Object[])new Object[]{((ResourceKey)effect.unwrapKey().get()).location().toString()}).withStyle(ChatFormatting.GRAY));
        }
        if (I18n.exists((String)(key = ((MobEffect)effect.value()).getDescriptionId() + ".desc"))) {
            tooltips.add(Component.translatable((String)key).withStyle(ChatFormatting.DARK_GRAY));
        } else if (ApothicAttributes.getTooltipFlag().isAdvanced() && ((MobEffect)effect.value()).attributeModifiers.isEmpty()) {
            tooltips.add(Component.translatable((String)key).withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
        ArrayList list = Lists.newArrayList();
        Map map = ((MobEffect)effect.value()).attributeModifiers;
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                MobEffect.AttributeTemplate template = (MobEffect.AttributeTemplate)entry.getValue();
                list.add(new Pair((Object)((Holder)entry.getKey()), (Object)template.create(effectInst.getAmplifier())));
            }
        }
        if (!list.isEmpty()) {
            for (Pair pair : list) {
                tooltips.add(IFormattableAttribute.toComponent((Holder<Attribute>)((Holder)pair.getFirst()), (AttributeModifier)pair.getSecond(), ApothicAttributes.getTooltipFlag()));
            }
        }
    }

    @SubscribeEvent
    public void potionTooltips(ItemTooltipEvent e) {
        List effects;
        if (!ALConfig.enablePotionTooltips) {
            return;
        }
        ItemStack stack = e.getItemStack();
        List tooltips = e.getToolTip();
        if (stack.getItem() instanceof PotionItem && (effects = ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).customEffects()).size() == 1 && tooltips.size() >= 2) {
            MobEffect effect = (MobEffect)((MobEffectInstance)effects.get(0)).getEffect().value();
            String key = effect.getDescriptionId() + ".desc";
            if (I18n.exists((String)key)) {
                tooltips.add(2, Component.translatable((String)key).withStyle(ChatFormatting.DARK_GRAY));
            } else if (e.getFlags().isAdvanced() && effect.attributeModifiers.isEmpty()) {
                tooltips.add(2, Component.translatable((String)key).withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
            }
        }
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> getSortedModifiers(ItemStack stack, EquipmentSlotGroup slot) {
        Multimap<Holder<Attribute>, AttributeModifier> map = AttributeHelper.sortedMap();
        stack.forEachModifier(slot, (attr, modif) -> {
            if (attr != null && modif != null) {
                map.put(attr, modif);
            } else {
                ApothicAttributes.LOGGER.debug("Detected broken attribute modifier entry on item {}.  Attr={}, Modif={}", (Object)stack, attr, modif);
            }
        });
        return map;
    }

    public static void apothCrit(int entityId) {
        Entity entity = Minecraft.getInstance().level.getEntity(entityId);
        if (entity != null) {
            Minecraft.getInstance().particleEngine.createTrackingEmitter(entity, (ParticleOptions)ALObjects.Particles.APOTH_CRIT.get());
        }
    }

    private static void applyModifierTooltips(@Nullable Player player, ItemStack stack, Consumer<Component> tooltip, TooltipFlag flag) {
        HashSet<ResourceLocation> skips = new HashSet<ResourceLocation>();
        NeoForge.EVENT_BUS.post((Event)new GatherSkippedAttributeTooltipsEvent(stack, player, skips, flag));
        for (EquipmentSlotGroup group : EquipmentSlotGroup.values()) {
            Multimap<Holder<Attribute>, AttributeModifier> modifiers = AttributesLibClient.getSortedModifiers(stack, group);
            AttributesLibClient.applyTextFor(player, stack, tooltip, modifiers, group, skips, flag);
        }
    }

    private static MutableComponent padded(String padding, Component comp) {
        return Component.literal((String)padding).append(comp);
    }

    private static MutableComponent list() {
        return AttributeHelper.list();
    }

    private static void applyTextFor(@Nullable Player player, ItemStack stack, Consumer<Component> tooltip, Multimap<Holder<Attribute>, AttributeModifier> modifierMap, EquipmentSlotGroup group, Set<ResourceLocation> skips, TooltipFlag flag) {
        if (!modifierMap.isEmpty()) {
            modifierMap.values().removeIf(m -> skips.contains(m.id()));
            tooltip.accept((Component)Component.empty());
            tooltip.accept((Component)Component.translatable((String)("item.modifiers." + group.getSerializedName())).withStyle(ChatFormatting.GRAY));
            if (modifierMap.isEmpty()) {
                return;
            }
            IdentityHashMap baseModifs = new IdentityHashMap();
            modifierMap.forEach((attr, modif) -> {
                if (modif.id().equals((Object)IFormattableAttribute.cast((Holder<Attribute>)attr).getBaseID())) {
                    baseModifs.put(attr, new BaseModifier((AttributeModifier)modif, (List<AttributeModifier>)new ArrayList<AttributeModifier>()));
                }
            });
            modifierMap.forEach((attr, modif) -> {
                BaseModifier base = (BaseModifier)baseModifs.get(attr);
                if (base != null && base.base != modif) {
                    base.children.add((AttributeModifier)modif);
                }
            });
            for (Map.Entry entry : baseModifs.entrySet()) {
                double base;
                Holder attr2 = (Holder)entry.getKey();
                BaseModifier baseModif = (BaseModifier)entry.getValue();
                double entityBase = player == null ? 0.0 : player.getAttributeBaseValue(attr2);
                double rawBase = base = baseModif.base.amount() + entityBase;
                double amt = base;
                double baseBonus = IFormattableAttribute.cast((Holder<Attribute>)attr2).getBonusBaseValue(stack);
                for (AttributeModifier modif2 : baseModif.children) {
                    if (modif2.operation() == AttributeModifier.Operation.ADD_VALUE) {
                        base = amt += modif2.amount();
                        continue;
                    }
                    if (modif2.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE) {
                        amt += modif2.amount() * base;
                        continue;
                    }
                    amt *= 1.0 + modif2.amount();
                }
                boolean isMerged = !baseModif.children.isEmpty() || baseBonus != 0.0;
                MutableComponent text = IFormattableAttribute.toBaseComponent((Holder<Attribute>)attr2, amt += baseBonus, entityBase, isMerged, flag);
                tooltip.accept((Component)AttributesLibClient.padded(" ", (Component)text).withStyle(isMerged ? ChatFormatting.GOLD : ChatFormatting.DARK_GREEN));
                if (!Screen.hasShiftDown() || !isMerged) continue;
                text = IFormattableAttribute.toBaseComponent((Holder<Attribute>)attr2, rawBase, entityBase, false, flag);
                tooltip.accept((Component)AttributesLibClient.list().append((Component)text.withStyle(ChatFormatting.DARK_GREEN)));
                for (AttributeModifier modifier : baseModif.children) {
                    tooltip.accept((Component)AttributesLibClient.list().append((Component)IFormattableAttribute.toComponent((Holder<Attribute>)attr2, modifier, flag)));
                }
                if (!(baseBonus > 0.0)) continue;
                IFormattableAttribute.cast((Holder<Attribute>)attr2).addBonusTooltips(stack, tooltip, flag);
            }
            for (Holder attr3 : modifierMap.keySet()) {
                if (baseModifs.containsKey(attr3)) continue;
                Collection modifs = modifierMap.get((Object)attr3);
                if (modifs.size() > 1) {
                    double[] sums = new double[3];
                    boolean[] merged = new boolean[3];
                    HashMap<AttributeModifier.Operation, List> shiftExpands = new HashMap<AttributeModifier.Operation, List>();
                    for (AttributeModifier modifier : modifs) {
                        if (modifier.amount() == 0.0) continue;
                        if (sums[modifier.operation().ordinal()] != 0.0) {
                            merged[modifier.operation().ordinal()] = true;
                        }
                        int n = modifier.operation().ordinal();
                        sums[n] = sums[n] + modifier.amount();
                        shiftExpands.computeIfAbsent(modifier.operation(), k -> new LinkedList()).add(modifier);
                    }
                    for (AttributeModifier.Operation op : AttributeModifier.Operation.values()) {
                        int i = op.ordinal();
                        if (sums[i] == 0.0) continue;
                        if (merged[i]) {
                            TextColor color;
                            TextColor textColor = color = sums[i] < 0.0 ? TextColor.fromRgb((int)16331057) : TextColor.fromRgb((int)8026873);
                            if (sums[i] < 0.0) {
                                int n = i;
                                sums[n] = sums[n] * -1.0;
                            }
                            AttributeModifier fakeModif = new AttributeModifier(FAKE_MERGED_ID, sums[i], op);
                            MutableComponent comp = IFormattableAttribute.toComponent((Holder<Attribute>)attr3, fakeModif, flag);
                            tooltip.accept((Component)comp.withStyle(comp.getStyle().withColor(color)));
                            if (!merged[i] || !Screen.hasShiftDown()) continue;
                            ((List)shiftExpands.get(AttributeModifier.Operation.BY_ID.apply(i))).forEach(modif -> tooltip.accept((Component)AttributesLibClient.list().append((Component)IFormattableAttribute.toComponent((Holder<Attribute>)attr3, modif, flag))));
                            continue;
                        }
                        AttributeModifier fakeModif = new AttributeModifier(FAKE_MERGED_ID, sums[i], op);
                        tooltip.accept((Component)IFormattableAttribute.toComponent((Holder<Attribute>)attr3, fakeModif, flag));
                    }
                    continue;
                }
                modifs.forEach(m -> {
                    if (m.amount() != 0.0) {
                        tooltip.accept((Component)IFormattableAttribute.toComponent((Holder<Attribute>)attr3, m, flag));
                    }
                });
            }
        }
    }

    private record BaseModifier(AttributeModifier base, List<AttributeModifier> children) {
    }

    public static class ApothCritParticle
    extends CritParticle {
        public ApothCritParticle(SimpleParticleType type, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            super(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
            this.bCol = 1.0f;
            this.rCol = 0.3f;
            this.gCol = 0.8f;
        }
    }

    public static class ModBusSub {
        @SubscribeEvent
        public static void clientReload(RegisterClientReloadListenersEvent e) {
            e.registerReloadListener((PreparableReloadListener)ALConfig.makeReloader());
        }

        @SubscribeEvent
        public static void particleFactories(RegisterParticleProvidersEvent e) {
            e.registerSprite((ParticleType)ALObjects.Particles.APOTH_CRIT.get(), ApothCritParticle::new);
        }
    }
}

