/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.client;

import dev.shadowsoffire.apothic_attributes.api.AttributeHelper;
import dev.shadowsoffire.apothic_attributes.client.ModifierSource;
import dev.shadowsoffire.apothic_attributes.util.Comparators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public abstract class ModifierSourceType<T> {
    private static final List<ModifierSourceType<?>> SOURCE_TYPES = new ArrayList();
    public static final ModifierSourceType<ItemStack> EQUIPMENT = ModifierSourceType.register(new ModifierSourceType<ItemStack>(){

        @Override
        public void extract(LivingEntity entity, BiConsumer<AttributeModifier, ModifierSource<?>> map) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack item = entity.getItemBySlot(slot);
                item.forEachModifier(slot, (attr, modif) -> map.accept((AttributeModifier)modif, new ModifierSource.ItemModifierSource(item)));
            }
        }

        @Override
        public int getPriority() {
            return 0;
        }
    });
    public static final ModifierSourceType<MobEffectInstance> MOB_EFFECT = ModifierSourceType.register(new ModifierSourceType<MobEffectInstance>(){

        @Override
        public void extract(LivingEntity entity, BiConsumer<AttributeModifier, ModifierSource<?>> map) {
            for (MobEffectInstance effectInst : entity.getActiveEffects()) {
                ((MobEffect)effectInst.getEffect().value()).attributeModifiers.values().forEach(template -> map.accept(template.create(effectInst.getAmplifier()), new ModifierSource.EffectModifierSource(effectInst)));
            }
        }

        @Override
        public int getPriority() {
            return 100;
        }
    });

    public static Collection<ModifierSourceType<?>> getTypes() {
        return Collections.unmodifiableCollection(SOURCE_TYPES);
    }

    public static <T extends ModifierSourceType<?>> T register(T type) {
        SOURCE_TYPES.add(type);
        return type;
    }

    public static Comparator<AttributeModifier> compareBySource(Map<ResourceLocation, ModifierSource<?>> sources) {
        Comparator comp = Comparators.chained(Comparator.comparingInt(a -> ((ModifierSource)sources.get(a.id())).getType().getPriority()), Comparator.comparing(a -> (ModifierSource)sources.get(a.id())), AttributeHelper.modifierComparator());
        return (a1, a2) -> {
            ModifierSource src1 = (ModifierSource)sources.get(a1.id());
            ModifierSource src2 = (ModifierSource)sources.get(a2.id());
            if (src1 != null && src2 != null) {
                return comp.compare(a1, a2);
            }
            return src1 != null ? -1 : (src2 != null ? 1 : 0);
        };
    }

    public abstract void extract(LivingEntity var1, BiConsumer<AttributeModifier, ModifierSource<?>> var2);

    public abstract int getPriority();
}

