/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.mixin;

import dev.shadowsoffire.apothic_attributes.api.IFormattableAttribute;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.common.BooleanAttribute;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={BooleanAttribute.class}, remap=false)
public class BooleanAttributeMixin
implements IFormattableAttribute {
    @Override
    public MutableComponent toValueComponent(@Nullable AttributeModifier.Operation op, double value, TooltipFlag flag) {
        if (op == null) {
            return Component.translatable((String)("apothic_attributes.value.boolean." + (value > 0.0 ? "enabled" : "disabled")));
        }
        if (op == AttributeModifier.Operation.ADD_VALUE && value > 0.0) {
            return Component.translatable((String)"apothic_attributes.value.boolean.enable");
        }
        if (op == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL && (int)value == -1) {
            return Component.translatable((String)"apothic_attributes.value.boolean.force_disable");
        }
        return Component.translatable((String)"apothic_attributes.value.boolean.invalid");
    }

    @Override
    public MutableComponent toComponent(AttributeModifier modif, TooltipFlag flag) {
        Attribute attr = this.ths();
        double value = modif.amount();
        MutableComponent comp = value > 0.0 ? Component.translatable((String)"apothic_attributes.modifier.bool", (Object[])new Object[]{this.toValueComponent(modif.operation(), value, flag), Component.translatable((String)attr.getDescriptionId())}).withStyle(ChatFormatting.BLUE) : Component.translatable((String)"apothic_attributes.modifier.bool", (Object[])new Object[]{this.toValueComponent(modif.operation(), value *= -1.0, flag), Component.translatable((String)attr.getDescriptionId())}).withStyle(ChatFormatting.RED);
        return comp.append(this.getDebugInfo(modif, flag));
    }
}

