/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.mixin;

import com.mojang.datafixers.util.Pair;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.apothic_attributes.api.IFormattableAttribute;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.alchemy.PotionContents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={PotionContents.class}, remap=false)
public class PotionContentsMixin {
    @Redirect(method={"addPotionTooltip(Ljava/lang/Iterable;Ljava/util/function/Consumer;FF)V"}, at=@At(value="INVOKE", target="Ljava/util/List;isEmpty()Z"), require=1)
    private static boolean apothic_attributes_potionTooltips(List<Pair<Holder<Attribute>, AttributeModifier>> list, Iterable<MobEffectInstance> effects, Consumer<Component> tooltips, float durationFactor) {
        if (!list.isEmpty()) {
            tooltips.accept(CommonComponents.EMPTY);
            tooltips.accept((Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            for (Pair<Holder<Attribute>, AttributeModifier> pair : list) {
                tooltips.accept((Component)IFormattableAttribute.toComponent((Holder<Attribute>)((Holder)pair.getFirst()), (AttributeModifier)pair.getSecond(), ApothicAttributes.getTooltipFlag()));
            }
        }
        return true;
    }
}

