/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.core;

import com.fuyuaki.morethanadventure.core.MTACommonConfig;
import com.fuyuaki.morethanadventure.core.registry.MTAPlacers;
import com.fuyuaki.morethanadventure.core.registry.MtaArmorMats;
import com.fuyuaki.morethanadventure.core.registry.MtaBlockEntities;
import com.fuyuaki.morethanadventure.core.registry.MtaBlocks;
import com.fuyuaki.morethanadventure.core.registry.MtaEffects;
import com.fuyuaki.morethanadventure.core.registry.MtaEntityTypes;
import com.fuyuaki.morethanadventure.core.registry.MtaFeatures;
import com.fuyuaki.morethanadventure.core.registry.MtaItems;
import com.fuyuaki.morethanadventure.core.registry.MtaLootModifier;
import com.fuyuaki.morethanadventure.core.registry.MtaParticles;
import com.fuyuaki.morethanadventure.core.registry.MtaSounds;
import com.fuyuaki.morethanadventure.core.registry.MtaTabs;
import com.fuyuaki.morethanadventure.game.worldgen.biomes.MtaBiomes;
import com.fuyuaki.morethanadventure.game.worldgen.biomes.MtaTerrablender;
import com.fuyuaki.morethanadventure.game.worldgen.biomes.surface.MtaSurfaceRules;
import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;
import terrablender.api.SurfaceRuleManager;

@Mod(value="morethanadventure")
public class MTAMod {
    public static final String MODID = "morethanadventure";
    private static final Logger LOGGER = LogUtils.getLogger();

    public MTAMod(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        MtaEntityTypes.register(modEventBus);
        MtaBlockEntities.register(modEventBus);
        MtaBlocks.register(modEventBus);
        MTAPlacers.register(modEventBus);
        MtaItems.register(modEventBus);
        MtaEffects.register(modEventBus);
        MtaFeatures.register(modEventBus);
        MtaParticles.register(modEventBus);
        MtaArmorMats.register(modEventBus);
        MtaBiomes.addBiomes();
        MtaSounds.register(modEventBus);
        MtaLootModifier.register(modEventBus);
        MtaTabs.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MTACommonConfig.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            MtaTerrablender.registerBiomes();
            SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)MODID, (SurfaceRules.RuleSource)MtaSurfaceRules.makeOverworld());
        });
    }

    public static void setupRenderTypes() {
        RenderType transparentRenderType = RenderType.cutoutMipped();
        RenderType cutoutRenderType = RenderType.cutout();
        RenderType translucentRenderType = RenderType.translucent();
        MTAMod.setRenderType((Block)MtaBlocks.CLEAR_QUARTZ_CLUSTER.get(), cutoutRenderType);
        MTAMod.setRenderType((Block)MtaBlocks.GRASSY_DIRT.get(), cutoutRenderType);
        MTAMod.setRenderType((Block)MtaBlocks.PALM_LEAVES.get(), cutoutRenderType);
        MTAMod.setRenderType((Block)MtaBlocks.SWEET_BERRY_LEAVES.get(), cutoutRenderType);
        MTAMod.setRenderType((Block)MtaBlocks.SCATTERED_LEAVES.get(), cutoutRenderType);
    }

    public static void setRenderType(Block block, RenderType renderType) {
        ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)renderType);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Thank you for downloading More Than Adventure!");
    }
}

