/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.datagen;

import com.fuyuaki.morethanadventure.datagen.generators.GenAdvancements;
import com.fuyuaki.morethanadventure.datagen.generators.GenBiomeTags;
import com.fuyuaki.morethanadventure.datagen.generators.GenBlockTags;
import com.fuyuaki.morethanadventure.datagen.generators.GenBlockstate;
import com.fuyuaki.morethanadventure.datagen.generators.GenEntityTags;
import com.fuyuaki.morethanadventure.datagen.generators.GenItemModels;
import com.fuyuaki.morethanadventure.datagen.generators.GenItemTags;
import com.fuyuaki.morethanadventure.datagen.generators.GenLoot;
import com.fuyuaki.morethanadventure.datagen.generators.GenRecipes;
import com.fuyuaki.morethanadventure.datagen.generators.GenSoundDefinition;
import com.fuyuaki.morethanadventure.datagen.generators.GenWorld;
import com.fuyuaki.morethanadventure.datagen.generators.lang.EN_US_LangProvider;
import com.fuyuaki.morethanadventure.datagen.generators.loot.GlobalLootModifiers;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="morethanadventure", bus=EventBusSubscriber.Bus.MOD)
public class DataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        DatapackBuiltinEntriesProvider datapackRegistries = new DatapackBuiltinEntriesProvider(packOutput, event.getLookupProvider(), GenWorld.BUILDER, Set.of("morethanadventure"));
        generator.addProvider(event.includeServer(), (DataProvider)new GenAdvancements(packOutput, datapackRegistries.getRegistryProvider(), existingFileHelper, List.of()));
        generator.addProvider(event.includeServer(), (DataProvider)new GenRecipes(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)GenLoot.create(packOutput, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new GenBlockstate(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new GenItemModels(packOutput, existingFileHelper));
        GenBlockTags blockTagGenerator = (GenBlockTags)generator.addProvider(event.includeServer(), (DataProvider)new GenBlockTags(packOutput, datapackRegistries.getRegistryProvider(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new GenItemTags(packOutput, datapackRegistries.getRegistryProvider(), blockTagGenerator.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new GenBiomeTags(packOutput, datapackRegistries.getRegistryProvider(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new GenEntityTags(packOutput, datapackRegistries.getRegistryProvider(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new GenWorld(packOutput, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new EN_US_LangProvider(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new GenSoundDefinition(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new GlobalLootModifiers(packOutput, datapackRegistries.getRegistryProvider()));
    }
}

