/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.datagen.generators;

import com.fuyuaki.morethanadventure.core.registry.MtaBlocks;
import com.fuyuaki.morethanadventure.world.block.GeyserBlock;
import com.fuyuaki.morethanadventure.world.block.MtaCrops;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class GenBlockstate
extends BlockStateProvider {
    public GenBlockstate(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "morethanadventure", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.logBlock((RotatedPillarBlock)MtaBlocks.PALM_LOG.get());
        this.logBlock((RotatedPillarBlock)MtaBlocks.STRIPPED_PALM_LOG.get());
        this.axisBlock((RotatedPillarBlock)MtaBlocks.PALM_WOOD.get(), this.blockTexture((Block)MtaBlocks.PALM_LOG.get()), this.blockTexture((Block)MtaBlocks.PALM_LOG.get()));
        this.axisBlock((RotatedPillarBlock)MtaBlocks.STRIPPED_PALM_WOOD.get(), this.blockTexture((Block)MtaBlocks.STRIPPED_PALM_LOG.get()), this.blockTexture((Block)MtaBlocks.STRIPPED_PALM_LOG.get()));
        this.blockItem(MtaBlocks.PALM_LOG);
        this.blockItem(MtaBlocks.STRIPPED_PALM_LOG);
        this.blockItem(MtaBlocks.PALM_WOOD);
        this.blockItem(MtaBlocks.STRIPPED_PALM_WOOD);
        this.blockWithItem(MtaBlocks.PALM_PLANKS);
        this.leavesBlock(MtaBlocks.PALM_LEAVES);
        this.saplingBlock(MtaBlocks.PALM_SAPLING);
        this.stairsBlock((StairBlock)MtaBlocks.PALM_STAIRS.get(), this.blockTexture((Block)MtaBlocks.PALM_PLANKS.get()));
        this.slabBlock((SlabBlock)MtaBlocks.PALM_SLAB.get(), this.blockTexture((Block)MtaBlocks.PALM_PLANKS.get()), this.blockTexture((Block)MtaBlocks.PALM_PLANKS.get()));
        this.pressurePlateBlock((PressurePlateBlock)MtaBlocks.PALM_PRESSURE_PLATE.get(), this.blockTexture((Block)MtaBlocks.PALM_PLANKS.get()));
        this.buttonBlock((ButtonBlock)MtaBlocks.PALM_BUTTON.get(), this.blockTexture((Block)MtaBlocks.PALM_PLANKS.get()));
        this.fenceBlock((FenceBlock)MtaBlocks.PALM_FENCE.get(), this.blockTexture((Block)MtaBlocks.PALM_PLANKS.get()));
        this.fenceGateBlock((FenceGateBlock)MtaBlocks.PALM_FENCE_GATE.get(), this.blockTexture((Block)MtaBlocks.PALM_PLANKS.get()));
        this.doorBlockWithRenderType((DoorBlock)MtaBlocks.PALM_DOOR.get(), this.modLoc("block/palm_door_bottom"), this.modLoc("block/palm_door_top"), "cutout");
        this.trapdoorBlockWithRenderType((TrapDoorBlock)MtaBlocks.PALM_TRAPDOOR.get(), this.modLoc("block/palm_trapdoor"), true, "cutout");
        this.blockItem(MtaBlocks.PALM_STAIRS);
        this.blockItem(MtaBlocks.PALM_SLAB);
        this.blockItem(MtaBlocks.PALM_PRESSURE_PLATE);
        this.blockItem(MtaBlocks.PALM_FENCE_GATE);
        this.blockItem(MtaBlocks.PALM_TRAPDOOR, "_bottom");
        this.verticalBlock((Block)MtaBlocks.STONE_GEYSER.get(), Blocks.STONE, Blocks.STONE);
        this.verticalBlock((Block)MtaBlocks.TERRACOTTA_GEYSER.get(), Blocks.TERRACOTTA, Blocks.TERRACOTTA);
        this.verticalBlock((Block)MtaBlocks.NETHERRACK_GEYSER.get(), Blocks.NETHERRACK, Blocks.NETHERRACK);
        this.verticalBlock((Block)((GeyserBlock)((Object)MtaBlocks.BASALT_GEYSER.get())), (Block)ResourceLocation.withDefaultNamespace((String)"block/basalt_top"), (Block)ResourceLocation.withDefaultNamespace((String)"block/basalt_side"));
        this.blockWithItem(MtaBlocks.MOSSY_ANDESITE);
        this.blockWithItem(MtaBlocks.NETHER_IRON_ORE);
        this.blockWithItem(MtaBlocks.NETHER_DIAMOND_ORE);
        this.blockWithItem(MtaBlocks.END_LAPIS_ORE);
        this.blockWithItem(MtaBlocks.END_EMERALD_ORE);
        this.blockWithItem(MtaBlocks.CLEAR_QUARTZ_ORE);
        this.blockWithItem(MtaBlocks.DEEPSLATE_CLEAR_QUARTZ_ORE);
        this.blockWithItem(MtaBlocks.CLEAR_QUARTZ_GROWTH);
        this.blockWithItem(MtaBlocks.DEEPSLATE_CLEAR_QUARTZ_GROWTH);
        this.blockWithItem(MtaBlocks.CALCITE_CLEAR_QUARTZ_GROWTH);
        this.blockWithItem(MtaBlocks.QUARTZ_LAMP);
        this.blockWithItem(MtaBlocks.NETHERITIC_CRYSTAL);
        this.blockWithItem(MtaBlocks.AGATE_ORE);
        this.blockWithItem(MtaBlocks.DEEPSLATE_AGATE_ORE);
        this.blockWithItem(MtaBlocks.ALEXANDRITE_ORE);
        this.blockWithItem(MtaBlocks.DEEPSLATE_ALEXANDRITE_ORE);
        this.blockWithItem(MtaBlocks.AQUAMARINE_ORE);
        this.blockWithItem(MtaBlocks.DEEPSLATE_AQUAMARINE_ORE);
        this.blockWithItem(MtaBlocks.CELESTITE_ORE);
        this.blockWithItem(MtaBlocks.DEEPSLATE_CELESTITE_ORE);
        this.blockWithItem(MtaBlocks.GARNET_ORE);
        this.blockWithItem(MtaBlocks.DEEPSLATE_GARNET_ORE);
        this.blockWithItem(MtaBlocks.MOONSTONE_ORE);
        this.blockWithItem(MtaBlocks.DEEPSLATE_MOONSTONE_ORE);
        this.blockWithItem(MtaBlocks.COBBLED_DIRT);
        this.blockWithItem(MtaBlocks.STONE_TILES);
        this.makeStoneSet(MtaBlocks.STONE_TILES, MtaBlocks.STONE_TILES_STAIRS, MtaBlocks.STONE_TILES_WALL, MtaBlocks.STONE_TILES_SLAB);
        this.blockWithItem(MtaBlocks.SLIGHTLY_DIRTY_STONE_TILES);
        this.makeStoneSet(MtaBlocks.SLIGHTLY_DIRTY_STONE_TILES, MtaBlocks.SLIGHTLY_DIRTY_STONE_TILES_STAIRS, MtaBlocks.SLIGHTLY_DIRTY_STONE_TILES_WALL, MtaBlocks.SLIGHTLY_DIRTY_STONE_TILES_SLAB);
        this.blockWithItem(MtaBlocks.DIRTY_STONE_TILES);
        this.makeStoneSet(MtaBlocks.DIRTY_STONE_TILES, MtaBlocks.DIRTY_STONE_TILES_STAIRS, MtaBlocks.DIRTY_STONE_TILES_WALL, MtaBlocks.DIRTY_STONE_TILES_SLAB);
        this.blockWithItem(MtaBlocks.VERY_DIRTY_STONE_TILES);
        this.makeStoneSet(MtaBlocks.VERY_DIRTY_STONE_TILES, MtaBlocks.VERY_DIRTY_STONE_TILES_STAIRS, MtaBlocks.VERY_DIRTY_STONE_TILES_WALL, MtaBlocks.VERY_DIRTY_STONE_TILES_SLAB);
        this.blockItem(MtaBlocks.SAND_PATH);
        this.blockItem(MtaBlocks.GRASSY_DIRT);
        this.blockItem(MtaBlocks.COARSE_DIRT_PATH);
        this.blockWithItem(MtaBlocks.TERRACOTTA_TILES);
        this.makeStoneSet(Blocks.TERRACOTTA, MtaBlocks.TERRACOTTA_STAIRS, MtaBlocks.TERRACOTTA_WALL, MtaBlocks.TERRACOTTA_SLAB);
        this.makeStoneSet(MtaBlocks.TERRACOTTA_TILES, MtaBlocks.TERRACOTTA_TILES_STAIRS, MtaBlocks.TERRACOTTA_TILES_WALL, MtaBlocks.TERRACOTTA_TILES_SLAB);
        this.blockWithItem(MtaBlocks.WHITE_TERRACOTTA_TILES);
        this.makeStoneSet(Blocks.WHITE_TERRACOTTA, MtaBlocks.WHITE_TERRACOTTA_STAIRS, MtaBlocks.WHITE_TERRACOTTA_WALL, MtaBlocks.WHITE_TERRACOTTA_SLAB);
        this.makeStoneSet(MtaBlocks.WHITE_TERRACOTTA_TILES, MtaBlocks.WHITE_TERRACOTTA_TILES_STAIRS, MtaBlocks.WHITE_TERRACOTTA_TILES_WALL, MtaBlocks.WHITE_TERRACOTTA_TILES_SLAB);
        this.blockWithItem(MtaBlocks.LIGHT_GRAY_TERRACOTTA_TILES);
        this.makeStoneSet(Blocks.LIGHT_GRAY_TERRACOTTA, MtaBlocks.LIGHT_GRAY_TERRACOTTA_STAIRS, MtaBlocks.LIGHT_GRAY_TERRACOTTA_WALL, MtaBlocks.LIGHT_GRAY_TERRACOTTA_SLAB);
        this.makeStoneSet(MtaBlocks.LIGHT_GRAY_TERRACOTTA_TILES, MtaBlocks.LIGHT_GRAY_TERRACOTTA_TILES_STAIRS, MtaBlocks.LIGHT_GRAY_TERRACOTTA_TILES_WALL, MtaBlocks.LIGHT_GRAY_TERRACOTTA_TILES_SLAB);
        this.blockWithItem(MtaBlocks.GRAY_TERRACOTTA_TILES);
        this.makeStoneSet(Blocks.GRAY_TERRACOTTA, MtaBlocks.GRAY_TERRACOTTA_STAIRS, MtaBlocks.GRAY_TERRACOTTA_WALL, MtaBlocks.GRAY_TERRACOTTA_SLAB);
        this.makeStoneSet(MtaBlocks.GRAY_TERRACOTTA_TILES, MtaBlocks.GRAY_TERRACOTTA_TILES_STAIRS, MtaBlocks.GRAY_TERRACOTTA_TILES_WALL, MtaBlocks.GRAY_TERRACOTTA_TILES_SLAB);
        this.blockWithItem(MtaBlocks.BLACK_TERRACOTTA_TILES);
        this.makeStoneSet(Blocks.BLACK_TERRACOTTA, MtaBlocks.BLACK_TERRACOTTA_STAIRS, MtaBlocks.BLACK_TERRACOTTA_WALL, MtaBlocks.BLACK_TERRACOTTA_SLAB);
        this.makeStoneSet(MtaBlocks.BLACK_TERRACOTTA_TILES, MtaBlocks.BLACK_TERRACOTTA_TILES_STAIRS, MtaBlocks.BLACK_TERRACOTTA_TILES_WALL, MtaBlocks.BLACK_TERRACOTTA_TILES_SLAB);
        this.blockWithItem(MtaBlocks.BROWN_TERRACOTTA_TILES);
        this.makeStoneSet(Blocks.BROWN_TERRACOTTA, MtaBlocks.BROWN_TERRACOTTA_STAIRS, MtaBlocks.BROWN_TERRACOTTA_WALL, MtaBlocks.BROWN_TERRACOTTA_SLAB);
        this.makeStoneSet(MtaBlocks.BROWN_TERRACOTTA_TILES, MtaBlocks.BROWN_TERRACOTTA_TILES_STAIRS, MtaBlocks.BROWN_TERRACOTTA_TILES_WALL, MtaBlocks.BROWN_TERRACOTTA_TILES_SLAB);
        this.blockWithItem(MtaBlocks.RED_TERRACOTTA_TILES);
        this.makeStoneSet(Blocks.RED_TERRACOTTA, MtaBlocks.RED_TERRACOTTA_STAIRS, MtaBlocks.RED_TERRACOTTA_WALL, MtaBlocks.RED_TERRACOTTA_SLAB);
        this.makeStoneSet(MtaBlocks.RED_TERRACOTTA_TILES, MtaBlocks.RED_TERRACOTTA_TILES_STAIRS, MtaBlocks.RED_TERRACOTTA_TILES_WALL, MtaBlocks.RED_TERRACOTTA_TILES_SLAB);
        this.blockWithItem(MtaBlocks.ORANGE_TERRACOTTA_TILES);
        this.makeStoneSet(Blocks.ORANGE_TERRACOTTA, MtaBlocks.ORANGE_TERRACOTTA_STAIRS, MtaBlocks.ORANGE_TERRACOTTA_WALL, MtaBlocks.ORANGE_TERRACOTTA_SLAB);
        this.makeStoneSet(MtaBlocks.ORANGE_TERRACOTTA_TILES, MtaBlocks.ORANGE_TERRACOTTA_TILES_STAIRS, MtaBlocks.ORANGE_TERRACOTTA_TILES_WALL, MtaBlocks.ORANGE_TERRACOTTA_TILES_SLAB);
        this.blockWithItem(MtaBlocks.YELLOW_TERRACOTTA_TILES);
        this.makeStoneSet(Blocks.YELLOW_TERRACOTTA, MtaBlocks.YELLOW_TERRACOTTA_STAIRS, MtaBlocks.YELLOW_TERRACOTTA_WALL, MtaBlocks.YELLOW_TERRACOTTA_SLAB);
        this.makeStoneSet(MtaBlocks.YELLOW_TERRACOTTA_TILES, MtaBlocks.YELLOW_TERRACOTTA_TILES_STAIRS, MtaBlocks.YELLOW_TERRACOTTA_TILES_WALL, MtaBlocks.YELLOW_TERRACOTTA_TILES_SLAB);
        this.blockWithItem(MtaBlocks.LIME_TERRACOTTA_TILES);
        this.makeStoneSet(Blocks.LIME_TERRACOTTA, MtaBlocks.LIME_TERRACOTTA_STAIRS, MtaBlocks.LIME_TERRACOTTA_WALL, MtaBlocks.LIME_TERRACOTTA_SLAB);
        this.makeStoneSet(MtaBlocks.LIME_TERRACOTTA_TILES, MtaBlocks.LIME_TERRACOTTA_TILES_STAIRS, MtaBlocks.LIME_TERRACOTTA_TILES_WALL, MtaBlocks.LIME_TERRACOTTA_TILES_SLAB);
        this.blockWithItem(MtaBlocks.GREEN_TERRACOTTA_TILES);
        this.makeStoneSet(Blocks.GREEN_TERRACOTTA, MtaBlocks.GREEN_TERRACOTTA_STAIRS, MtaBlocks.GREEN_TERRACOTTA_WALL, MtaBlocks.GREEN_TERRACOTTA_SLAB);
        this.makeStoneSet(MtaBlocks.GREEN_TERRACOTTA_TILES, MtaBlocks.GREEN_TERRACOTTA_TILES_STAIRS, MtaBlocks.GREEN_TERRACOTTA_TILES_WALL, MtaBlocks.GREEN_TERRACOTTA_TILES_SLAB);
        this.blockWithItem(MtaBlocks.CYAN_TERRACOTTA_TILES);
        this.makeStoneSet(Blocks.CYAN_TERRACOTTA, MtaBlocks.CYAN_TERRACOTTA_STAIRS, MtaBlocks.CYAN_TERRACOTTA_WALL, MtaBlocks.CYAN_TERRACOTTA_SLAB);
        this.makeStoneSet(MtaBlocks.CYAN_TERRACOTTA_TILES, MtaBlocks.CYAN_TERRACOTTA_TILES_STAIRS, MtaBlocks.CYAN_TERRACOTTA_TILES_WALL, MtaBlocks.CYAN_TERRACOTTA_TILES_SLAB);
        this.blockWithItem(MtaBlocks.LIGHT_BLUE_TERRACOTTA_TILES);
        this.makeStoneSet(Blocks.LIGHT_BLUE_TERRACOTTA, MtaBlocks.LIGHT_BLUE_TERRACOTTA_STAIRS, MtaBlocks.LIGHT_BLUE_TERRACOTTA_WALL, MtaBlocks.LIGHT_BLUE_TERRACOTTA_SLAB);
        this.makeStoneSet(MtaBlocks.LIGHT_BLUE_TERRACOTTA_TILES, MtaBlocks.LIGHT_BLUE_TERRACOTTA_TILES_STAIRS, MtaBlocks.LIGHT_BLUE_TERRACOTTA_TILES_WALL, MtaBlocks.LIGHT_BLUE_TERRACOTTA_TILES_SLAB);
        this.blockWithItem(MtaBlocks.BLUE_TERRACOTTA_TILES);
        this.makeStoneSet(Blocks.BLUE_TERRACOTTA, MtaBlocks.BLUE_TERRACOTTA_STAIRS, MtaBlocks.BLUE_TERRACOTTA_WALL, MtaBlocks.BLUE_TERRACOTTA_SLAB);
        this.makeStoneSet(MtaBlocks.BLUE_TERRACOTTA_TILES, MtaBlocks.BLUE_TERRACOTTA_TILES_STAIRS, MtaBlocks.BLUE_TERRACOTTA_TILES_WALL, MtaBlocks.BLUE_TERRACOTTA_TILES_SLAB);
        this.blockWithItem(MtaBlocks.PURPLE_TERRACOTTA_TILES);
        this.makeStoneSet(Blocks.PURPLE_TERRACOTTA, MtaBlocks.PURPLE_TERRACOTTA_STAIRS, MtaBlocks.PURPLE_TERRACOTTA_WALL, MtaBlocks.PURPLE_TERRACOTTA_SLAB);
        this.makeStoneSet(MtaBlocks.PURPLE_TERRACOTTA_TILES, MtaBlocks.PURPLE_TERRACOTTA_TILES_STAIRS, MtaBlocks.PURPLE_TERRACOTTA_TILES_WALL, MtaBlocks.PURPLE_TERRACOTTA_TILES_SLAB);
        this.blockWithItem(MtaBlocks.MAGENTA_TERRACOTTA_TILES);
        this.makeStoneSet(Blocks.MAGENTA_TERRACOTTA, MtaBlocks.MAGENTA_TERRACOTTA_STAIRS, MtaBlocks.MAGENTA_TERRACOTTA_WALL, MtaBlocks.MAGENTA_TERRACOTTA_SLAB);
        this.makeStoneSet(MtaBlocks.MAGENTA_TERRACOTTA_TILES, MtaBlocks.MAGENTA_TERRACOTTA_TILES_STAIRS, MtaBlocks.MAGENTA_TERRACOTTA_TILES_WALL, MtaBlocks.MAGENTA_TERRACOTTA_TILES_SLAB);
        this.blockWithItem(MtaBlocks.PINK_TERRACOTTA_TILES);
        this.makeStoneSet(Blocks.PINK_TERRACOTTA, MtaBlocks.PINK_TERRACOTTA_STAIRS, MtaBlocks.PINK_TERRACOTTA_WALL, MtaBlocks.PINK_TERRACOTTA_SLAB);
        this.makeStoneSet(MtaBlocks.PINK_TERRACOTTA_TILES, MtaBlocks.PINK_TERRACOTTA_TILES_STAIRS, MtaBlocks.PINK_TERRACOTTA_TILES_WALL, MtaBlocks.PINK_TERRACOTTA_TILES_SLAB);
        this.makeStoneSet(Blocks.WHITE_CONCRETE, MtaBlocks.WHITE_CONCRETE_STAIRS, MtaBlocks.WHITE_CONCRETE_WALL, MtaBlocks.WHITE_CONCRETE_SLAB);
        this.makeStoneSet(Blocks.LIGHT_GRAY_CONCRETE, MtaBlocks.LIGHT_GRAY_CONCRETE_STAIRS, MtaBlocks.LIGHT_GRAY_CONCRETE_WALL, MtaBlocks.LIGHT_GRAY_CONCRETE_SLAB);
        this.makeStoneSet(Blocks.GRAY_CONCRETE, MtaBlocks.GRAY_CONCRETE_STAIRS, MtaBlocks.GRAY_CONCRETE_WALL, MtaBlocks.GRAY_CONCRETE_SLAB);
        this.makeStoneSet(Blocks.BLACK_CONCRETE, MtaBlocks.BLACK_CONCRETE_STAIRS, MtaBlocks.BLACK_CONCRETE_WALL, MtaBlocks.BLACK_CONCRETE_SLAB);
        this.makeStoneSet(Blocks.BROWN_CONCRETE, MtaBlocks.BROWN_CONCRETE_STAIRS, MtaBlocks.BROWN_CONCRETE_WALL, MtaBlocks.BROWN_CONCRETE_SLAB);
        this.makeStoneSet(Blocks.RED_CONCRETE, MtaBlocks.RED_CONCRETE_STAIRS, MtaBlocks.RED_CONCRETE_WALL, MtaBlocks.RED_CONCRETE_SLAB);
        this.makeStoneSet(Blocks.ORANGE_CONCRETE, MtaBlocks.ORANGE_CONCRETE_STAIRS, MtaBlocks.ORANGE_CONCRETE_WALL, MtaBlocks.ORANGE_CONCRETE_SLAB);
        this.makeStoneSet(Blocks.YELLOW_CONCRETE, MtaBlocks.YELLOW_CONCRETE_STAIRS, MtaBlocks.YELLOW_CONCRETE_WALL, MtaBlocks.YELLOW_CONCRETE_SLAB);
        this.makeStoneSet(Blocks.LIME_CONCRETE, MtaBlocks.LIME_CONCRETE_STAIRS, MtaBlocks.LIME_CONCRETE_WALL, MtaBlocks.LIME_CONCRETE_SLAB);
        this.makeStoneSet(Blocks.GREEN_CONCRETE, MtaBlocks.GREEN_CONCRETE_STAIRS, MtaBlocks.GREEN_CONCRETE_WALL, MtaBlocks.GREEN_CONCRETE_SLAB);
        this.makeStoneSet(Blocks.CYAN_CONCRETE, MtaBlocks.CYAN_CONCRETE_STAIRS, MtaBlocks.CYAN_CONCRETE_WALL, MtaBlocks.CYAN_CONCRETE_SLAB);
        this.makeStoneSet(Blocks.LIGHT_BLUE_CONCRETE, MtaBlocks.LIGHT_BLUE_CONCRETE_STAIRS, MtaBlocks.LIGHT_BLUE_CONCRETE_WALL, MtaBlocks.LIGHT_BLUE_CONCRETE_SLAB);
        this.makeStoneSet(Blocks.BLUE_CONCRETE, MtaBlocks.BLUE_CONCRETE_STAIRS, MtaBlocks.BLUE_CONCRETE_WALL, MtaBlocks.BLUE_CONCRETE_SLAB);
        this.makeStoneSet(Blocks.PURPLE_CONCRETE, MtaBlocks.PURPLE_CONCRETE_STAIRS, MtaBlocks.PURPLE_CONCRETE_WALL, MtaBlocks.PURPLE_CONCRETE_SLAB);
        this.makeStoneSet(Blocks.MAGENTA_CONCRETE, MtaBlocks.MAGENTA_CONCRETE_STAIRS, MtaBlocks.MAGENTA_CONCRETE_WALL, MtaBlocks.MAGENTA_CONCRETE_SLAB);
        this.makeStoneSet(Blocks.PINK_CONCRETE, MtaBlocks.PINK_CONCRETE_STAIRS, MtaBlocks.PINK_CONCRETE_WALL, MtaBlocks.PINK_CONCRETE_SLAB);
        this.makeCrop((MtaCrops)((Object)MtaBlocks.ONION_CROP.get()), "onion_stage", "onion_stage");
        this.makeCrop((MtaCrops)((Object)MtaBlocks.TOMATO_CROP.get()), "tomato_stage", "tomato_stage");
        this.makeCrop((MtaCrops)((Object)MtaBlocks.BELL_PEPPER_CROP.get()), "bell_pepper_stage", "bell_pepper_stage");
        this.makeCrop((MtaCrops)((Object)MtaBlocks.CHILI_PEPPER_CROP.get()), "chili_stage", "chili_stage");
    }

    private void blockWithItem(DeferredBlock<? extends Block> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), this.cubeAll((Block)deferredBlock.get()));
    }

    private <T extends Block> void makeStoneSet(DeferredBlock<T> texture, DeferredBlock<T> stairs, DeferredBlock<T> wall, DeferredBlock<T> slab) {
        this.makeStairs(stairs, texture);
        this.makeSlab(slab, texture, texture);
        this.makeWall(wall, texture);
    }

    private <T extends Block> void makeStoneSet(Block texture, DeferredBlock<T> stairs, DeferredBlock<T> wall, DeferredBlock<T> slab) {
        this.makeStairs(stairs, texture);
        this.makeSlab(slab, texture, texture);
        this.makeWall(wall, texture);
    }

    private <T extends Block> void makeStairs(DeferredBlock<T> deferredBlock, DeferredBlock<T> texture) {
        this.stairsBlock((StairBlock)deferredBlock.get(), this.blockTexture((Block)texture.get()));
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)this.models().stairs(this.name((Block)deferredBlock.get()), this.blockTexture((Block)texture.get()), this.blockTexture((Block)texture.get()), this.blockTexture((Block)texture.get())));
    }

    private <T extends Block> void makeStairs(DeferredBlock<T> deferredBlock, Block texture) {
        this.stairsBlock((StairBlock)deferredBlock.get(), this.blockTexture(texture));
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)this.models().stairs(this.name((Block)deferredBlock.get()), this.blockTexture(texture), this.blockTexture(texture), this.blockTexture(texture)));
    }

    private <T extends Block> void makeSlab(DeferredBlock<T> deferredBlock, DeferredBlock<T> doubleSlab, DeferredBlock<T> halfSlab) {
        this.slabBlock((SlabBlock)deferredBlock.get(), this.blockTexture((Block)doubleSlab.get()), this.blockTexture((Block)halfSlab.get()));
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)this.models().slab(this.name((Block)deferredBlock.get()), this.blockTexture((Block)doubleSlab.get()), this.blockTexture((Block)halfSlab.get()), this.blockTexture((Block)halfSlab.get())));
    }

    private <T extends Block> void makeSlab(DeferredBlock<T> deferredBlock, Block doubleSlab, Block halfSlab) {
        this.slabBlock((SlabBlock)deferredBlock.get(), this.blockTexture(doubleSlab), this.blockTexture(halfSlab));
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)this.models().slab(this.name((Block)deferredBlock.get()), this.blockTexture(doubleSlab), this.blockTexture(halfSlab), this.blockTexture(halfSlab)));
    }

    private <T extends Block> void makeWall(DeferredBlock<T> deferredBlock, DeferredBlock<T> texture) {
        this.wallBlock((WallBlock)deferredBlock.get(), this.blockTexture((Block)texture.get()));
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)this.models().wallInventory(this.name((Block)deferredBlock.get()) + "_inventory", this.blockTexture((Block)texture.get())));
    }

    private <T extends Block> void makeWall(DeferredBlock<T> deferredBlock, Block texture) {
        this.wallBlock((WallBlock)deferredBlock.get(), this.blockTexture(texture));
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)this.models().wallInventory(this.name((Block)deferredBlock.get()) + "_inventory", this.blockTexture(texture)));
    }

    private <T extends Block> void makeFence(DeferredBlock<? extends FenceBlock> deferredBlock, DeferredBlock<T> texture) {
        this.fenceBlock((FenceBlock)deferredBlock.get(), this.blockTexture((Block)texture.get()));
    }

    private <T extends Block> void blockItem(DeferredBlock<T> deferredBlock) {
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)this.models().getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"morethanadventure", (String)this.name((Block)deferredBlock.get()))));
    }

    private <T extends Block> void blockItem(DeferredBlock<T> deferredBlock, String appendix) {
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)new ModelFile.UncheckedModelFile("morethanadventure:block/" + deferredBlock.getId().getPath() + appendix));
    }

    private void leavesBlock(DeferredBlock<Block> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture(BuiltInRegistries.BLOCK.getKey((Object)((Block)deferredBlock.get())).getPath(), ResourceLocation.parse((String)"minecraft:block/leaves"), "all", this.blockTexture((Block)deferredBlock.get()))).renderType("cutout"));
    }

    private void saplingBlock(DeferredBlock<Block> deferredBlock) {
        this.simpleBlock((Block)deferredBlock.get(), (ModelFile)((BlockModelBuilder)this.models().cross(BuiltInRegistries.BLOCK.getKey((Object)((Block)deferredBlock.get())).getPath(), this.blockTexture((Block)deferredBlock.get()))).renderType("cutout"));
    }

    public <T extends Block> void plantBlock(T block, T potBLock, ResourceLocation texture) {
        ModelBuilder sign = this.models().cross(this.name(block), texture);
        ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.key(potBLock).getPath())).texture("plant", texture)).parent((ModelFile)this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)"block/flower_pot_cross")));
        this.cross(block, (ModelFile)sign);
    }

    public <T extends Block> void cross(T block, ResourceLocation texture) {
        ModelBuilder blockModel = this.models().cross(this.name(block), texture);
        this.cross(block, (ModelFile)blockModel);
    }

    public <T extends Block> void cross(T block, ModelFile blockModel) {
        this.simpleBlock(block, blockModel);
    }

    private <T extends Block> String name(T block) {
        return this.key(block).getPath();
    }

    private <T extends Block> ResourceLocation key(T block) {
        return BuiltInRegistries.BLOCK.getKey(block);
    }

    public <T extends Block> void verticalBlock(T block, ResourceLocation side_texture, ResourceLocation bottom_texture) {
        ModelBuilder blockModel = ((BlockModelBuilder)this.models().cube(this.name(block), bottom_texture, this.blockTexture(block), side_texture, side_texture, side_texture, side_texture)).texture("particle", this.blockTexture(block));
        this.simpleBlock(block, (ModelFile)blockModel);
        this.simpleBlockItem(block, (ModelFile)blockModel);
    }

    public <T extends Block> void verticalBlock(T block, T side_texture, T bottom_texture) {
        ModelBuilder blockModel = ((BlockModelBuilder)this.models().cube(this.name(block), this.blockTexture(bottom_texture), this.blockTexture(block), this.blockTexture(side_texture), this.blockTexture(side_texture), this.blockTexture(side_texture), this.blockTexture(side_texture))).texture("particle", this.blockTexture(block));
        this.simpleBlock(block, (ModelFile)blockModel);
        this.simpleBlockItem(block, (ModelFile)blockModel);
    }

    public void makeCrop(CropBlock block, String modelName, String textureName) {
        Function<BlockState, ConfiguredModel[]> function = state -> this.statesForCrop((BlockState)state, block, modelName, textureName);
        this.getVariantBuilder((Block)block).forAllStates(function);
    }

    private ConfiguredModel[] statesForCrop(BlockState state, CropBlock block, String modelName, String textureName) {
        ConfiguredModel[] models = new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().crop(modelName + String.valueOf(state.getValue((Property)((MtaCrops)block).getAgeProperty())), ResourceLocation.fromNamespaceAndPath((String)"morethanadventure", (String)("block/" + textureName + String.valueOf(state.getValue((Property)((MtaCrops)block).getAgeProperty())))))).renderType("cutout"))};
        return models;
    }
}

