/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.datagen.generators.loot;

import com.fuyuaki.morethanadventure.core.registry.MtaBlocks;
import com.fuyuaki.morethanadventure.core.registry.MtaItems;
import com.fuyuaki.morethanadventure.world.block.OnionCropBlock;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootBlocks
extends BlockLootSubProvider {
    List<Block> excludedBlocks = List.of();
    List<Block> knownBlocks = MtaBlocks.BLOCKS.getEntries().stream().map(Holder::value).collect(Collectors.toList());
    protected static final float[] PALM_LEAVES_SAPLING_CHANCES = new float[]{0.1f, 0.2f, 0.4f, 0.6f};

    public LootBlocks(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected void generate() {
        this.add((Block)MtaBlocks.SCATTERED_LEAVES.get(), this.createPetalsDrops((Block)MtaBlocks.SCATTERED_LEAVES.get()));
        this.dropSelf((Block)MtaBlocks.PALM_LOG.get());
        this.dropSelf((Block)MtaBlocks.PALM_WOOD.get());
        this.dropSelf((Block)MtaBlocks.STRIPPED_PALM_LOG.get());
        this.dropSelf((Block)MtaBlocks.STRIPPED_PALM_WOOD.get());
        this.dropSelf((Block)MtaBlocks.PALM_PLANKS.get());
        this.add((Block)MtaBlocks.PALM_LEAVES.get(), block -> this.createPalmLeavesDrops((Block)block, (Item)MtaItems.COCONUT.get(), PALM_LEAVES_SAPLING_CHANCES));
        this.dropSelf((Block)MtaBlocks.PALM_SAPLING.get());
        this.dropSelf((Block)MtaBlocks.PALM_STAIRS.get());
        this.add((Block)MtaBlocks.PALM_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.PALM_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.PALM_PRESSURE_PLATE.get());
        this.dropSelf((Block)MtaBlocks.PALM_BUTTON.get());
        this.dropSelf((Block)MtaBlocks.PALM_FENCE.get());
        this.dropSelf((Block)MtaBlocks.PALM_FENCE_GATE.get());
        this.add((Block)MtaBlocks.PALM_DOOR.get(), block -> this.createDoorTable((Block)MtaBlocks.PALM_DOOR.get()));
        this.dropSelf((Block)MtaBlocks.PALM_TRAPDOOR.get());
        this.dropSelf((Block)MtaBlocks.SPRINKLER.get());
        this.dropSelf((Block)MtaBlocks.MOSSY_ANDESITE.get());
        this.add((Block)MtaBlocks.STONE_GEYSER.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.COBBLESTONE));
        this.add((Block)MtaBlocks.TERRACOTTA_GEYSER.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.TERRACOTTA));
        this.add((Block)MtaBlocks.NETHERRACK_GEYSER.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.NETHERRACK));
        this.add((Block)MtaBlocks.BASALT_GEYSER.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.BASALT));
        this.add((Block)MtaBlocks.NETHER_IRON_ORE.get(), block -> this.createOreDrop((Block)block, Items.RAW_IRON));
        this.add((Block)MtaBlocks.NETHER_DIAMOND_ORE.get(), block -> this.createOreDrop((Block)block, Items.DIAMOND));
        this.add((Block)MtaBlocks.END_EMERALD_ORE.get(), block -> this.createOreDrop((Block)block, Items.EMERALD_BLOCK));
        this.add((Block)MtaBlocks.END_LAPIS_ORE.get(), x$0 -> this.createLapisOreDrops((Block)x$0));
        this.add((Block)MtaBlocks.CLEAR_QUARTZ_ORE.get(), block -> this.createOreDrop((Block)block, (Item)MtaItems.CLEAR_QUARTZ.get()));
        this.add((Block)MtaBlocks.DEEPSLATE_CLEAR_QUARTZ_ORE.get(), block -> this.createOreDrop((Block)block, (Item)MtaItems.CLEAR_QUARTZ.get()));
        this.add((Block)MtaBlocks.CLEAR_QUARTZ_CLUSTER.get(), block -> this.createOreDrop((Block)block, (Item)MtaItems.CLEAR_QUARTZ.get()));
        this.add((Block)MtaBlocks.CLEAR_QUARTZ_GROWTH.get(), block -> this.createSingleItemTable((ItemLike)Blocks.STONE));
        this.add((Block)MtaBlocks.DEEPSLATE_CLEAR_QUARTZ_GROWTH.get(), block -> this.createSingleItemTable((ItemLike)Blocks.DEEPSLATE));
        this.add((Block)MtaBlocks.CALCITE_CLEAR_QUARTZ_GROWTH.get(), block -> this.createSingleItemTable((ItemLike)Blocks.CALCITE));
        this.dropSelf((Block)MtaBlocks.QUARTZ_LAMP.get());
        this.dropSelf((Block)MtaBlocks.COBBLED_DIRT.get());
        this.dropSelf((Block)MtaBlocks.STONE_TILES.get());
        this.add((Block)MtaBlocks.STONE_TILES_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.STONE_TILES_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.STONE_TILES_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.STONE_TILES_WALL.get());
        this.dropSelf((Block)MtaBlocks.SLIGHTLY_DIRTY_STONE_TILES.get());
        this.add((Block)MtaBlocks.SLIGHTLY_DIRTY_STONE_TILES_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.SLIGHTLY_DIRTY_STONE_TILES_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.SLIGHTLY_DIRTY_STONE_TILES_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.SLIGHTLY_DIRTY_STONE_TILES_WALL.get());
        this.dropSelf((Block)MtaBlocks.DIRTY_STONE_TILES.get());
        this.add((Block)MtaBlocks.DIRTY_STONE_TILES_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.DIRTY_STONE_TILES_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.DIRTY_STONE_TILES_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.DIRTY_STONE_TILES_WALL.get());
        this.dropSelf((Block)MtaBlocks.VERY_DIRTY_STONE_TILES.get());
        this.add((Block)MtaBlocks.VERY_DIRTY_STONE_TILES_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.VERY_DIRTY_STONE_TILES_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.VERY_DIRTY_STONE_TILES_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.VERY_DIRTY_STONE_TILES_WALL.get());
        this.add((Block)MtaBlocks.NETHERITIC_CRYSTAL.get(), block -> this.createOreDrop((Block)block, (Item)MtaItems.NETHERITE_FRACTURE.get()));
        this.add((Block)MtaBlocks.SAND_PATH.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.SAND));
        this.add((Block)MtaBlocks.GRASSY_DIRT.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.DIRT));
        this.add((Block)MtaBlocks.COARSE_DIRT_PATH.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.DIRT));
        this.add((Block)MtaBlocks.SWEET_BERRY_LEAVES.get(), block -> this.createLeavesDrops((Block)block, Blocks.SPRUCE_SAPLING, new float[]{0.1f}));
        this.dropSelf((Block)MtaBlocks.TERRACOTTA_TILES.get());
        this.add((Block)MtaBlocks.TERRACOTTA_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.TERRACOTTA_SLAB.get()));
        this.add((Block)MtaBlocks.TERRACOTTA_TILES_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.TERRACOTTA_TILES_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.TERRACOTTA_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.TERRACOTTA_TILES_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.TERRACOTTA_WALL.get());
        this.dropSelf((Block)MtaBlocks.TERRACOTTA_TILES_WALL.get());
        this.dropSelf((Block)MtaBlocks.WHITE_TERRACOTTA_TILES.get());
        this.add((Block)MtaBlocks.WHITE_TERRACOTTA_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.WHITE_TERRACOTTA_SLAB.get()));
        this.add((Block)MtaBlocks.WHITE_TERRACOTTA_TILES_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.WHITE_TERRACOTTA_TILES_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.WHITE_TERRACOTTA_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.WHITE_TERRACOTTA_TILES_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.WHITE_TERRACOTTA_WALL.get());
        this.dropSelf((Block)MtaBlocks.WHITE_TERRACOTTA_TILES_WALL.get());
        this.dropSelf((Block)MtaBlocks.LIGHT_GRAY_TERRACOTTA_TILES.get());
        this.add((Block)MtaBlocks.LIGHT_GRAY_TERRACOTTA_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.LIGHT_GRAY_TERRACOTTA_SLAB.get()));
        this.add((Block)MtaBlocks.LIGHT_GRAY_TERRACOTTA_TILES_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.LIGHT_GRAY_TERRACOTTA_TILES_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.LIGHT_GRAY_TERRACOTTA_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.LIGHT_GRAY_TERRACOTTA_TILES_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.LIGHT_GRAY_TERRACOTTA_WALL.get());
        this.dropSelf((Block)MtaBlocks.LIGHT_GRAY_TERRACOTTA_TILES_WALL.get());
        this.dropSelf((Block)MtaBlocks.GRAY_TERRACOTTA_TILES.get());
        this.add((Block)MtaBlocks.GRAY_TERRACOTTA_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.GRAY_TERRACOTTA_SLAB.get()));
        this.add((Block)MtaBlocks.GRAY_TERRACOTTA_TILES_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.GRAY_TERRACOTTA_TILES_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.GRAY_TERRACOTTA_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.GRAY_TERRACOTTA_TILES_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.GRAY_TERRACOTTA_WALL.get());
        this.dropSelf((Block)MtaBlocks.GRAY_TERRACOTTA_TILES_WALL.get());
        this.dropSelf((Block)MtaBlocks.BLACK_TERRACOTTA_TILES.get());
        this.add((Block)MtaBlocks.BLACK_TERRACOTTA_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.BLACK_TERRACOTTA_SLAB.get()));
        this.add((Block)MtaBlocks.BLACK_TERRACOTTA_TILES_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.BLACK_TERRACOTTA_TILES_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.BLACK_TERRACOTTA_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.BLACK_TERRACOTTA_TILES_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.BLACK_TERRACOTTA_WALL.get());
        this.dropSelf((Block)MtaBlocks.BLACK_TERRACOTTA_TILES_WALL.get());
        this.dropSelf((Block)MtaBlocks.BROWN_TERRACOTTA_TILES.get());
        this.add((Block)MtaBlocks.BROWN_TERRACOTTA_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.BROWN_TERRACOTTA_SLAB.get()));
        this.add((Block)MtaBlocks.BROWN_TERRACOTTA_TILES_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.BROWN_TERRACOTTA_TILES_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.BROWN_TERRACOTTA_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.BROWN_TERRACOTTA_TILES_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.BROWN_TERRACOTTA_WALL.get());
        this.dropSelf((Block)MtaBlocks.BROWN_TERRACOTTA_TILES_WALL.get());
        this.dropSelf((Block)MtaBlocks.RED_TERRACOTTA_TILES.get());
        this.add((Block)MtaBlocks.RED_TERRACOTTA_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.RED_TERRACOTTA_SLAB.get()));
        this.add((Block)MtaBlocks.RED_TERRACOTTA_TILES_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.RED_TERRACOTTA_TILES_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.RED_TERRACOTTA_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.RED_TERRACOTTA_TILES_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.RED_TERRACOTTA_WALL.get());
        this.dropSelf((Block)MtaBlocks.RED_TERRACOTTA_TILES_WALL.get());
        this.dropSelf((Block)MtaBlocks.ORANGE_TERRACOTTA_TILES.get());
        this.add((Block)MtaBlocks.ORANGE_TERRACOTTA_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.ORANGE_TERRACOTTA_SLAB.get()));
        this.add((Block)MtaBlocks.ORANGE_TERRACOTTA_TILES_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.ORANGE_TERRACOTTA_TILES_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.ORANGE_TERRACOTTA_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.ORANGE_TERRACOTTA_TILES_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.ORANGE_TERRACOTTA_WALL.get());
        this.dropSelf((Block)MtaBlocks.ORANGE_TERRACOTTA_TILES_WALL.get());
        this.dropSelf((Block)MtaBlocks.YELLOW_TERRACOTTA_TILES.get());
        this.add((Block)MtaBlocks.YELLOW_TERRACOTTA_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.YELLOW_TERRACOTTA_SLAB.get()));
        this.add((Block)MtaBlocks.YELLOW_TERRACOTTA_TILES_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.YELLOW_TERRACOTTA_TILES_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.YELLOW_TERRACOTTA_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.YELLOW_TERRACOTTA_TILES_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.YELLOW_TERRACOTTA_WALL.get());
        this.dropSelf((Block)MtaBlocks.YELLOW_TERRACOTTA_TILES_WALL.get());
        this.dropSelf((Block)MtaBlocks.LIME_TERRACOTTA_TILES.get());
        this.add((Block)MtaBlocks.LIME_TERRACOTTA_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.LIME_TERRACOTTA_SLAB.get()));
        this.add((Block)MtaBlocks.LIME_TERRACOTTA_TILES_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.LIME_TERRACOTTA_TILES_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.LIME_TERRACOTTA_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.LIME_TERRACOTTA_TILES_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.LIME_TERRACOTTA_WALL.get());
        this.dropSelf((Block)MtaBlocks.LIME_TERRACOTTA_TILES_WALL.get());
        this.dropSelf((Block)MtaBlocks.GREEN_TERRACOTTA_TILES.get());
        this.add((Block)MtaBlocks.GREEN_TERRACOTTA_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.GREEN_TERRACOTTA_SLAB.get()));
        this.add((Block)MtaBlocks.GREEN_TERRACOTTA_TILES_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.GREEN_TERRACOTTA_TILES_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.GREEN_TERRACOTTA_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.GREEN_TERRACOTTA_TILES_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.GREEN_TERRACOTTA_WALL.get());
        this.dropSelf((Block)MtaBlocks.GREEN_TERRACOTTA_TILES_WALL.get());
        this.dropSelf((Block)MtaBlocks.CYAN_TERRACOTTA_TILES.get());
        this.add((Block)MtaBlocks.CYAN_TERRACOTTA_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.CYAN_TERRACOTTA_SLAB.get()));
        this.add((Block)MtaBlocks.CYAN_TERRACOTTA_TILES_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.CYAN_TERRACOTTA_TILES_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.CYAN_TERRACOTTA_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.CYAN_TERRACOTTA_TILES_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.CYAN_TERRACOTTA_WALL.get());
        this.dropSelf((Block)MtaBlocks.CYAN_TERRACOTTA_TILES_WALL.get());
        this.dropSelf((Block)MtaBlocks.LIGHT_BLUE_TERRACOTTA_TILES.get());
        this.add((Block)MtaBlocks.LIGHT_BLUE_TERRACOTTA_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.LIGHT_BLUE_TERRACOTTA_SLAB.get()));
        this.add((Block)MtaBlocks.LIGHT_BLUE_TERRACOTTA_TILES_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.LIGHT_BLUE_TERRACOTTA_TILES_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.LIGHT_BLUE_TERRACOTTA_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.LIGHT_BLUE_TERRACOTTA_TILES_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.LIGHT_BLUE_TERRACOTTA_WALL.get());
        this.dropSelf((Block)MtaBlocks.LIGHT_BLUE_TERRACOTTA_TILES_WALL.get());
        this.dropSelf((Block)MtaBlocks.BLUE_TERRACOTTA_TILES.get());
        this.add((Block)MtaBlocks.BLUE_TERRACOTTA_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.BLUE_TERRACOTTA_SLAB.get()));
        this.add((Block)MtaBlocks.BLUE_TERRACOTTA_TILES_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.BLUE_TERRACOTTA_TILES_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.BLUE_TERRACOTTA_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.BLUE_TERRACOTTA_TILES_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.BLUE_TERRACOTTA_WALL.get());
        this.dropSelf((Block)MtaBlocks.BLUE_TERRACOTTA_TILES_WALL.get());
        this.dropSelf((Block)MtaBlocks.PURPLE_TERRACOTTA_TILES.get());
        this.add((Block)MtaBlocks.PURPLE_TERRACOTTA_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.PURPLE_TERRACOTTA_SLAB.get()));
        this.add((Block)MtaBlocks.PURPLE_TERRACOTTA_TILES_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.PURPLE_TERRACOTTA_TILES_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.PURPLE_TERRACOTTA_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.PURPLE_TERRACOTTA_TILES_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.PURPLE_TERRACOTTA_WALL.get());
        this.dropSelf((Block)MtaBlocks.PURPLE_TERRACOTTA_TILES_WALL.get());
        this.dropSelf((Block)MtaBlocks.MAGENTA_TERRACOTTA_TILES.get());
        this.add((Block)MtaBlocks.MAGENTA_TERRACOTTA_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.MAGENTA_TERRACOTTA_SLAB.get()));
        this.add((Block)MtaBlocks.MAGENTA_TERRACOTTA_TILES_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.MAGENTA_TERRACOTTA_TILES_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.MAGENTA_TERRACOTTA_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.MAGENTA_TERRACOTTA_TILES_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.MAGENTA_TERRACOTTA_WALL.get());
        this.dropSelf((Block)MtaBlocks.MAGENTA_TERRACOTTA_TILES_WALL.get());
        this.dropSelf((Block)MtaBlocks.PINK_TERRACOTTA_TILES.get());
        this.add((Block)MtaBlocks.PINK_TERRACOTTA_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.PINK_TERRACOTTA_SLAB.get()));
        this.add((Block)MtaBlocks.PINK_TERRACOTTA_TILES_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.PINK_TERRACOTTA_TILES_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.PINK_TERRACOTTA_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.PINK_TERRACOTTA_TILES_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.PINK_TERRACOTTA_WALL.get());
        this.dropSelf((Block)MtaBlocks.PINK_TERRACOTTA_TILES_WALL.get());
        this.add((Block)MtaBlocks.WHITE_CONCRETE_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.WHITE_CONCRETE_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.WHITE_CONCRETE_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.WHITE_CONCRETE_WALL.get());
        this.add((Block)MtaBlocks.LIGHT_GRAY_CONCRETE_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.LIGHT_GRAY_CONCRETE_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.LIGHT_GRAY_CONCRETE_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.LIGHT_GRAY_CONCRETE_WALL.get());
        this.add((Block)MtaBlocks.GRAY_CONCRETE_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.GRAY_CONCRETE_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.GRAY_CONCRETE_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.GRAY_CONCRETE_WALL.get());
        this.add((Block)MtaBlocks.BLACK_CONCRETE_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.BLACK_CONCRETE_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.BLACK_CONCRETE_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.BLACK_CONCRETE_WALL.get());
        this.add((Block)MtaBlocks.BROWN_CONCRETE_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.BROWN_CONCRETE_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.BROWN_CONCRETE_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.BROWN_CONCRETE_WALL.get());
        this.add((Block)MtaBlocks.RED_CONCRETE_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.RED_CONCRETE_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.RED_CONCRETE_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.RED_CONCRETE_WALL.get());
        this.add((Block)MtaBlocks.ORANGE_CONCRETE_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.ORANGE_CONCRETE_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.ORANGE_CONCRETE_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.ORANGE_CONCRETE_WALL.get());
        this.add((Block)MtaBlocks.YELLOW_CONCRETE_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.YELLOW_CONCRETE_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.YELLOW_CONCRETE_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.YELLOW_CONCRETE_WALL.get());
        this.add((Block)MtaBlocks.LIME_CONCRETE_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.LIME_CONCRETE_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.LIME_CONCRETE_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.LIME_CONCRETE_WALL.get());
        this.add((Block)MtaBlocks.GREEN_CONCRETE_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.GREEN_CONCRETE_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.GREEN_CONCRETE_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.GREEN_CONCRETE_WALL.get());
        this.add((Block)MtaBlocks.CYAN_CONCRETE_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.CYAN_CONCRETE_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.CYAN_CONCRETE_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.CYAN_CONCRETE_WALL.get());
        this.add((Block)MtaBlocks.LIGHT_BLUE_CONCRETE_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.LIGHT_BLUE_CONCRETE_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.LIGHT_BLUE_CONCRETE_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.LIGHT_BLUE_CONCRETE_WALL.get());
        this.add((Block)MtaBlocks.BLUE_CONCRETE_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.BLUE_CONCRETE_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.BLUE_CONCRETE_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.BLUE_CONCRETE_WALL.get());
        this.add((Block)MtaBlocks.PURPLE_CONCRETE_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.PURPLE_CONCRETE_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.PURPLE_CONCRETE_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.PURPLE_CONCRETE_WALL.get());
        this.add((Block)MtaBlocks.MAGENTA_CONCRETE_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.MAGENTA_CONCRETE_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.MAGENTA_CONCRETE_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.MAGENTA_CONCRETE_WALL.get());
        this.add((Block)MtaBlocks.PINK_CONCRETE_SLAB.get(), block -> this.createSlabItemTable((Block)MtaBlocks.PINK_CONCRETE_SLAB.get()));
        this.dropSelf((Block)MtaBlocks.PINK_CONCRETE_STAIRS.get());
        this.dropSelf((Block)MtaBlocks.PINK_CONCRETE_WALL.get());
        this.add((Block)MtaBlocks.AGATE_ORE.get(), block -> this.createOreDrop((Block)block, (Item)MtaItems.AGATE.get()));
        this.add((Block)MtaBlocks.DEEPSLATE_AGATE_ORE.get(), block -> this.createOreDrop((Block)block, (Item)MtaItems.AGATE.get()));
        this.add((Block)MtaBlocks.ALEXANDRITE_ORE.get(), block -> this.createOreDrop((Block)block, (Item)MtaItems.ALEXANDRITE.get()));
        this.add((Block)MtaBlocks.DEEPSLATE_ALEXANDRITE_ORE.get(), block -> this.createOreDrop((Block)block, (Item)MtaItems.ALEXANDRITE.get()));
        this.add((Block)MtaBlocks.AQUAMARINE_ORE.get(), block -> this.createOreDrop((Block)block, (Item)MtaItems.AQUAMARINE.get()));
        this.add((Block)MtaBlocks.DEEPSLATE_AQUAMARINE_ORE.get(), block -> this.createOreDrop((Block)block, (Item)MtaItems.AQUAMARINE.get()));
        this.add((Block)MtaBlocks.CELESTITE_ORE.get(), block -> this.createOreDrop((Block)block, (Item)MtaItems.CELESTITE.get()));
        this.add((Block)MtaBlocks.DEEPSLATE_CELESTITE_ORE.get(), block -> this.createOreDrop((Block)block, (Item)MtaItems.CELESTITE.get()));
        this.add((Block)MtaBlocks.GARNET_ORE.get(), block -> this.createOreDrop((Block)block, (Item)MtaItems.GARNET.get()));
        this.add((Block)MtaBlocks.DEEPSLATE_GARNET_ORE.get(), block -> this.createOreDrop((Block)block, (Item)MtaItems.GARNET.get()));
        this.add((Block)MtaBlocks.MOONSTONE_ORE.get(), block -> this.createOreDrop((Block)block, (Item)MtaItems.MOONSTONE.get()));
        this.add((Block)MtaBlocks.DEEPSLATE_MOONSTONE_ORE.get(), block -> this.createOreDrop((Block)block, (Item)MtaItems.MOONSTONE.get()));
        LootItemBlockStatePropertyCondition.Builder onionCrop = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)MtaBlocks.ONION_CROP.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)OnionCropBlock.AGE, 7));
        this.add((Block)MtaBlocks.ONION_CROP.get(), this.createCropDrops((Block)MtaBlocks.ONION_CROP.get(), (Item)MtaItems.ONION.get(), MtaItems.ONION.asItem(), (LootItemCondition.Builder)onionCrop));
        LootItemBlockStatePropertyCondition.Builder tomatoCrop = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)MtaBlocks.TOMATO_CROP.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)OnionCropBlock.AGE, 7));
        this.add((Block)MtaBlocks.TOMATO_CROP.get(), this.createCropDrops((Block)MtaBlocks.ONION_CROP.get(), (Item)MtaItems.TOMATO.get(), MtaItems.TOMATO_SEEDS.asItem(), (LootItemCondition.Builder)tomatoCrop));
        LootItemBlockStatePropertyCondition.Builder bellPepperCrop = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)MtaBlocks.BELL_PEPPER_CROP.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)OnionCropBlock.AGE, 7));
        this.add((Block)MtaBlocks.BELL_PEPPER_CROP.get(), this.createCropDrops((Block)MtaBlocks.BELL_PEPPER_CROP.get(), (Item)MtaItems.BELL_PEPPER.get(), MtaItems.BELL_PEPPER_SEEDS.asItem(), (LootItemCondition.Builder)bellPepperCrop));
        LootItemBlockStatePropertyCondition.Builder chillPepperCrop = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)MtaBlocks.CHILI_PEPPER_CROP.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)OnionCropBlock.AGE, 7));
        this.add((Block)MtaBlocks.CHILI_PEPPER_CROP.get(), this.createCropDrops((Block)MtaBlocks.CHILI_PEPPER_CROP.get(), (Item)MtaItems.CHILI_PEPPER.get(), MtaItems.CHILI_PEPPER_SEEDS.asItem(), (LootItemCondition.Builder)chillPepperCrop));
    }

    protected Iterable<Block> getKnownBlocks() {
        List<Block> list = this.knownBlocks;
        list.remove(this.excludedBlocks);
        return list;
    }

    protected LootTable.Builder createPalmLeavesDrops(Block pLeavesBlock, Item pCoconut, float ... pChances) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchOrShearsDispatchTable(pLeavesBlock, ((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)pLeavesBlock, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)pCoconut))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])pChances)));
    }
}

