/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.game.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GeyserParticle
extends TextureSheetParticle {
    protected GeyserParticle(ClientLevel pLevel, double pX, double pY, double pZ) {
        super(pLevel, pX, pY, pZ, 0.0, 0.0, 0.0);
        this.gravity = 0.62f;
        this.friction = 0.999f;
        this.xd *= (double)(0.3f * this.random.nextFloat());
        this.yd *= (double)3.2f;
        this.zd *= (double)(0.3f * this.random.nextFloat());
        this.yd = this.random.nextFloat() * 1.5f + 0.05f;
        this.quadSize *= this.random.nextFloat() * 4.0f + 0.2f;
        this.lifetime = (int)(24.0 / (Math.random() * 0.8 + 0.2));
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public float getQuadSize(float pScaleFactor) {
        float f = ((float)this.age + pScaleFactor) / (float)this.lifetime;
        return this.quadSize * (1.0f - f * f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Lava
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Lava(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            GeyserParticle geyserParticle = new GeyserParticle(pLevel, pX, pY, pZ);
            geyserParticle.pickSprite(this.sprite);
            return geyserParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Water
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Water(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            GeyserParticle geyserParticle = new GeyserParticle(pLevel, pX, pY, pZ);
            geyserParticle.pickSprite(this.sprite);
            return geyserParticle;
        }
    }
}

