/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.game.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.valueproviders.UniformFloat;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SprinklerParticle
extends TextureSheetParticle {
    protected SprinklerParticle(ClientLevel pLevel, double pX, double pY, double pZ) {
        super(pLevel, pX, pY, pZ, 0.0, 0.0, 0.0);
        this.gravity = 0.62f;
        this.friction = 0.999f;
        this.xd *= (double)(2.6f * this.random.nextFloat());
        this.yd *= (double)0.4f;
        this.zd *= (double)(2.6f * this.random.nextFloat());
        this.yd = this.random.nextFloat() * 1.1f + 0.05f;
        this.xd = this.random.nextFloat() * UniformFloat.of((float)-1.75f, (float)1.75f).sample(this.random) + 0.05f;
        this.zd = this.random.nextFloat() * UniformFloat.of((float)-1.75f, (float)1.75f).sample(this.random) + 0.05f;
        this.quadSize *= this.random.nextFloat() * 4.0f + 0.2f;
        this.lifetime = (int)(12.0 / (Math.random() * 0.8 + 0.2));
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public float getQuadSize(float pScaleFactor) {
        float f = ((float)this.age + pScaleFactor) / (float)this.lifetime;
        return this.quadSize * (1.0f - f * f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Builder(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            SprinklerParticle sprinklerParticle = new SprinklerParticle(pLevel, pX, pY, pZ);
            sprinklerParticle.pickSprite(this.sprite);
            return sprinklerParticle;
        }
    }
}

