/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.game.client.renderer.entity;

import com.fuyuaki.morethanadventure.game.client.model.MTAModelLayers;
import com.fuyuaki.morethanadventure.game.client.model.entity.MysticMermaidsTridentModel;
import com.fuyuaki.morethanadventure.world.entity.ThrownMysticMermaidsTrident;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ThrownMysticMermaidsTridentRenderer
extends EntityRenderer<ThrownMysticMermaidsTrident> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"morethanadventure", (String)"textures/entity/mystic_mermaids_trident.png");
    private final MysticMermaidsTridentModel model;

    public ThrownMysticMermaidsTridentRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new MysticMermaidsTridentModel(pContext.bakeLayer(MTAModelLayers.MYSTIC_MERMAIDS_TRIDENT));
    }

    public void render(ThrownMysticMermaidsTrident pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.pushPose();
        pPoseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)pPartialTicks, (float)pEntity.yRotO, (float)pEntity.getYRot()) - 90.0f));
        pPoseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)pPartialTicks, (float)pEntity.xRotO, (float)pEntity.getXRot()) + 90.0f));
        VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)pBuffer, (RenderType)this.model.renderType(this.getTextureLocation(pEntity)), (boolean)false, (boolean)pEntity.isFoil());
        this.model.renderToBuffer(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY);
        pPoseStack.popPose();
        super.render((Entity)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(ThrownMysticMermaidsTrident pEntity) {
        return TEXTURE;
    }
}

