/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.game.client.renderer.entity;

import com.fuyuaki.morethanadventure.game.client.model.entity.WitherJuggernautModel;
import com.fuyuaki.morethanadventure.world.entity.WitherJuggernaut;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class WitherJuggernautRenderer
extends GeoEntityRenderer<WitherJuggernaut> {
    protected ItemStack mainHandItem;
    protected ItemStack offhandItem;
    private static final String LEFT_HAND = "left_hand";
    private static final String RIGHT_HAND = "right_hand";

    public WitherJuggernautRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new WitherJuggernautModel());
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<WitherJuggernaut>((GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, WitherJuggernaut animatable) {
                return switch (bone.getName()) {
                    case WitherJuggernautRenderer.LEFT_HAND -> {
                        if (animatable.isLeftHanded()) {
                            yield WitherJuggernautRenderer.this.mainHandItem;
                        }
                        yield WitherJuggernautRenderer.this.offhandItem;
                    }
                    case WitherJuggernautRenderer.RIGHT_HAND -> {
                        if (animatable.isLeftHanded()) {
                            yield WitherJuggernautRenderer.this.offhandItem;
                        }
                        yield WitherJuggernautRenderer.this.mainHandItem;
                    }
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, WitherJuggernaut animatable) {
                return switch (bone.getName()) {
                    case WitherJuggernautRenderer.LEFT_HAND, WitherJuggernautRenderer.RIGHT_HAND -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, WitherJuggernaut animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (stack == WitherJuggernautRenderer.this.mainHandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(0.0, 0.125, -0.25);
                    }
                } else if (stack == WitherJuggernautRenderer.this.offhandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(0.0, 0.125, 0.25);
                        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    }
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    public void preRender(PoseStack poseStack, WitherJuggernaut animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        this.mainHandItem = animatable.getMainHandItem();
        this.offhandItem = animatable.getOffhandItem();
    }
}

