/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.game.client.renderer.entity.layers;

import com.fuyuaki.morethanadventure.world.entity.Butterfly;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class ButterflyWingsOverlay
extends GeoRenderLayer<Butterfly> {
    private static final ResourceLocation OVERLAY_A = ResourceLocation.fromNamespaceAndPath((String)"morethanadventure", (String)"textures/entity/butterfly/overlay_a.png");
    private static final ResourceLocation OVERLAY_B = ResourceLocation.fromNamespaceAndPath((String)"morethanadventure", (String)"textures/entity/butterfly/overlay_b.png");
    private static final ResourceLocation OVERLAY_C = ResourceLocation.fromNamespaceAndPath((String)"morethanadventure", (String)"textures/entity/butterfly/overlay_c.png");
    private static final ResourceLocation OVERLAY_D = ResourceLocation.fromNamespaceAndPath((String)"morethanadventure", (String)"textures/entity/butterfly/overlay_d.png");

    public ButterflyWingsOverlay(GeoRenderer<Butterfly> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(PoseStack poseStack, Butterfly animatable, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        RenderType renderType1 = RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureResource(animatable));
        this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, renderType1, bufferSource.getBuffer(renderType1), partialTick, packedLight, packedOverlay, animatable.getOverlayColor().getTextureDiffuseColor());
    }

    protected ResourceLocation getTextureResource(Butterfly animatable) {
        return switch (animatable.getOverlay()) {
            case 0 -> OVERLAY_A;
            case 1 -> OVERLAY_B;
            case 2 -> OVERLAY_C;
            case 3 -> OVERLAY_D;
            default -> throw new IllegalStateException("Unexpected value: " + animatable.getOverlay());
        };
    }
}

