/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.game.client.renderer.entity.layers;

import com.fuyuaki.morethanadventure.world.entity.Butterfly;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class ButterflyWingsPattern
extends GeoRenderLayer<Butterfly> {
    private static final ResourceLocation PATTERN_A = ResourceLocation.fromNamespaceAndPath((String)"morethanadventure", (String)"textures/entity/butterfly/pattern_a.png");
    private static final ResourceLocation PATTERN_B = ResourceLocation.fromNamespaceAndPath((String)"morethanadventure", (String)"textures/entity/butterfly/pattern_b.png");
    private static final ResourceLocation PATTERN_C = ResourceLocation.fromNamespaceAndPath((String)"morethanadventure", (String)"textures/entity/butterfly/pattern_c.png");

    public ButterflyWingsPattern(GeoRenderer<Butterfly> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(PoseStack poseStack, Butterfly animatable, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        RenderType renderType1 = RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureResource(animatable));
        this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, renderType1, bufferSource.getBuffer(renderType1), partialTick, packedLight, packedOverlay, animatable.getColor().getTextureDiffuseColor());
    }

    protected ResourceLocation getTextureResource(Butterfly animatable) {
        return switch (animatable.getPattern()) {
            case 0 -> PATTERN_A;
            case 1 -> PATTERN_B;
            case 2 -> PATTERN_C;
            default -> throw new IllegalStateException("Unexpected value: " + animatable.getOverlay());
        };
    }
}

