/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.game.worldgen;

import com.fuyuaki.morethanadventure.core.registry.MtaBlocks;
import com.fuyuaki.morethanadventure.core.registry.MtaFeatures;
import com.fuyuaki.morethanadventure.core.registry.MtaTags;
import com.fuyuaki.morethanadventure.world.block.GeyserBlock;
import com.fuyuaki.morethanadventure.world.block.ShardGrowthBlock;
import com.fuyuaki.morethanadventure.world.block.SweetBerryLeavesBlock;
import com.fuyuaki.morethanadventure.world.level.feature.configuration.OreClusterConfiguration;
import com.fuyuaki.morethanadventure.world.level.feature.placers.PalmFoliagePlacer;
import com.fuyuaki.morethanadventure.world.level.feature.placers.PalmTrunkPlacer;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ReplaceBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BushFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.neoforged.neoforge.common.Tags;

public class MtaConfigFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> PALM_TREE = MtaConfigFeatures.registerKey("palm_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FREQUENT_CLAY = MtaConfigFeatures.registerKey("frequent_clay");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DISK_MOSS = MtaConfigFeatures.registerKey("disk_moss");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DIAMOND_CLUSTER = MtaConfigFeatures.registerKey("diamond_cluster");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DEBRIS_CLUSTER = MtaConfigFeatures.registerKey("debris_cluster");
    public static final ResourceKey<ConfiguredFeature<?, ?>> STONY_ROCKS = MtaConfigFeatures.registerKey("stony_rocks");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MOSSY_ROCKS = MtaConfigFeatures.registerKey("mossy_rocks");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GEYSER_OVERWORLD = MtaConfigFeatures.registerKey("geyser_overworld");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GEYSER_NETHER = MtaConfigFeatures.registerKey("geyser_nether");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_IRON = MtaConfigFeatures.registerKey("nether_iron");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_DIAMOND = MtaConfigFeatures.registerKey("nether_diamond");
    public static final ResourceKey<ConfiguredFeature<?, ?>> END_LAPIS = MtaConfigFeatures.registerKey("nether_lapis");
    public static final ResourceKey<ConfiguredFeature<?, ?>> END_EMERALD = MtaConfigFeatures.registerKey("nether_emerald");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CLEAR_QUARTZ_ORE = MtaConfigFeatures.registerKey("clear_quartz_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LARGE_CLEAR_QUARTZ_VEIN = MtaConfigFeatures.registerKey("large_clear_quartz_vein");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CLEAR_QUARTZ_SHARD = MtaConfigFeatures.registerKey("clear_quartz_shard");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHERITIC_CRYSTAL_ORE = MtaConfigFeatures.registerKey("netheritic_crystal_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AGATE_ORE = MtaConfigFeatures.registerKey("agate_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ALEXANDRITE_ORE = MtaConfigFeatures.registerKey("alexandrite_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AQUAMARINE_ORE = MtaConfigFeatures.registerKey("aquamarine_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CELESTITE_ORE = MtaConfigFeatures.registerKey("celestite_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GARNET_ORE = MtaConfigFeatures.registerKey("garnet_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MOONSTONE_ORE = MtaConfigFeatures.registerKey("moonstone_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SWEET_BERRY_LEAVES = MtaConfigFeatures.registerKey("sweet_berry_leaves");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GRASSY_DIRT_PATCH = MtaConfigFeatures.registerKey("grassy_dirt_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SCATTERED_LEAVES = MtaConfigFeatures.registerKey("scattered_leaves");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        SimpleWeightedRandomList.Builder leavesBuilder = SimpleWeightedRandomList.builder();
        for (int i = 1; i <= 4; ++i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                leavesBuilder.add((Object)((BlockState)((BlockState)((Block)MtaBlocks.SCATTERED_LEAVES.get()).defaultBlockState().setValue((Property)PinkPetalsBlock.AMOUNT, (Comparable)Integer.valueOf(i))).setValue((Property)PinkPetalsBlock.FACING, (Comparable)direction)), 1);
            }
        }
        TagMatchTest clusterOresOverworld = new TagMatchTest(MtaTags.Blocks.ORE_CLUSTER_REPLACEABLE);
        TagMatchTest clusterOresNether = new TagMatchTest(MtaTags.Blocks.NETHER_CLUSTER_CLUSTER_REPLACEABLE);
        TagMatchTest oresStone = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest oresDeepslate = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        TagMatchTest oresNetherrack = new TagMatchTest(Tags.Blocks.NETHERRACKS);
        TagMatchTest oresEndstone = new TagMatchTest(Tags.Blocks.END_STONES);
        HolderGetter holdergetter = context.lookup(Registries.CONFIGURED_FEATURE);
        MtaConfigFeatures.register(context, PALM_TREE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)MtaBlocks.PALM_LOG.get())), (TrunkPlacer)new PalmTrunkPlacer(4, 5, 3), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)MtaBlocks.PALM_LEAVES.get())), (FoliagePlacer)new PalmFoliagePlacer((IntProvider)ConstantInt.of((int)4), (IntProvider)ConstantInt.of((int)1)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).build());
        MtaConfigFeatures.register(context, FREQUENT_CLAY, Feature.DISK, new DiskConfiguration(RuleBasedBlockStateProvider.simple((Block)Blocks.CLAY), BlockPredicate.matchesBlocks(List.of(Blocks.DIRT, Blocks.CLAY)), (IntProvider)UniformInt.of((int)4, (int)8), 2));
        MtaConfigFeatures.register(context, DISK_MOSS, Feature.DISK, new DiskConfiguration(RuleBasedBlockStateProvider.simple((Block)Blocks.MOSS_BLOCK), BlockPredicate.matchesBlocks(List.of(Blocks.DIRT, Blocks.GRASS_BLOCK, Blocks.SAND)), (IntProvider)UniformInt.of((int)2, (int)6), 1));
        MtaConfigFeatures.register(context, DIAMOND_CLUSTER, (Feature)MtaFeatures.CLUSTER_VEIN.get(), new OreClusterConfiguration((RuleTest)clusterOresOverworld, 64, 2, 4, 1, 0.2f, Blocks.DIAMOND_ORE.defaultBlockState(), Blocks.CALCITE.defaultBlockState()));
        MtaConfigFeatures.register(context, DEBRIS_CLUSTER, (Feature)MtaFeatures.CLUSTER_VEIN.get(), new OreClusterConfiguration((RuleTest)clusterOresOverworld, 32, 2, 3, 4, 0.1f, Blocks.ANCIENT_DEBRIS.defaultBlockState(), Blocks.BASALT.defaultBlockState()));
        MtaConfigFeatures.register(context, STONY_ROCKS, Feature.FOREST_ROCK, new BlockStateConfiguration(Blocks.ANDESITE.defaultBlockState()));
        MtaConfigFeatures.register(context, MOSSY_ROCKS, Feature.FOREST_ROCK, new BlockStateConfiguration(((Block)MtaBlocks.MOSSY_ANDESITE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> geyserOverworld = List.of(OreConfiguration.target((RuleTest)new BlockMatchTest(Blocks.STONE), (BlockState)((GeyserBlock)((Object)MtaBlocks.STONE_GEYSER.get())).defaultBlockState()), OreConfiguration.target((RuleTest)new BlockMatchTest(Blocks.GRAVEL), (BlockState)((GeyserBlock)((Object)MtaBlocks.STONE_GEYSER.get())).defaultBlockState()), OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.TERRACOTTA), (BlockState)((GeyserBlock)((Object)MtaBlocks.TERRACOTTA_GEYSER.get())).defaultBlockState()), OreConfiguration.target((RuleTest)new BlockMatchTest(Blocks.RED_SAND), (BlockState)((GeyserBlock)((Object)MtaBlocks.TERRACOTTA_GEYSER.get())).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> geyserNether = List.of(OreConfiguration.target((RuleTest)new BlockMatchTest(Blocks.NETHERRACK), (BlockState)((GeyserBlock)((Object)MtaBlocks.NETHERRACK_GEYSER.get())).defaultBlockState()), OreConfiguration.target((RuleTest)new BlockMatchTest(Blocks.BASALT), (BlockState)((GeyserBlock)((Object)MtaBlocks.BASALT_GEYSER.get())).defaultBlockState()));
        MtaConfigFeatures.register(context, GEYSER_OVERWORLD, Feature.REPLACE_SINGLE_BLOCK, new ReplaceBlockConfiguration(geyserOverworld));
        MtaConfigFeatures.register(context, GEYSER_NETHER, Feature.REPLACE_SINGLE_BLOCK, new ReplaceBlockConfiguration(geyserNether));
        MtaConfigFeatures.register(context, NETHER_IRON, Feature.ORE, new OreConfiguration(MtaConfigFeatures.blockTest((RuleTest)oresNetherrack, (Block)MtaBlocks.NETHER_IRON_ORE.get()), 9));
        MtaConfigFeatures.register(context, NETHER_DIAMOND, Feature.ORE, new OreConfiguration(MtaConfigFeatures.blockTest((RuleTest)oresNetherrack, (Block)MtaBlocks.NETHER_DIAMOND_ORE.get()), 14, 0.7f));
        MtaConfigFeatures.register(context, END_LAPIS, Feature.ORE, new OreConfiguration(MtaConfigFeatures.blockTest((RuleTest)oresEndstone, (Block)MtaBlocks.END_LAPIS_ORE.get()), 9));
        MtaConfigFeatures.register(context, END_EMERALD, Feature.ORE, new OreConfiguration(MtaConfigFeatures.blockTest((RuleTest)oresEndstone, (Block)MtaBlocks.END_EMERALD_ORE.get()), 5));
        MtaConfigFeatures.register(context, CLEAR_QUARTZ_ORE, Feature.ORE, new OreConfiguration(MtaConfigFeatures.blockTest((RuleTest)oresStone, (Block)MtaBlocks.CLEAR_QUARTZ_ORE.get(), (RuleTest)oresDeepslate, (Block)MtaBlocks.DEEPSLATE_CLEAR_QUARTZ_ORE.get()), 3));
        MtaConfigFeatures.register(context, LARGE_CLEAR_QUARTZ_VEIN, Feature.ORE, new OreConfiguration(MtaConfigFeatures.blockTest((RuleTest)oresStone, (Block)MtaBlocks.CLEAR_QUARTZ_ORE.get(), (RuleTest)oresDeepslate, (Block)MtaBlocks.DEEPSLATE_CLEAR_QUARTZ_ORE.get()), 10));
        MtaConfigFeatures.register(context, CLEAR_QUARTZ_SHARD, Feature.REPLACE_SINGLE_BLOCK, new ReplaceBlockConfiguration(List.of(OreConfiguration.target((RuleTest)new BlockMatchTest(Blocks.CALCITE), (BlockState)((ShardGrowthBlock)((Object)MtaBlocks.CALCITE_CLEAR_QUARTZ_GROWTH.get())).defaultBlockState()), OreConfiguration.target((RuleTest)new BlockMatchTest(Blocks.DEEPSLATE), (BlockState)((ShardGrowthBlock)((Object)MtaBlocks.DEEPSLATE_CLEAR_QUARTZ_GROWTH.get())).defaultBlockState()), OreConfiguration.target((RuleTest)new BlockMatchTest(Blocks.STONE), (BlockState)((ShardGrowthBlock)((Object)MtaBlocks.CLEAR_QUARTZ_GROWTH.get())).defaultBlockState()))));
        MtaConfigFeatures.register(context, NETHERITIC_CRYSTAL_ORE, Feature.ORE, new OreConfiguration(MtaConfigFeatures.blockTest((RuleTest)oresNetherrack, (Block)MtaBlocks.NETHERITIC_CRYSTAL.get()), 7, 0.8f));
        MtaConfigFeatures.register(context, AGATE_ORE, Feature.ORE, new OreConfiguration(MtaConfigFeatures.blockTest((RuleTest)oresStone, (Block)MtaBlocks.AGATE_ORE.get(), (RuleTest)oresDeepslate, (Block)MtaBlocks.DEEPSLATE_AGATE_ORE.get()), 1, 0.5f));
        MtaConfigFeatures.register(context, ALEXANDRITE_ORE, Feature.ORE, new OreConfiguration(MtaConfigFeatures.blockTest((RuleTest)oresStone, (Block)MtaBlocks.ALEXANDRITE_ORE.get(), (RuleTest)oresDeepslate, (Block)MtaBlocks.DEEPSLATE_ALEXANDRITE_ORE.get()), 1, 0.5f));
        MtaConfigFeatures.register(context, AQUAMARINE_ORE, Feature.ORE, new OreConfiguration(MtaConfigFeatures.blockTest((RuleTest)oresStone, (Block)MtaBlocks.AQUAMARINE_ORE.get(), (RuleTest)oresDeepslate, (Block)MtaBlocks.DEEPSLATE_AQUAMARINE_ORE.get()), 1, 0.5f));
        MtaConfigFeatures.register(context, CELESTITE_ORE, Feature.ORE, new OreConfiguration(MtaConfigFeatures.blockTest((RuleTest)oresStone, (Block)MtaBlocks.CELESTITE_ORE.get(), (RuleTest)oresDeepslate, (Block)MtaBlocks.DEEPSLATE_CELESTITE_ORE.get()), 1, 0.5f));
        MtaConfigFeatures.register(context, GARNET_ORE, Feature.ORE, new OreConfiguration(MtaConfigFeatures.blockTest((RuleTest)oresStone, (Block)MtaBlocks.GARNET_ORE.get(), (RuleTest)oresDeepslate, (Block)MtaBlocks.DEEPSLATE_GARNET_ORE.get()), 1, 0.5f));
        MtaConfigFeatures.register(context, MOONSTONE_ORE, Feature.ORE, new OreConfiguration(MtaConfigFeatures.blockTest((RuleTest)oresStone, (Block)MtaBlocks.MOONSTONE_ORE.get(), (RuleTest)oresDeepslate, (Block)MtaBlocks.DEEPSLATE_MOONSTONE_ORE.get()), 1, 0.5f));
        MtaConfigFeatures.register(context, SWEET_BERRY_LEAVES, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SPRUCE_LOG), (TrunkPlacer)new StraightTrunkPlacer(1, 0, 0), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)MtaBlocks.SWEET_BERRY_LEAVES.get()).defaultBlockState().setValue((Property)SweetBerryLeavesBlock.AGE, (Comparable)Integer.valueOf(2)))), (FoliagePlacer)new BushFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)1), 2), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0)).build());
        MtaConfigFeatures.register(context, GRASSY_DIRT_PATCH, Feature.DISK, new DiskConfiguration(RuleBasedBlockStateProvider.simple((Block)((Block)MtaBlocks.GRASSY_DIRT.get())), BlockPredicate.matchesBlocks(List.of(Blocks.GRASS_BLOCK)), (IntProvider)UniformInt.of((int)2, (int)6), 1));
        MtaConfigFeatures.register(context, SCATTERED_LEAVES, Feature.FLOWER, new RandomPatchConfiguration(56, 4, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(leavesBuilder)))));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"morethanadventure", (String)name));
    }

    private static List<OreConfiguration.TargetBlockState> blockTest(Block target, Block replacement) {
        return List.of(OreConfiguration.target((RuleTest)new BlockMatchTest(target), (BlockState)replacement.defaultBlockState()));
    }

    private static List<OreConfiguration.TargetBlockState> blockTest(TagKey<Block> target, Block replacement) {
        return List.of(OreConfiguration.target((RuleTest)new TagMatchTest(target), (BlockState)replacement.defaultBlockState()));
    }

    private static List<OreConfiguration.TargetBlockState> blockTest(RuleTest target, Block replacement) {
        return List.of(OreConfiguration.target((RuleTest)target, (BlockState)replacement.defaultBlockState()));
    }

    private static List<OreConfiguration.TargetBlockState> blockTest(RuleTest target, Block replacement, RuleTest target2, Block replacement2) {
        return List.of(OreConfiguration.target((RuleTest)target, (BlockState)replacement.defaultBlockState()), OreConfiguration.target((RuleTest)target2, (BlockState)replacement2.defaultBlockState()));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

