/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.game.worldgen;

import com.fuyuaki.morethanadventure.core.registry.MtaBlocks;
import com.fuyuaki.morethanadventure.game.worldgen.MtaConfigFeatures;
import com.fuyuaki.morethanadventure.game.worldgen.util.MTAOreUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.CaveFeatures;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class MtaPlacedFeatures {
    public static final ResourceKey<PlacedFeature> PALM_TREE = MtaPlacedFeatures.registerKey("palm_tree");
    public static final ResourceKey<PlacedFeature> PALM_TREE_RARE = MtaPlacedFeatures.registerKey("palm_tree_rare");
    public static final ResourceKey<PlacedFeature> FREQUENT_CLAY = MtaPlacedFeatures.registerKey("frequent_clay");
    public static final ResourceKey<PlacedFeature> DISK_MOSS = MtaPlacedFeatures.registerKey("disk_moss");
    public static final ResourceKey<PlacedFeature> DISK_MOSS_RARE = MtaPlacedFeatures.registerKey("disk_moss_rare");
    public static final ResourceKey<PlacedFeature> LUSH_VEGETATION = MtaPlacedFeatures.registerKey("lush_vegetation");
    public static final ResourceKey<PlacedFeature> DIAMOND_CLUSTER = MtaPlacedFeatures.registerKey("diamond_cluster");
    public static final ResourceKey<PlacedFeature> DEBRIS_CLUSTER = MtaPlacedFeatures.registerKey("debris_cluster");
    public static final ResourceKey<PlacedFeature> SPARSE_CHERRY_TREE = MtaPlacedFeatures.registerKey("sparse_cherry");
    public static final ResourceKey<PlacedFeature> SPARSE_SPRUCE_TREE = MtaPlacedFeatures.registerKey("sparse_taiga");
    public static final ResourceKey<PlacedFeature> SPARSE_MANGROVE = MtaPlacedFeatures.registerKey("sparse_mangrove");
    public static final ResourceKey<PlacedFeature> STONY_ROCK = MtaPlacedFeatures.registerKey("stony_rocks");
    public static final ResourceKey<PlacedFeature> STONY_ROCK_CAVE = MtaPlacedFeatures.registerKey("stony_rocks_cave");
    public static final ResourceKey<PlacedFeature> MOSSY_ROCKS = MtaPlacedFeatures.registerKey("mossy_rocks");
    public static final ResourceKey<PlacedFeature> GEYSER_OVERWORLD = MtaPlacedFeatures.registerKey("geyser_overworld");
    public static final ResourceKey<PlacedFeature> GEYSER_NETHER = MtaPlacedFeatures.registerKey("geyser_nether");
    public static final ResourceKey<PlacedFeature> NETHER_IRON = MtaPlacedFeatures.registerKey("nether_iron");
    public static final ResourceKey<PlacedFeature> NETHER_DIAMOND = MtaPlacedFeatures.registerKey("nether_diamond");
    public static final ResourceKey<PlacedFeature> END_LAPIS = MtaPlacedFeatures.registerKey("nether_lapis");
    public static final ResourceKey<PlacedFeature> END_EMERALD = MtaPlacedFeatures.registerKey("nether_emerald");
    public static final ResourceKey<PlacedFeature> CLEAR_QUARTZ_ORE = MtaPlacedFeatures.registerKey("clear_quartz_ore");
    public static final ResourceKey<PlacedFeature> LARGE_CLEAR_QUARTZ_VEIN = MtaPlacedFeatures.registerKey("large_clear_quartz_vein");
    public static final ResourceKey<PlacedFeature> CLEAR_QUARTZ_SHARD = MtaPlacedFeatures.registerKey("clear_quartz_shard");
    public static final ResourceKey<PlacedFeature> NETHERITIC_CRYSTAL_ORE = MtaPlacedFeatures.registerKey("netheritic_crystal_ore");
    public static final ResourceKey<PlacedFeature> AGATE_ORE = MtaPlacedFeatures.registerKey("agate_ore");
    public static final ResourceKey<PlacedFeature> ALEXANDRITE_ORE = MtaPlacedFeatures.registerKey("alexandrite_ore");
    public static final ResourceKey<PlacedFeature> AQUAMARINE_ORE = MtaPlacedFeatures.registerKey("aquamarine_ore");
    public static final ResourceKey<PlacedFeature> CELESTITE_ORE = MtaPlacedFeatures.registerKey("celestite_ore");
    public static final ResourceKey<PlacedFeature> GARNET_ORE = MtaPlacedFeatures.registerKey("garnet_ore");
    public static final ResourceKey<PlacedFeature> MOONSTONE_ORE = MtaPlacedFeatures.registerKey("moonstone_ore");
    public static final ResourceKey<PlacedFeature> SWEET_BERRY_LEAVES = MtaPlacedFeatures.registerKey("sweet_berry_leaves");
    public static final ResourceKey<PlacedFeature> GRASSY_DIRT_PATCH = MtaPlacedFeatures.registerKey("grassy_dirt_patch");
    public static final ResourceKey<PlacedFeature> SCATTERED_LEAVES = MtaPlacedFeatures.registerKey("scattered_leaves");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        MtaPlacedFeatures.register(context, PALM_TREE, MtaPlacedFeatures.holder(context, MtaConfigFeatures.PALM_TREE), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)1, (float)0.2f, (int)1), (Block)((Block)MtaBlocks.PALM_SAPLING.get())));
        MtaPlacedFeatures.register(context, PALM_TREE_RARE, MtaPlacedFeatures.holder(context, MtaConfigFeatures.PALM_TREE), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)0, (float)0.1f, (int)1), (Block)((Block)MtaBlocks.PALM_SAPLING.get())));
        MtaPlacedFeatures.register(context, FREQUENT_CLAY, MtaPlacedFeatures.holder(context, MtaConfigFeatures.FREQUENT_CLAY), new PlacementModifier[]{InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.WATER})), BiomeFilter.biome()});
        MtaPlacedFeatures.register(context, DISK_MOSS, MtaPlacedFeatures.holder(context, MtaConfigFeatures.DISK_MOSS), new PlacementModifier[]{InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.ONLY_IN_AIR_OR_WATER_PREDICATE), BiomeFilter.biome()});
        MtaPlacedFeatures.register(context, DIAMOND_CLUSTER, MtaPlacedFeatures.holder(context, MtaConfigFeatures.DIAMOND_CLUSTER), MTAOreUtils.rareOrePlacement(12, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-20), (VerticalAnchor)VerticalAnchor.aboveBottom((int)40))));
        MtaPlacedFeatures.register(context, DEBRIS_CLUSTER, MtaPlacedFeatures.holder(context, MtaConfigFeatures.DEBRIS_CLUSTER), MTAOreUtils.rareOrePlacement(12, (PlacementModifier)HeightRangePlacement.of((HeightProvider)UniformHeight.of((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.top()))));
        MtaPlacedFeatures.register(context, SPARSE_MANGROVE, MtaPlacedFeatures.holder(context, VegetationFeatures.MANGROVE_VEGETATION), new PlacementModifier[]{CountPlacement.of((int)4), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)5), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome(), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.wouldSurvive((BlockState)Blocks.MANGROVE_PROPAGULE.defaultBlockState(), (Vec3i)BlockPos.ZERO))});
        MtaPlacedFeatures.register(context, SPARSE_CHERRY_TREE, MtaPlacedFeatures.holder(context, TreeFeatures.CHERRY), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)2, (float)0.1f, (int)1), (Block)Blocks.CHERRY_SAPLING));
        MtaPlacedFeatures.register(context, SPARSE_SPRUCE_TREE, MtaPlacedFeatures.holder(context, TreeFeatures.SPRUCE), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)2, (float)0.1f, (int)1), (Block)Blocks.SPRUCE_SAPLING));
        MtaPlacedFeatures.register(context, STONY_ROCK, MtaPlacedFeatures.holder(context, MtaConfigFeatures.STONY_ROCKS), new PlacementModifier[]{CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        MtaPlacedFeatures.register(context, MOSSY_ROCKS, MtaPlacedFeatures.holder(context, MtaConfigFeatures.MOSSY_ROCKS), new PlacementModifier[]{CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        MtaPlacedFeatures.register(context, GEYSER_OVERWORLD, MtaPlacedFeatures.holder(context, MtaConfigFeatures.GEYSER_OVERWORLD), new PlacementModifier[]{PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)Direction.UP.getNormal(), (Block[])new Block[]{Blocks.AIR})), RarityFilter.onAverageOnceEvery((int)16), BiomeFilter.biome(), InSquarePlacement.spread()});
        MtaPlacedFeatures.register(context, GEYSER_NETHER, MtaPlacedFeatures.holder(context, MtaConfigFeatures.GEYSER_NETHER), new PlacementModifier[]{PlacementUtils.FULL_RANGE, CountPlacement.of((int)8), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)Direction.UP.getNormal(), (Block[])new Block[]{Blocks.AIR})), BiomeFilter.biome(), InSquarePlacement.spread()});
        MtaPlacedFeatures.register(context, DISK_MOSS_RARE, MtaPlacedFeatures.holder(context, MtaConfigFeatures.DISK_MOSS), new PlacementModifier[]{InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, RarityFilter.onAverageOnceEvery((int)2), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.ONLY_IN_AIR_OR_WATER_PREDICATE), BiomeFilter.biome()});
        MtaPlacedFeatures.register(context, LUSH_VEGETATION, MtaPlacedFeatures.holder(context, CaveFeatures.MOSS_PATCH), new PlacementModifier[]{InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, CountPlacement.of((int)24), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.ONLY_IN_AIR_OR_WATER_PREDICATE), BiomeFilter.biome()});
        MtaPlacedFeatures.register(context, NETHER_IRON, MtaPlacedFeatures.holder(context, MtaConfigFeatures.NETHER_IRON), MTAOreUtils.commonOrePlacement(20, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)128))));
        MtaPlacedFeatures.register(context, NETHER_DIAMOND, MtaPlacedFeatures.holder(context, MtaConfigFeatures.NETHER_DIAMOND), MTAOreUtils.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-40), (VerticalAnchor)VerticalAnchor.absolute((int)96))));
        MtaPlacedFeatures.register(context, END_LAPIS, MtaPlacedFeatures.holder(context, MtaConfigFeatures.END_LAPIS), MTAOreUtils.commonOrePlacement(10, PlacementUtils.FULL_RANGE));
        MtaPlacedFeatures.register(context, END_EMERALD, MtaPlacedFeatures.holder(context, MtaConfigFeatures.END_EMERALD), MTAOreUtils.commonOrePlacement(28, PlacementUtils.FULL_RANGE));
        MtaPlacedFeatures.register(context, CLEAR_QUARTZ_ORE, MtaPlacedFeatures.holder(context, MtaConfigFeatures.CLEAR_QUARTZ_ORE), MTAOreUtils.commonOrePlacement(5, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-96), (VerticalAnchor)VerticalAnchor.absolute((int)32))));
        MtaPlacedFeatures.register(context, LARGE_CLEAR_QUARTZ_VEIN, MtaPlacedFeatures.holder(context, MtaConfigFeatures.LARGE_CLEAR_QUARTZ_VEIN), MTAOreUtils.commonOrePlacement(32, PlacementUtils.FULL_RANGE));
        MtaPlacedFeatures.register(context, CLEAR_QUARTZ_SHARD, MtaPlacedFeatures.holder(context, MtaConfigFeatures.CLEAR_QUARTZ_SHARD), new PlacementModifier[]{CountPlacement.of((int)256), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, InSquarePlacement.spread(), BiomeFilter.biome()});
        MtaPlacedFeatures.register(context, NETHERITIC_CRYSTAL_ORE, MtaPlacedFeatures.holder(context, MtaConfigFeatures.NETHERITIC_CRYSTAL_ORE), MTAOreUtils.commonOrePlacement(3, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-32), (VerticalAnchor)VerticalAnchor.absolute((int)64))));
        MtaPlacedFeatures.register(context, AGATE_ORE, MtaPlacedFeatures.holder(context, MtaConfigFeatures.AGATE_ORE), MTAOreUtils.commonOrePlacement(1, PlacementUtils.FULL_RANGE));
        MtaPlacedFeatures.register(context, ALEXANDRITE_ORE, MtaPlacedFeatures.holder(context, MtaConfigFeatures.ALEXANDRITE_ORE), MTAOreUtils.commonOrePlacement(1, PlacementUtils.FULL_RANGE));
        MtaPlacedFeatures.register(context, AQUAMARINE_ORE, MtaPlacedFeatures.holder(context, MtaConfigFeatures.AQUAMARINE_ORE), MTAOreUtils.commonOrePlacement(1, PlacementUtils.FULL_RANGE));
        MtaPlacedFeatures.register(context, CELESTITE_ORE, MtaPlacedFeatures.holder(context, MtaConfigFeatures.CELESTITE_ORE), MTAOreUtils.commonOrePlacement(1, PlacementUtils.FULL_RANGE));
        MtaPlacedFeatures.register(context, GARNET_ORE, MtaPlacedFeatures.holder(context, MtaConfigFeatures.GARNET_ORE), MTAOreUtils.commonOrePlacement(1, PlacementUtils.FULL_RANGE));
        MtaPlacedFeatures.register(context, MOONSTONE_ORE, MtaPlacedFeatures.holder(context, MtaConfigFeatures.MOONSTONE_ORE), MTAOreUtils.commonOrePlacement(1, PlacementUtils.FULL_RANGE));
        MtaPlacedFeatures.register(context, SWEET_BERRY_LEAVES, MtaPlacedFeatures.holder(context, MtaConfigFeatures.SWEET_BERRY_LEAVES), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)5), SurfaceWaterDepthFilter.forMaxDepth((int)0), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.wouldSurvive((BlockState)Blocks.SPRUCE_SAPLING.defaultBlockState(), (Vec3i)BlockPos.ZERO)), BiomeFilter.biome()});
        MtaPlacedFeatures.register(context, GRASSY_DIRT_PATCH, MtaPlacedFeatures.holder(context, MtaConfigFeatures.GRASSY_DIRT_PATCH), new PlacementModifier[]{InSquarePlacement.spread(), CountPlacement.of((int)9), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        PlacementUtils.register(context, SCATTERED_LEAVES, MtaPlacedFeatures.holder(context, MtaConfigFeatures.SCATTERED_LEAVES), (PlacementModifier[])new PlacementModifier[]{NoiseThresholdCountPlacement.of((double)-0.8, (int)2, (int)6), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"morethanadventure", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, PlacementModifier ... modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.of(modifiers)));
    }

    private static Holder<ConfiguredFeature<?, ?>> holder(BootstrapContext<PlacedFeature> context, ResourceKey<ConfiguredFeature<?, ?>> feature) {
        HolderGetter holdergetter = context.lookup(Registries.CONFIGURED_FEATURE);
        return holdergetter.getOrThrow(feature);
    }

    private static List<PlacementModifier> listAdd(List<PlacementModifier> list, PlacementModifier ... modifiers) {
        ArrayList<PlacementModifier> newList = new ArrayList<PlacementModifier>(List.copyOf(list));
        newList.addAll(List.of(modifiers));
        return newList;
    }
}

