/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.game.worldgen.biomes;

import com.fuyuaki.morethanadventure.core.registry.MtaEntityTypes;
import com.fuyuaki.morethanadventure.game.worldgen.MtaPlacedFeatures;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.TreePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;

public class MtaBiomes {
    @Nullable
    private static final Music NORMAL_MUSIC = null;
    private static final Music FOREST_MUSIC = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_FOREST);
    private static final Music SWAMP_MUSIC = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_SWAMP);
    private static final Music JUNGLE_MUSIC = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_JUNGLE);
    private static final Music CAVE_MUSIC = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_DRIPSTONE_CAVES);
    private static final Music CAVE_LUSH_MUSIC = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_LUSH_CAVES);
    private static final Music MOUNTAIN_MUSIC = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_JAGGED_PEAKS);
    private static final Music DESERT_MUSIC = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_DESERT);
    private static final Music MAGICAL_MUSIC = Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_CHERRY_GROVE);
    public static final ResourceKey<Biome> LUSH_RIVER = MtaBiomes.createBiome("lush_river");
    public static final ResourceKey<Biome> SPARSE_CHERRY_GROVE = MtaBiomes.createBiome("sparse_cherry_grove");
    public static final ResourceKey<Biome> SPARSE_TAIGA = MtaBiomes.createBiome("sparse_taiga");
    public static final ResourceKey<Biome> OASIS = MtaBiomes.createBiome("oasis");
    public static final ResourceKey<Biome> GRAVELLY_RIVER = MtaBiomes.createBiome("gravelly_river");
    public static final ResourceKey<Biome> LUSH_MEADOW = MtaBiomes.createBiome("lush_meadow");
    public static final ResourceKey<Biome> CRYSTALLINE_GROTTO = MtaBiomes.createBiome("crystalline_grotto");

    public static ResourceKey<Biome> createBiome(String name) {
        return ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"morethanadventure", (String)name));
    }

    public static void addBiomes() {
        MtaBiomes.registerVillagerTypes();
    }

    public static void bootstrap(BootstrapContext<Biome> context) {
        MtaBiomes.register(context, LUSH_RIVER, MtaBiomes.lushRiver(context));
        MtaBiomes.register(context, SPARSE_CHERRY_GROVE, MtaBiomes.sparseCherryGrove(context));
        MtaBiomes.register(context, SPARSE_TAIGA, MtaBiomes.sparseTaiga(context));
        MtaBiomes.register(context, OASIS, MtaBiomes.oasis(context));
        MtaBiomes.register(context, GRAVELLY_RIVER, MtaBiomes.gravelRiver(context));
        MtaBiomes.register(context, LUSH_MEADOW, MtaBiomes.lushMeadow(context));
        MtaBiomes.register(context, CRYSTALLINE_GROTTO, MtaBiomes.crystallineGrotto(context));
    }

    public static void globalOverworldGeneration(BiomeGenerationSettings.Builder builder) {
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addDefaultSprings((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addSurfaceFreezing((BiomeGenerationSettings.Builder)builder);
    }

    private static Biome lushRiver(BootstrapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.SQUID, 2, 1, 4)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.SALMON, 6, 1, 5)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.COD, 5, 1, 5)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.TROPICAL_FISH, 2, 3, 8));
        spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.DROWNED, 40, 1, 1));
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        MtaBiomes.globalOverworldGeneration(biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MtaPlacedFeatures.MOSSY_ROCKS);
        BiomeDefaultFeatures.addForestFlowers((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MtaPlacedFeatures.SPARSE_MANGROVE);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MiscOverworldPlacements.DISK_SAND);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MiscOverworldPlacements.DISK_CLAY);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MtaPlacedFeatures.FREQUENT_CLAY);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MtaPlacedFeatures.DISK_MOSS);
        BiomeDefaultFeatures.addWaterTrees((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultGrass((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_WATERLILY);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_GRASS_JUNGLE);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_SWAMP).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEA_PICKLE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.KELP_WARM).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_BERRY_COMMON);
        return MtaBiomes.biome(true, 0.6f, 0.3f, 4566514, 267827, null, null, spawnBuilder, biomeBuilder, null);
    }

    private static Biome sparseCherryGrove(BootstrapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.PIG, 1, 1, 2)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 2, 2, 6)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 2, 2, 4));
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        MtaBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.addPlainGrass((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MtaPlacedFeatures.FREQUENT_CLAY);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_GRASS_PLAIN);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.FLOWER_CHERRY);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MtaPlacedFeatures.SPARSE_CHERRY_TREE);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addInfestedStone((BiomeGenerationSettings.Builder)biomeBuilder);
        return MtaBiomes.biome(true, 0.5f, 0.8f, 6141935, 6141935, 11983713, 11983713, spawnBuilder, biomeBuilder, MAGICAL_MUSIC);
    }

    private static Biome sparseTaiga(BootstrapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 4, 2, 4)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 6, 2, 5)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.FOX, 5, 1, 4));
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        MtaBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.addPlainGrass((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MtaPlacedFeatures.SPARSE_SPRUCE_TREE);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addTaigaGrass((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addCommonBerryBushes((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MtaPlacedFeatures.SWEET_BERRY_LEAVES);
        return MtaBiomes.biome(true, 0.2f, 0.6f, 4159204, 329011, null, null, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    private static Biome oasis(BootstrapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.desertSpawns((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.CAMEL, 4, 1, 3));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        BiomeDefaultFeatures.addFossilDecoration((BiomeGenerationSettings.Builder)biomeBuilder);
        MtaBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MtaPlacedFeatures.PALM_TREE);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultGrass((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MtaPlacedFeatures.STONY_ROCK);
        BiomeDefaultFeatures.addDesertVegetation((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDesertExtraVegetation((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDesertExtraDecoration((BiomeGenerationSettings.Builder)biomeBuilder);
        return MtaBiomes.biome(false, 2.0f, 0.4f, spawnBuilder, biomeBuilder, DESERT_MUSIC);
    }

    private static Biome gravelRiver(BootstrapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.SQUID, 2, 1, 4)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.SALMON, 6, 1, 5));
        spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.DROWNED, 40, 1, 1));
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        MtaBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.addForestFlowers((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addWaterTrees((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultGrass((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MtaPlacedFeatures.STONY_ROCK);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_RIVER);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.VINES);
        return MtaBiomes.biome(true, 0.3f, 0.1f, 8162500, 1514026, null, null, spawnBuilder, biomeBuilder, null);
    }

    private static Biome lushMeadow(BootstrapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.DONKEY, 1, 1, 2)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 4, 2, 6)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)MtaEntityTypes.BUTTERFLY.get(), 3, 2, 5)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 2, 2, 4));
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        MtaBiomes.globalOverworldGeneration(biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.FLOWER_FOREST_FLOWERS);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.FLOWER_FLOWER_FOREST);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MtaPlacedFeatures.DISK_MOSS_RARE);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MtaPlacedFeatures.LUSH_VEGETATION);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, TreePlacements.FANCY_OAK_BEES_002);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, TreePlacements.OAK_BEES_002);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, TreePlacements.BIRCH_BEES_002);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, MtaPlacedFeatures.MOSSY_ROCKS);
        BiomeDefaultFeatures.addMeadowVegetation((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addWarmFlowers((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addJungleGrass((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addInfestedStone((BiomeGenerationSettings.Builder)biomeBuilder);
        return MtaBiomes.biome(true, 0.3f, 0.8f, 6141935, 6141935, 11983713, 11983713, spawnBuilder, biomeBuilder, MOUNTAIN_MUSIC);
    }

    private static Biome crystallineGrotto(BootstrapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.caveSpawns((MobSpawnSettings.Builder)spawnBuilder);
        int i = 95;
        BiomeDefaultFeatures.monsters((MobSpawnSettings.Builder)spawnBuilder, (int)40, (int)6, (int)40, (boolean)false);
        spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.SILVERFISH, 20, 2, 8));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultSprings((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addSurfaceFreezing((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder, (boolean)true);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MtaPlacedFeatures.LARGE_CLEAR_QUARTZ_VEIN);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MtaPlacedFeatures.CLEAR_QUARTZ_SHARD);
        return MtaBiomes.biome(true, 0.0f, 0.4f, spawnBuilder, biomeBuilder, CAVE_LUSH_MUSIC);
    }

    private static void registerVillagerTypes() {
        MtaBiomes.registerVillagers(LUSH_MEADOW, VillagerType.PLAINS);
        MtaBiomes.registerVillagers(LUSH_RIVER, VillagerType.PLAINS);
        MtaBiomes.registerVillagers(GRAVELLY_RIVER, VillagerType.PLAINS);
        MtaBiomes.registerVillagers(SPARSE_TAIGA, VillagerType.TAIGA);
        MtaBiomes.registerVillagers(SPARSE_CHERRY_GROVE, VillagerType.PLAINS);
        MtaBiomes.registerVillagers(OASIS, VillagerType.DESERT);
    }

    private static void register(BootstrapContext<Biome> context, ResourceKey<Biome> key, Biome biome) {
        context.register(key, (Object)biome);
    }

    private static void registerVillagers(ResourceKey<Biome> key, VillagerType type) {
        VillagerType.BY_BIOME.put(key, type);
    }

    protected static int calculateSkyColor(float pTemperature) {
        float $$1 = pTemperature / 3.0f;
        $$1 = Mth.clamp((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.hsvToRgb((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    private static Biome biome(boolean pHasPercipitation, float pTemperature, float pDownfall, MobSpawnSettings.Builder pMobSpawnSettings, BiomeGenerationSettings.Builder pGenerationSettings, @Nullable Music pBackgroundMusic) {
        return MtaBiomes.biome(pHasPercipitation, pTemperature, pDownfall, 4159204, 329011, null, null, pMobSpawnSettings, pGenerationSettings, pBackgroundMusic);
    }

    private static Biome biome(boolean pHasPrecipitation, float pTemperature, float pDownfall, int pWaterColor, int pWaterFogColor, @Nullable Integer pGrassColorOverride, @Nullable Integer pFoliageColorOverride, MobSpawnSettings.Builder pMobSpawnSettings, BiomeGenerationSettings.Builder pGenerationSettings, @Nullable Music pBackgroundMusic) {
        BiomeSpecialEffects.Builder biomespecialeffects$builder = new BiomeSpecialEffects.Builder().waterColor(pWaterColor).waterFogColor(pWaterFogColor).fogColor(12638463).skyColor(MtaBiomes.calculateSkyColor(pTemperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(pBackgroundMusic);
        if (pGrassColorOverride != null) {
            biomespecialeffects$builder.grassColorOverride(pGrassColorOverride.intValue());
        }
        if (pFoliageColorOverride != null) {
            biomespecialeffects$builder.foliageColorOverride(pFoliageColorOverride.intValue());
        }
        return new Biome.BiomeBuilder().hasPrecipitation(pHasPrecipitation).temperature(pTemperature).downfall(pDownfall).specialEffects(biomespecialeffects$builder.build()).mobSpawnSettings(pMobSpawnSettings.build()).generationSettings(pGenerationSettings.build()).build();
    }
}

