/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.game.worldgen.biomes;

import com.fuyuaki.morethanadventure.game.worldgen.biomes.MtaBiomes;
import com.fuyuaki.morethanadventure.world.level.biome.MtaBiomeList;
import com.fuyuaki.morethanadventure.world.level.biome.VanillaBiomeList;
import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;

public class MtaOverworldBiomeBuilder {
    private static final float VALLEY_SIZE = 0.05f;
    private static final float LOW_START = 0.26666668f;
    public static final float HIGH_START = 0.4f;
    private static final float HIGH_END = 0.93333334f;
    private static final float PEAK_SIZE = 0.1f;
    public static final float PEAK_START = 0.56666666f;
    private static final float PEAK_END = 0.7666667f;
    public static final float NEAR_INLAND_START = -0.11f;
    public static final float MID_INLAND_START = 0.03f;
    public static final float FAR_INLAND_START = 0.3f;
    public static final float EROSION_INDEX_1_START = -0.78f;
    public static final float EROSION_INDEX_2_START = -0.375f;
    protected final Climate.Parameter FULL_RANGE = Climate.Parameter.span((float)-1.0f, (float)1.0f);
    protected final Climate.Parameter[] temperatures = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.45f), Climate.Parameter.span((float)-0.45f, (float)-0.15f), Climate.Parameter.span((float)-0.15f, (float)0.2f), Climate.Parameter.span((float)0.2f, (float)0.55f), Climate.Parameter.span((float)0.55f, (float)1.0f)};
    protected final Climate.Parameter[] humidities = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.35f), Climate.Parameter.span((float)-0.35f, (float)-0.1f), Climate.Parameter.span((float)-0.1f, (float)0.1f), Climate.Parameter.span((float)0.1f, (float)0.3f), Climate.Parameter.span((float)0.3f, (float)1.0f)};
    protected final Climate.Parameter[] erosions = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.78f), Climate.Parameter.span((float)-0.78f, (float)-0.375f), Climate.Parameter.span((float)-0.375f, (float)-0.2225f), Climate.Parameter.span((float)-0.2225f, (float)0.05f), Climate.Parameter.span((float)0.05f, (float)0.45f), Climate.Parameter.span((float)0.45f, (float)0.55f), Climate.Parameter.span((float)0.55f, (float)1.0f)};
    protected static final Climate.Parameter COMMON_RARENESS_RANGE = Climate.Parameter.span((float)-1.0f, (float)0.35f);
    protected static final Climate.Parameter RARE_RARENESS_RANGE = Climate.Parameter.span((float)0.35f, (float)1.0f);
    protected final Climate.Parameter FROZEN_RANGE = this.temperatures[0];
    protected final Climate.Parameter UNFROZEN_RANGE = Climate.Parameter.span((Climate.Parameter)this.temperatures[1], (Climate.Parameter)this.temperatures[4]);
    protected final Climate.Parameter islandContinentalness = Climate.Parameter.span((float)-1.2f, (float)-1.05f);
    protected final Climate.Parameter deepOceanContinentalness = Climate.Parameter.span((float)-1.05f, (float)-0.455f);
    protected final Climate.Parameter oceanContinentalness = Climate.Parameter.span((float)-0.455f, (float)-0.19f);
    protected final Climate.Parameter coastContinentalness = Climate.Parameter.span((float)-0.19f, (float)-0.11f);
    protected final Climate.Parameter inlandContinentalness = Climate.Parameter.span((float)-0.11f, (float)0.55f);
    protected final Climate.Parameter nearInlandContinentalness = Climate.Parameter.span((float)-0.11f, (float)0.03f);
    protected final Climate.Parameter midInlandContinentalness = Climate.Parameter.span((float)0.03f, (float)0.3f);
    protected final Climate.Parameter farInlandContinentalness = Climate.Parameter.span((float)0.3f, (float)1.0f);

    public void addBiomes(Registry<Biome> registry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        this.addOffCoastBiomes(mapper);
        this.addInlandBiomes(mapper);
        this.addUndergroundBiomes(mapper);
    }

    private void addOffCoastBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> islandBiomeMTA = this.pickIslandBiomeMTA(i, j);
                this.addSurfaceBiome(mapper, temperature, humidity, this.islandContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, islandBiomeMTA);
            }
            this.addSurfaceBiome(mapper, temperature, this.FULL_RANGE, this.deepOceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, VanillaBiomeList.OCEANS[0][i]);
            this.addSurfaceBiome(mapper, temperature, this.FULL_RANGE, this.oceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, VanillaBiomeList.OCEANS[1][i]);
        }
    }

    private void addInlandBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        this.addMidSlice(mapper, Climate.Parameter.span((float)-1.0f, (float)-0.93333334f));
        this.addHighSlice(mapper, Climate.Parameter.span((float)-0.93333334f, (float)-0.7666667f));
        this.addPeaks(mapper, Climate.Parameter.span((float)-0.7666667f, (float)-0.56666666f));
        this.addHighSlice(mapper, Climate.Parameter.span((float)-0.56666666f, (float)-0.4f));
        this.addMidSlice(mapper, Climate.Parameter.span((float)-0.4f, (float)-0.26666668f));
        this.addLowSlice(mapper, Climate.Parameter.span((float)-0.26666668f, (float)-0.05f));
        this.addValleys(mapper, Climate.Parameter.span((float)-0.05f, (float)0.05f));
        this.addLowSlice(mapper, Climate.Parameter.span((float)0.05f, (float)0.26666668f));
        this.addMidSlice(mapper, Climate.Parameter.span((float)0.26666668f, (float)0.4f));
        this.addHighSlice(mapper, Climate.Parameter.span((float)0.4f, (float)0.56666666f));
        this.addPeaks(mapper, Climate.Parameter.span((float)0.56666666f, (float)0.7666667f));
        this.addHighSlice(mapper, Climate.Parameter.span((float)0.7666667f, (float)0.93333334f));
        this.addMidSlice(mapper, Climate.Parameter.span((float)0.93333334f, (float)1.0f));
    }

    protected void addPeaks(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiomeMTA = this.pickMiddleBiomeMTA(i, j, weirdness);
                ResourceKey<Biome> middleBadlandsOrSlopeBiomeMTA = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdMTA(i, j, weirdness);
                ResourceKey<Biome> plateauBiomeMTA = this.pickPlateauBiomeMTA(i, j, weirdness);
                ResourceKey<Biome> extremeHillsBiome = this.pickExtremeHillsBiomeVanilla(i, j, weirdness);
                ResourceKey<Biome> extremeHillsBiomeMTA = this.pickExtremeHillsBiomeMTA(i, j, weirdness);
                ResourceKey<Biome> shatteredBiome = this.maybePickShatteredBiome(i, j, weirdness, extremeHillsBiome);
                ResourceKey<Biome> peakBiomeMTA = this.pickPeakBiomeMTA(i, j, weirdness);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, peakBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[1], weirdness, 0.0f, middleBadlandsOrSlopeBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, peakBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], weirdness, 0.0f, plateauBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, this.midInlandContinentalness, this.erosions[3], weirdness, 0.0f, middleBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, this.farInlandContinentalness, this.erosions[3], weirdness, 0.0f, plateauBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, extremeHillsBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, middleBiomeMTA);
            }
        }
    }

    protected void addHighSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiomeVanilla = this.pickMiddleBiomeVanilla(i, j, weirdness);
                ResourceKey<Biome> middleBiomeMTA = this.pickMiddleBiomeMTA(i, j, weirdness);
                ResourceKey<Biome> middleBadlandsOrSlopeBiomeMTA = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdMTA(i, j, weirdness);
                ResourceKey<Biome> plateauBiomeMTA = this.pickPlateauBiomeMTA(i, j, weirdness);
                ResourceKey<Biome> extremeHillsBiomeMTA = this.pickExtremeHillsBiomeMTA(i, j, weirdness);
                ResourceKey<Biome> shatteredBiome = this.maybePickShatteredBiome(i, j, weirdness, middleBiomeVanilla);
                ResourceKey<Biome> slopeBiomeMTA = this.pickSlopeBiomeMTA(i, j, weirdness);
                ResourceKey<Biome> peakBiomeMTA = this.pickPeakBiomeMTA(i, j, weirdness);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, this.erosions[0], weirdness, 0.0f, slopeBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, peakBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, this.erosions[1], weirdness, 0.0f, middleBadlandsOrSlopeBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, slopeBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], weirdness, 0.0f, plateauBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, this.midInlandContinentalness, this.erosions[3], weirdness, 0.0f, middleBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, this.farInlandContinentalness, this.erosions[3], weirdness, 0.0f, plateauBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, extremeHillsBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, middleBiomeMTA);
            }
        }
    }

    protected void addMidSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiomeVanilla = this.pickMiddleBiomeVanilla(i, j, weirdness);
                ResourceKey<Biome> middleBiomeMTA = this.pickMiddleBiomeMTA(i, j, weirdness);
                ResourceKey<Biome> middleBadlandsOrSlopeBiomeMTA = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdMTA(i, j, weirdness);
                ResourceKey<Biome> extremeHillsBiomeMTA = this.pickExtremeHillsBiomeMTA(i, j, weirdness);
                ResourceKey<Biome> plateauBiomeMTA = this.pickPlateauBiomeMTA(i, j, weirdness);
                ResourceKey<Biome> beachBiomeMTA = this.pickBeachBiomeMTA(i, j);
                ResourceKey<Biome> stonyShoresBiomeMTA = this.pickStonyShoresBiomeMTA(i, j);
                ResourceKey<Biome> shatteredBiome = this.maybePickShatteredBiome(i, j, weirdness, middleBiomeVanilla);
                ResourceKey<Biome> shatteredCoastBiome = this.pickShatteredCoastBiome(i, j, weirdness);
                ResourceKey<Biome> slopeBiomeMTA = this.pickSlopeBiomeMTA(i, j, weirdness);
                ResourceKey<Biome> swampBiomeMTA = this.pickSwampBiomeMTA(i, j, weirdness);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, stonyShoresBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, slopeBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.midInlandContinentalness), this.erosions[1], weirdness, 0.0f, middleBadlandsOrSlopeBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, this.farInlandContinentalness, this.erosions[1], weirdness, 0.0f, i == 0 ? slopeBiomeMTA : plateauBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, this.erosions[2], weirdness, 0.0f, middleBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, this.midInlandContinentalness, this.erosions[2], weirdness, 0.0f, middleBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, this.farInlandContinentalness, this.erosions[2], weirdness, 0.0f, plateauBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[3], weirdness, 0.0f, middleBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[3], weirdness, 0.0f, middleBiomeMTA);
                if (weirdness.max() < 0L) {
                    this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[4], weirdness, 0.0f, beachBiomeMTA);
                    this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiomeMTA);
                } else {
                    this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiomeMTA);
                }
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[5], weirdness, 0.0f, shatteredCoastBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, extremeHillsBiomeMTA);
                if (weirdness.max() < 0L) {
                    this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, beachBiomeMTA);
                } else {
                    this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, middleBiomeMTA);
                }
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, swampBiomeMTA);
            }
        }
    }

    protected void addLowSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiomeVanilla = this.pickMiddleBiomeVanilla(i, j, weirdness);
                ResourceKey<Biome> middleBiomeMTA = this.pickMiddleBiomeMTA(i, j, weirdness);
                ResourceKey<Biome> middleBadlandsOrSlopeBiomeMTA = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdMTA(i, j, weirdness);
                ResourceKey<Biome> beachBiome = this.pickBeachBiomeMTA(i, j);
                ResourceKey<Biome> stonyShoresBiomeMTA = this.pickStonyShoresBiomeMTA(i, j);
                ResourceKey<Biome> shatteredBiome = this.maybePickShatteredBiome(i, j, weirdness, middleBiomeVanilla);
                ResourceKey<Biome> shatteredCoastBiome = this.pickShatteredCoastBiome(i, j, weirdness);
                ResourceKey<Biome> swampBiomeMTA = this.pickSwampBiomeMTA(i, j, weirdness);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, stonyShoresBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBadlandsOrSlopeBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[3], (Climate.Parameter)this.erosions[4]), weirdness, 0.0f, beachBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[5], weirdness, 0.0f, shatteredCoastBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, middleBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, beachBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, swampBiomeMTA);
            }
        }
    }

    protected void addValleys(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter weirdness) {
        Climate.Parameter humidity;
        int j;
        Climate.Parameter temperature;
        int i;
        for (i = 0; i < this.temperatures.length; ++i) {
            temperature = this.temperatures[i];
            for (j = 0; j < this.humidities.length; ++j) {
                humidity = this.humidities[j];
                ResourceKey<Biome> riverBiomeMTA = this.pickRiverBiomeMTA(i, j);
                ResourceKey<Biome> stonyShoresBiomeMTA = this.pickStonyShoresBiomeMTA(i, j);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, weirdness.max() < 0L ? stonyShoresBiomeMTA : riverBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, riverBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[5]), weirdness, 0.0f, riverBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, riverBiomeMTA);
            }
        }
        for (i = 0; i < this.temperatures.length; ++i) {
            temperature = this.temperatures[i];
            for (j = 0; j < this.humidities.length; ++j) {
                humidity = this.humidities[j];
                ResourceKey<Biome> middleBiomeMTA = this.pickMiddleBiomeMTA(i, j, weirdness);
                ResourceKey<Biome> swampBiomeMTA = this.pickSwampBiomeMTA(i, j, weirdness);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBiomeMTA);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, swampBiomeMTA);
            }
        }
    }

    private void addSurfaceBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        builder.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)this.point(0.0f), (Climate.Parameter)weirdness, (float)offset), biome));
        builder.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)this.point(1.0f), (Climate.Parameter)weirdness, (float)offset), biome));
    }

    private void addUndergroundBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        builder.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.span((float)0.24f, (float)0.9f), (Climate.Parameter)weirdness, (float)offset), biome));
    }

    private void addBottomBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        builder.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.point((float)1.1f), (Climate.Parameter)weirdness, (float)offset), biome));
    }

    private Climate.Parameter point(float point) {
        return Climate.Parameter.point((float)point);
    }

    private Climate.Parameter span(float min, float max) {
        return Climate.Parameter.span((float)min, (float)max);
    }

    private Climate.Parameter span(Climate.Parameter min, Climate.Parameter max) {
        return Climate.Parameter.span((Climate.Parameter)min, (Climate.Parameter)max);
    }

    @SafeVarargs
    public static ResourceKey<Biome> biomeOrFallback(ResourceKey<Biome> ... biomes) {
        for (ResourceKey<Biome> key : biomes) {
            if (key == null) continue;
            return key;
        }
        throw new RuntimeException("Failed to find fallback for biome!");
    }

    protected void addUndergroundBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        this.addUndergroundBiome(mapper, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.span((float)0.8f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, 0.0f, (ResourceKey<Biome>)Biomes.DRIPSTONE_CAVES);
        this.addUndergroundBiome(mapper, this.FULL_RANGE, Climate.Parameter.span((float)0.7f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, 0.0f, (ResourceKey<Biome>)Biomes.LUSH_CAVES);
        this.addBottomBiome(mapper, this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), this.FULL_RANGE, 0.0f, (ResourceKey<Biome>)Biomes.DEEP_DARK);
        this.addUndergroundBiome(mapper, this.temperatures[2], this.FULL_RANGE, this.span(this.coastContinentalness, this.farInlandContinentalness), this.span(this.erosions[1], this.erosions[4]), this.FULL_RANGE, 0.0f, MtaBiomes.CRYSTALLINE_GROTTO);
    }

    protected ResourceKey<Biome> pickMiddleBiomeVanilla(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        if (weirdness.max() < 0L) {
            return VanillaBiomeList.MIDDLE_BIOMES[temperatureIndex][humidityIndex];
        }
        ResourceKey<Biome> variantBiome = VanillaBiomeList.MIDDLE_BIOMES_VARIANT[temperatureIndex][humidityIndex];
        return variantBiome == null ? VanillaBiomeList.MIDDLE_BIOMES[temperatureIndex][humidityIndex] : variantBiome;
    }

    protected ResourceKey<Biome> pickMiddleBiomeMTA(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        ResourceKey<Biome> middleBiome = MtaOverworldBiomeBuilder.biomeOrFallback(MtaBiomeList.MTA_MIDDLE_BIOMES[temperatureIndex][humidityIndex], VanillaBiomeList.MIDDLE_BIOMES[temperatureIndex][humidityIndex]);
        if (weirdness.max() < 0L) {
            return middleBiome;
        }
        return MtaOverworldBiomeBuilder.biomeOrFallback(MtaBiomeList.MTA_MIDDLE_BIOMES_VARIANT[temperatureIndex][humidityIndex], middleBiome);
    }

    protected ResourceKey<Biome> pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdMTA(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        return temperatureIndex == 0 ? this.pickSlopeBiomeMTA(temperatureIndex, humidityIndex, weirdness) : this.pickMiddleBiomeMTA(temperatureIndex, humidityIndex, weirdness);
    }

    protected ResourceKey<Biome> maybePickShatteredBiome(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness, ResourceKey<Biome> extremeHillsBiome) {
        return temperatureIndex > 1 && humidityIndex < 4 && weirdness.max() >= 0L ? Biomes.WINDSWEPT_SAVANNA : extremeHillsBiome;
    }

    protected ResourceKey<Biome> pickShatteredCoastBiome(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        ResourceKey<Biome> resourcekey = weirdness.max() >= 0L ? this.pickMiddleBiomeVanilla(temperatureIndex, humidityIndex, weirdness) : this.pickBeachBiomeMTA(temperatureIndex, humidityIndex);
        return this.maybePickShatteredBiome(temperatureIndex, humidityIndex, weirdness, resourcekey);
    }

    protected ResourceKey<Biome> pickSwampBiomeVanilla(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        ResourceKey<Biome> resourcekey = VanillaBiomeList.SWAMP_BIOMES[temperatureIndex][humidityIndex];
        return resourcekey == null ? this.pickMiddleBiomeVanilla(temperatureIndex, humidityIndex, weirdness) : resourcekey;
    }

    protected ResourceKey<Biome> pickSwampBiomeMTA(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        return MtaOverworldBiomeBuilder.biomeOrFallback(MtaBiomeList.MTA_SWAMP_BIOMES[temperatureIndex][humidityIndex], this.pickSwampBiomeVanilla(temperatureIndex, humidityIndex, weirdness));
    }

    protected ResourceKey<Biome> pickRiverBiomeMTA(int temperatureIndex, int humidityIndex) {
        return MtaOverworldBiomeBuilder.biomeOrFallback(MtaBiomeList.MTA_RIVER_BIOMES[temperatureIndex][humidityIndex], temperatureIndex == 0 ? Biomes.FROZEN_RIVER : Biomes.RIVER);
    }

    protected ResourceKey<Biome> pickBeachBiomeMTA(int temperatureIndex, int humidityIndex) {
        return MtaOverworldBiomeBuilder.biomeOrFallback(MtaBiomeList.MTA_BEACH_BIOMES[temperatureIndex][humidityIndex], VanillaBiomeList.BEACH_BIOMES[temperatureIndex][humidityIndex]);
    }

    protected ResourceKey<Biome> pickStonyShoresBiomeMTA(int temperatureIndex, int humidityIndex) {
        return MtaOverworldBiomeBuilder.biomeOrFallback(MtaBiomeList.MTA_STONY_SHORES_BIOMES[temperatureIndex][humidityIndex], Biomes.STONY_SHORE);
    }

    protected ResourceKey<Biome> pickIslandBiomeMTA(int temperatureIndex, int humidityIndex) {
        return MtaOverworldBiomeBuilder.biomeOrFallback(MtaBiomeList.MTA_ISLAND_BIOMES[temperatureIndex][humidityIndex], Biomes.MUSHROOM_FIELDS);
    }

    protected ResourceKey<Biome> pickBadlandsBiome(int humidityIndex, Climate.Parameter weirdness) {
        if (humidityIndex < 2) {
            return weirdness.max() < 0L ? Biomes.ERODED_BADLANDS : Biomes.BADLANDS;
        }
        return humidityIndex < 3 ? Biomes.BADLANDS : Biomes.WOODED_BADLANDS;
    }

    protected ResourceKey<Biome> pickPlateauBiomeMTA(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        if (weirdness.max() < 0L) {
            return MtaOverworldBiomeBuilder.biomeOrFallback(MtaBiomeList.MTA_PLATEAU_BIOMES[temperatureIndex][humidityIndex], VanillaBiomeList.PLATEAU_BIOMES[temperatureIndex][humidityIndex]);
        }
        return MtaOverworldBiomeBuilder.biomeOrFallback(MtaBiomeList.MTA_PLATEAU_BIOMES_VARIANT[temperatureIndex][humidityIndex], MtaBiomeList.MTA_PLATEAU_BIOMES[temperatureIndex][humidityIndex], VanillaBiomeList.PLATEAU_BIOMES_VARIANT[temperatureIndex][humidityIndex], VanillaBiomeList.PLATEAU_BIOMES[temperatureIndex][humidityIndex]);
    }

    protected ResourceKey<Biome> pickPeakBiome(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        if (temperatureIndex <= 2) {
            return weirdness.max() < 0L ? Biomes.JAGGED_PEAKS : Biomes.FROZEN_PEAKS;
        }
        return temperatureIndex == 3 ? Biomes.STONY_PEAKS : this.pickBadlandsBiome(humidityIndex, weirdness);
    }

    protected ResourceKey<Biome> pickPeakBiomeMTA(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        return MtaOverworldBiomeBuilder.biomeOrFallback(MtaBiomeList.MTA_PEAK_BIOMES[temperatureIndex][humidityIndex], this.pickPeakBiome(temperatureIndex, humidityIndex, weirdness));
    }

    protected ResourceKey<Biome> pickSlopeBiomeMTA(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        return MtaOverworldBiomeBuilder.biomeOrFallback(MtaBiomeList.MTA_SLOPE_BIOMES[temperatureIndex][humidityIndex], this.pickPlateauBiomeMTA(temperatureIndex, humidityIndex, weirdness));
    }

    protected ResourceKey<Biome> pickExtremeHillsBiomeVanilla(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        ResourceKey<Biome> resourcekey = VanillaBiomeList.EXTREME_HILLS_BIOMES[temperatureIndex][humidityIndex];
        return resourcekey == null ? this.pickMiddleBiomeVanilla(temperatureIndex, humidityIndex, weirdness) : resourcekey;
    }

    protected ResourceKey<Biome> pickExtremeHillsBiomeMTA(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        return MtaOverworldBiomeBuilder.biomeOrFallback(MtaBiomeList.MTA_EXTREME_HILLS_BIOMES[temperatureIndex][humidityIndex], this.pickExtremeHillsBiomeVanilla(temperatureIndex, humidityIndex, weirdness), VanillaBiomeList.PLATEAU_BIOMES[temperatureIndex][humidityIndex]);
    }
}

