/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.game.worldgen.biomes.surface;

import com.fuyuaki.morethanadventure.core.registry.MtaBlocks;
import com.fuyuaki.morethanadventure.game.worldgen.biomes.MtaBiomes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;

public class MtaSurfaceRules {
    private static final SurfaceRules.RuleSource AIR = MtaSurfaceRules.makeStateRule(Blocks.AIR);
    private static final SurfaceRules.RuleSource BEDROCK = MtaSurfaceRules.makeStateRule(Blocks.BEDROCK);
    private static final SurfaceRules.RuleSource LIGHT_BLUE_TERRACOTTA = MtaSurfaceRules.makeStateRule(Blocks.LIGHT_BLUE_TERRACOTTA);
    private static final SurfaceRules.RuleSource CYAN_TERRACOTTA = MtaSurfaceRules.makeStateRule(Blocks.CYAN_TERRACOTTA);
    private static final SurfaceRules.RuleSource LIGHT_GRAY_TERRACOTTA = MtaSurfaceRules.makeStateRule(Blocks.LIGHT_GRAY_TERRACOTTA);
    private static final SurfaceRules.RuleSource TERRACOTTA = MtaSurfaceRules.makeStateRule(Blocks.TERRACOTTA);
    private static final SurfaceRules.RuleSource STONE = MtaSurfaceRules.makeStateRule(Blocks.STONE);
    private static final SurfaceRules.RuleSource DIRT = MtaSurfaceRules.makeStateRule(Blocks.DIRT);
    private static final SurfaceRules.RuleSource PODZOL = MtaSurfaceRules.makeStateRule(Blocks.PODZOL);
    private static final SurfaceRules.RuleSource GRASSY_DIRT = MtaSurfaceRules.makeStateRule((Block)MtaBlocks.GRASSY_DIRT.get());
    private static final SurfaceRules.RuleSource COARSE_DIRT = MtaSurfaceRules.makeStateRule(Blocks.COARSE_DIRT);
    private static final SurfaceRules.RuleSource GRAVEL = MtaSurfaceRules.makeStateRule(Blocks.GRAVEL);
    private static final SurfaceRules.RuleSource SAND = MtaSurfaceRules.makeStateRule(Blocks.SAND);
    private static final SurfaceRules.RuleSource SANDSTONE = MtaSurfaceRules.makeStateRule(Blocks.SANDSTONE);
    private static final SurfaceRules.RuleSource SNOW_BLOCK = MtaSurfaceRules.makeStateRule(Blocks.SNOW_BLOCK);
    private static final SurfaceRules.RuleSource POWDER_SNOW = MtaSurfaceRules.makeStateRule(Blocks.POWDER_SNOW);
    private static final SurfaceRules.RuleSource WATER = MtaSurfaceRules.makeStateRule(Blocks.WATER);
    private static final SurfaceRules.RuleSource LAVA = MtaSurfaceRules.makeStateRule(Blocks.LAVA);
    private static final SurfaceRules.RuleSource MAGMA = MtaSurfaceRules.makeStateRule(Blocks.MAGMA_BLOCK);
    private static final SurfaceRules.RuleSource OBSIDIAN = MtaSurfaceRules.makeStateRule(Blocks.OBSIDIAN);
    private static final SurfaceRules.RuleSource TUFF = MtaSurfaceRules.makeStateRule(Blocks.TUFF);
    private static final SurfaceRules.RuleSource SMOOTH_BASALT = MtaSurfaceRules.makeStateRule(Blocks.SMOOTH_BASALT);
    private static final SurfaceRules.RuleSource GRASS_BLOCK = MtaSurfaceRules.makeStateRule(Blocks.GRASS_BLOCK);
    private static final SurfaceRules.RuleSource CALCITE = MtaSurfaceRules.makeStateRule(Blocks.CALCITE);

    public static SurfaceRules.RuleSource makeOverworld() {
        SurfaceRules.ConditionSource isAtOrAboveWaterLevel = SurfaceRules.waterBlockCheck((int)-1, (int)0);
        SurfaceRules.ConditionSource sixBelowWater = SurfaceRules.waterStartCheck((int)-6, (int)-1);
        SurfaceRules.RuleSource grassSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isAtOrAboveWaterLevel, (SurfaceRules.RuleSource)GRASS_BLOCK), DIRT});
        SurfaceRules.ConditionSource isTop5Blocks = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.belowTop((int)5), (int)0);
        SurfaceRules.ConditionSource isHole = SurfaceRules.hole();
        SurfaceRules.ConditionSource isSteep = SurfaceRules.steep();
        SurfaceRules.RuleSource powderedSnowSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)POWDER_SNOW), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)POWDER_SNOW)});
        SurfaceRules.RuleSource snowSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SNOW_BLOCK), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SNOW_BLOCK)});
        SurfaceRules.RuleSource gravelStoneSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)GRAVEL), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)STONE)});
        SurfaceRules.RuleSource sandstoneLinedSand = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_CEILING, (SurfaceRules.RuleSource)SANDSTONE), SAND});
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)sixBelowWater, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{MtaBiomes.OASIS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.GRAVEL, (double)-0.25, (double)0.3), (SurfaceRules.RuleSource)grassSurface), SAND}))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{MtaBiomes.OASIS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.GRAVEL, (double)-0.1, (double)0.1), (SurfaceRules.RuleSource)DIRT), sandstoneLinedSand}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.DEEP_UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{MtaBiomes.OASIS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.GRAVEL, (double)-0.1, (double)0.1), (SurfaceRules.RuleSource)STONE), SANDSTONE}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{MtaBiomes.GRAVELLY_RIVER}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.GRAVEL, (double)-0.3, (double)0.3), (SurfaceRules.RuleSource)gravelStoneSurface)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)grassSurface)}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{MtaBiomes.CRYSTALLINE_GROTTO}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.CALCITE, (double)-0.04, (double)0.0), (SurfaceRules.RuleSource)CALCITE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.CALCITE, (double)-0.23, (double)-0.2), (SurfaceRules.RuleSource)CALCITE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.CALCITE, (double)-0.8, (double)-0.68), (SurfaceRules.RuleSource)CALCITE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.CALCITE, (double)0.45, (double)0.77), (SurfaceRules.RuleSource)CALCITE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.CALCITE, (double)0.82, (double)0.85), (SurfaceRules.RuleSource)CALCITE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.CALCITE, (double)0.95, (double)1.0), (SurfaceRules.RuleSource)CALCITE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.CALCITE, (double)-0.5, (double)-0.45), (SurfaceRules.RuleSource)CALCITE)}))});
    }

    private static SurfaceRules.RuleSource makeStateRule(Block block) {
        return SurfaceRules.state((BlockState)block.defaultBlockState());
    }

    private static SurfaceRules.ConditionSource surfaceNoiseAbove(double p_194809_) {
        return SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)(p_194809_ / 8.25), (double)Double.MAX_VALUE);
    }

    private static SurfaceRules.ConditionSource surfaceNoiseBelow(double p_194809_) {
        return SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)Double.MIN_VALUE, (double)(p_194809_ / 8.25));
    }
}

