/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.mixin;

import com.fuyuaki.morethanadventure.core.MTACommonConfig;
import com.fuyuaki.morethanadventure.core.registry.MtaBlocks;
import com.fuyuaki.morethanadventure.world.block.Sprinkler;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FarmBlock.class})
public abstract class FarmBlockMixin
extends Block {
    private static final int range = MTACommonConfig.sprinklerRange > 1 ? MTACommonConfig.sprinklerRange : 8;

    public FarmBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(method={"isNearWater(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="TAIL")}, cancellable=true)
    private static void isNearWater(LevelReader pLevel, BlockPos pPos, CallbackInfoReturnable<Boolean> cir) {
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pPos.offset(-range, -1, -range), (BlockPos)pPos.offset(range, 2, range))) {
            BlockState blockState = pLevel.getBlockState(blockpos);
            if (!blockState.is((Block)MtaBlocks.SPRINKLER.get()) || !((Boolean)blockState.getValue((Property)Sprinkler.ON)).booleanValue()) continue;
            cir.setReturnValue((Object)true);
        }
    }
}

