/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.world.block;

import com.fuyuaki.morethanadventure.core.registry.MtaParticles;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class GeyserBlock
extends Block {
    public static final BooleanProperty ERUPTING = BooleanProperty.create((String)"erupting");
    private final boolean nether;
    private static final int maxHeight = 16;

    public GeyserBlock(BlockBehaviour.Properties p_49795_, boolean isNether) {
        super(p_49795_.randomTicks());
        this.nether = isNether;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)ERUPTING, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{ERUPTING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)ERUPTING, (Comparable)Boolean.FALSE);
    }

    public boolean isErupting(BlockState state) {
        return (Boolean)state.getValue((Property)ERUPTING);
    }

    private void setEruptingAtHeight(Boolean bool, BlockState state, Level level, BlockPos pos) {
        level.setBlock(pos, (BlockState)state.setValue((Property)ERUPTING, (Comparable)bool), 3);
    }

    protected void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.randomTick(pState, pLevel, pPos, pRandom);
        if (this.isErupting(pState)) {
            this.setEruptingAtHeight(Boolean.FALSE, pState, (Level)pLevel, pPos);
            return;
        }
        if (pRandom.nextFloat() > 0.4f) {
            return;
        }
        pLevel.playSound(null, pPos, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 1.2f, 0.1f);
        this.setEruptingAtHeight(Boolean.TRUE, pState, (Level)pLevel, pPos);
        AABB aabb = new AABB(pPos).expandTowards(pPos.above(16).getCenter());
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        super.animateTick(pState, pLevel, pPos, pRandom);
        if (this.isErupting(pState)) {
            AABB aabb = new AABB(pPos.below()).expandTowards(pPos.above(16).getCenter()).inflate(0.5);
            pLevel.getEntitiesOfClass(LivingEntity.class, aabb, livingEntity -> livingEntity.hurt(livingEntity.damageSources().hotFloor(), 2.0f));
            int a = 0;
            while (this.nether ? a < 20 : a < 60) {
                pLevel.addAlwaysVisibleParticle(this.nether ? (ParticleOptions)MtaParticles.GEYSER_LAVA.get() : (ParticleOptions)MtaParticles.GEYSER_WATER.get(), true, (double)pPos.getX() + 0.5 + pRandom.triangle(-0.1, 0.1), (double)pPos.getY() + 1.2, (double)pPos.getZ() + 0.5 + pRandom.triangle(-0.1, 0.1), 0.0, 0.0, 0.0);
                ++a;
            }
        }
    }
}

