/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.world.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MTAPathBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    protected final Block replacementBlock;

    public MTAPathBlock(BlockBehaviour.Properties p_49795_, Block block) {
        super(p_49795_);
        this.replacementBlock = block;
    }

    protected boolean useShapeForLightOcclusion(BlockState p_153159_) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_153131_) {
        return !this.defaultBlockState().canSurvive((LevelReader)p_153131_.getLevel(), p_153131_.getClickedPos()) ? Block.pushEntitiesUp((BlockState)this.defaultBlockState(), (BlockState)this.replacementBlock.defaultBlockState(), (LevelAccessor)p_153131_.getLevel(), (BlockPos)p_153131_.getClickedPos()) : super.getStateForPlacement(p_153131_);
    }

    protected BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (pDirection == Direction.UP && !pState.canSurvive((LevelReader)pLevel, pPos)) {
            pLevel.scheduleTick(pPos, (Block)this, 1);
        }
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    protected void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pState.canSurvive((LevelReader)pLevel, pPos)) {
            this.turnToReplacementBlock(null, pState, (Level)pLevel, pPos);
        }
    }

    public void turnToReplacementBlock(@Nullable Entity pEntity, BlockState pState, Level pLevel, BlockPos pPos) {
        BlockState blockstate = MTAPathBlock.pushEntitiesUp((BlockState)pState, (BlockState)this.replacementBlock.defaultBlockState(), (LevelAccessor)pLevel, (BlockPos)pPos);
        pLevel.setBlockAndUpdate(pPos, blockstate);
        pLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pPos, GameEvent.Context.of((Entity)pEntity, (BlockState)blockstate));
    }

    protected boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.getBlockState(pPos.above());
        return !blockstate.isSolid() || blockstate.getBlock() instanceof FenceGateBlock;
    }

    protected VoxelShape getShape(BlockState p_153143_, BlockGetter p_153144_, BlockPos p_153145_, CollisionContext p_153146_) {
        return SHAPE;
    }

    protected boolean isPathfindable(BlockState p_153138_, PathComputationType p_153141_) {
        return true;
    }
}

