/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.world.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShardClusterBlock
extends DropExperienceBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    protected final VoxelShape northAabb = Block.box((double)3.0, (double)3.0, (double)4.0, (double)13.0, (double)13.0, (double)16.0);
    protected final VoxelShape southAabb = Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)12.0);
    protected final VoxelShape eastAabb = Block.box((double)0.0, (double)3.0, (double)3.0, (double)12.0, (double)13.0, (double)13.0);
    protected final VoxelShape westAabb = Block.box((double)4.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    protected final VoxelShape upAabb = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
    protected final VoxelShape downAabb = Block.box((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);

    public ShardClusterBlock(BlockBehaviour.Properties p_151999_) {
        super((IntProvider)UniformInt.of((int)1, (int)2), p_151999_);
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        switch (direction) {
            case NORTH: {
                return this.northAabb;
            }
            case SOUTH: {
                return this.southAabb;
            }
            case EAST: {
                return this.eastAabb;
            }
            case WEST: {
                return this.westAabb;
            }
            case DOWN: {
                return this.downAabb;
            }
        }
        return this.upAabb;
    }

    protected boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        BlockPos blockpos = pPos.relative(direction.getOpposite());
        return pLevel.getBlockState(blockpos).isFaceSturdy((BlockGetter)pLevel, blockpos, direction);
    }

    protected BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return pDirection == ((Direction)pState.getValue((Property)FACING)).getOpposite() && !pState.canSurvive((LevelReader)pLevel, pPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Level levelaccessor = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.getFluidState(blockpos).getType() == Fluids.WATER))).setValue((Property)FACING, (Comparable)pContext.getClickedFace());
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)direction.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    protected FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{WATERLOGGED, FACING});
    }
}

