/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.world.block;

import com.fuyuaki.morethanadventure.world.block.ShardClusterBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;

public class ShardGrowthBlock
extends Block {
    private final Block replacement;
    private final ShardClusterBlock shardClusterBlock;
    private static final Direction[] DIRECTIONS = Direction.values();

    public ShardGrowthBlock(Block replacement, ShardClusterBlock shardClusterBlock, BlockBehaviour.Properties p_49795_) {
        super(p_49795_.randomTicks());
        this.replacement = replacement;
        this.shardClusterBlock = shardClusterBlock;
    }

    protected void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pRandom.nextInt(5) == 0) {
            Direction direction = DIRECTIONS[pRandom.nextInt(DIRECTIONS.length)];
            BlockPos blockpos = pPos.relative(direction);
            BlockState blockstate = pLevel.getBlockState(blockpos);
            ShardClusterBlock block = null;
            if (ShardGrowthBlock.canClusterGrowAtState(blockstate)) {
                block = this.shardClusterBlock;
            }
            if (block != null) {
                BlockState blockstate1 = (BlockState)((BlockState)block.defaultBlockState().setValue((Property)ShardClusterBlock.FACING, (Comparable)direction)).setValue((Property)ShardClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(blockstate.getFluidState().getType() == Fluids.WATER));
                pLevel.setBlockAndUpdate(blockpos, blockstate1);
            }
        }
    }

    public static boolean canClusterGrowAtState(BlockState pState) {
        return pState.isAir() || pState.is(Blocks.WATER) && pState.getFluidState().getAmount() == 8;
    }
}

