/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.world.block;

import com.fuyuaki.morethanadventure.core.registry.MtaBlockEntities;
import com.fuyuaki.morethanadventure.world.block.entity.SprinklerEntity;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Sprinkler
extends BaseEntityBlock {
    public static final MapCodec<Sprinkler> CODEC = Sprinkler.simpleCodec(Sprinkler::new);
    public static final BooleanProperty ON = BooleanProperty.create((String)"enabled");
    private static final VoxelShape SHAPE = Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape)Block.box((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)17.0, (double)12.0), (BooleanOp)BooleanOp.OR);

    public Sprinkler(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)ON, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{ON});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)ON, (Comparable)Boolean.valueOf(false));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        if (pLevel.isClientSide) {
            if (pPlayer.isCrouching()) {
                pLevel.playLocalSound(pPos, SoundEvents.WOODEN_BUTTON_CLICK_OFF, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            return InteractionResult.SUCCESS;
        }
        BlockState state = pLevel.getBlockState(pPos);
        if (((Boolean)state.getValue((Property)ON)).booleanValue() && pPlayer.isCrouching()) {
            pLevel.setBlock(pPos, (BlockState)state.setValue((Property)ON, (Comparable)Boolean.valueOf(false)), 3);
        } else if (!((Boolean)state.getValue((Property)ON)).booleanValue() && pPlayer.isCrouching()) {
            pLevel.setBlock(pPos, (BlockState)state.setValue((Property)ON, (Comparable)Boolean.valueOf(true)), 3);
        }
        return InteractionResult.CONSUME;
    }

    protected void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.tick(pState, pLevel, pPos, pRandom);
        BlockState state = pLevel.getBlockState(pPos);
        if (((Boolean)state.getValue((Property)ON)).booleanValue() && pLevel.random.nextFloat() > 0.6f) {
            pLevel.addParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, (double)pPos.getX(), (double)pPos.above().getY(), (double)pPos.getZ(), 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide) {
            return (Boolean)pState.getValue((Property)ON) != false ? Sprinkler.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)MtaBlockEntities.SPRINKLER.get()), SprinklerEntity::particleTick) : null;
        }
        return (Boolean)pState.getValue((Property)ON) != false ? Sprinkler.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)MtaBlockEntities.SPRINKLER.get()), SprinklerEntity::growthTick) : null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)MtaBlockEntities.SPRINKLER.get()).create(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

