/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.world.block;

import com.fuyuaki.morethanadventure.core.registry.MtaBlocks;
import com.fuyuaki.morethanadventure.core.registry.MtaTags;
import com.fuyuaki.morethanadventure.world.block.SandPathBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.ItemAbilities;

public class StoneTilesBlock
extends Block {
    protected final int dirtiness;

    public StoneTilesBlock(BlockBehaviour.Properties p_49795_, int dirtiness) {
        super(p_49795_);
        this.dirtiness = dirtiness;
    }

    protected boolean isRandomlyTicking(BlockState pState) {
        return this.dirtiness < 3;
    }

    protected void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.randomTick(pState, pLevel, pPos, pRandom);
        if ((double)pRandom.nextFloat() < 0.25 && pLevel.getBlockStates(new AABB(pPos).inflate(2.0)).anyMatch(state -> state.is(MtaTags.Blocks.DIRTIES_STONE_TILES))) {
            pLevel.setBlockAndUpdate(pPos, this.getStoneTilesByDirtiness(this.dirtiness + 1));
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (pStack.canPerformAction(ItemAbilities.SHOVEL_FLATTEN) && this.dirtiness > 0) {
            pLevel.playSound(pPlayer, pPos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 0.3f);
            pLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pPos, GameEvent.Context.of((Entity)pPlayer, (BlockState)((SandPathBlock)((Object)MtaBlocks.SAND_PATH.get())).defaultBlockState()));
            pLevel.setBlockAndUpdate(pPos, this.getStoneTilesByDirtiness(this.dirtiness - 1));
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    private BlockState getStoneTilesByDirtiness(int dirtiness) {
        return switch (dirtiness) {
            case 1 -> ((Block)MtaBlocks.SLIGHTLY_DIRTY_STONE_TILES.get()).defaultBlockState();
            case 2 -> ((Block)MtaBlocks.DIRTY_STONE_TILES.get()).defaultBlockState();
            case 3 -> ((Block)MtaBlocks.VERY_DIRTY_STONE_TILES.get()).defaultBlockState();
            default -> ((Block)MtaBlocks.STONE_TILES.get()).defaultBlockState();
        };
    }
}

