/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.world.block.entity;

import com.fuyuaki.morethanadventure.core.MTACommonConfig;
import com.fuyuaki.morethanadventure.core.registry.MtaBlockEntities;
import com.fuyuaki.morethanadventure.core.registry.MtaParticles;
import com.fuyuaki.morethanadventure.world.block.Sprinkler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.Tags;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SprinklerEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation RUN = RawAnimation.begin().thenPlay("animation.sprinkler.pop").thenLoop("animation.sprinkler.spin");
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("animation.sprinkler.stop").thenLoop("animation.sprinkler.idle");

    public SprinklerEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)MtaBlockEntities.SPRINKLER.get(), pPos, pBlockState);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, state -> {
            if (((Boolean)((SprinklerEntity)state.getAnimatable()).getBlockState().getValue((Property)Sprinkler.ON)).booleanValue()) {
                return state.setAndContinue(RUN);
            }
            return state.setAndContinue(IDLE);
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static void particleTick(Level level, BlockPos blockPos, BlockState blockState, SprinklerEntity sprinklerEntity) {
        for (int p = 0; p < 4; ++p) {
            level.addParticle((ParticleOptions)MtaParticles.SPRINKLER.get(), (double)blockPos.getX() + 0.5, (double)blockPos.above().above().getY(), (double)blockPos.getZ() + 0.5, 0.0, 0.0, 0.0);
        }
        for (int k = 0; k < 10; ++k) {
            float cRange = (float)(MTACommonConfig.sprinklerRange / 10 * k) / 25.0f;
            float xRange = cRange * (float)level.random.nextIntBetweenInclusive(-20, 20) / 20.0f;
            float zRange = cRange * (float)level.random.nextIntBetweenInclusive(-20, 20) / 20.0f;
            if (!level.getBlockState(blockPos.below()).is(Tags.Blocks.VILLAGER_FARMLANDS)) continue;
            level.addParticle((ParticleOptions)ParticleTypes.FALLING_WATER, blockPos.getCenter().x + (double)xRange, blockPos.getCenter().y + 0.5, blockPos.getCenter().z + (double)zRange, 0.0, 0.0, 0.0);
        }
    }

    public static void growthTick(Level level, BlockPos blockPos, BlockState blockState, SprinklerEntity sprinklerEntity) {
        int range = MTACommonConfig.sprinklerRange;
        if ((double)level.random.nextFloat() < 0.005) {
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)blockPos.east(range).above(2).south(range), (BlockPos)blockPos.west(range).below().north(range))) {
                BlockState state = level.getBlockState(pos);
                if (!((double)level.random.nextFloat() < 0.001) || !state.is(BlockTags.CROPS)) continue;
                for (int a = 0; a < level.random.nextInt(5); ++a) {
                    state.randomTick((ServerLevel)level, pos, level.random);
                }
                level.playSound(null, pos, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        }
    }
}

