/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.world.entity.Arrows;

import com.fuyuaki.morethanadventure.core.registry.MtaEntityTypes;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class MTAArrowEntity
extends AbstractArrow {
    private final float damage;
    private final double movementScalar;

    public MTAArrowEntity(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.damage = 2.0f;
        this.movementScalar = 0.2f;
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    public MTAArrowEntity(double pX, double pY, double pZ, Level pLevel, float damage, double movementScalar, ItemStack weapon) {
        super((EntityType)MtaEntityTypes.MTA_ARROW.get(), pX, pY, pZ, pLevel, Items.ARROW.getDefaultInstance(), weapon);
        this.damage = damage;
        this.baseDamage = damage;
        this.movementScalar = movementScalar;
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    public MTAArrowEntity(LivingEntity pOwner, Level pLevel, float damage, double movementScalar, ItemStack weapon) {
        super((EntityType)MtaEntityTypes.MTA_ARROW.get(), pOwner, pLevel, Items.ARROW.getDefaultInstance(), weapon);
        this.damage = damage;
        this.baseDamage = damage;
        this.movementScalar = movementScalar;
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    public boolean isPickable() {
        return false;
    }

    protected double getDefaultGravity() {
        return 0.005f;
    }

    protected ItemStack getDefaultPickupItem() {
        return Items.ARROW.getDefaultInstance();
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.inGround) {
                if (this.inGroundTime % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        } else if (this.inGround && this.inGroundTime != 0 && this.inGroundTime >= 600) {
            this.level().broadcastEntityEvent((Entity)this, (byte)0);
            this.setPickupItemStack(new ItemStack((ItemLike)Items.ARROW));
        }
    }

    private void makeParticle(int pParticleAmount) {
        if (pParticleAmount > 0) {
            for (int j = 0; j < pParticleAmount; ++j) {
                this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)255, (int)3336959)), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHitEntity(EntityHitResult pResult) {
        Level level;
        Entity entity = pResult.getEntity();
        double d0 = this.getBaseDamage();
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.damageSources().arrow((AbstractArrow)this, (Entity)(entity1 != null ? entity1 : this));
        if (this.getWeaponItem() != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            d0 = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damagesource, (float)((float)d0));
        }
        int j = Mth.ceil((double)Mth.clamp((double)d0, (double)0.0, (double)2.147483647E9));
        if (this.getPierceLevel() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercingIgnoreEntityIds.size() >= this.getPierceLevel() + 1) {
                this.discard();
                return;
            }
            this.piercingIgnoreEntityIds.add(entity.getId());
        }
        if (this.isCritArrow()) {
            long k = this.random.nextInt(j / 2 + 2);
            j = (int)Math.min(k + (long)j, Integer.MAX_VALUE);
        }
        if (entity1 instanceof LivingEntity) {
            LivingEntity livingentity1 = (LivingEntity)entity1;
            livingentity1.setLastHurtMob(entity);
        }
        boolean flag = entity.getType() == EntityType.ENDERMAN;
        int i = entity.getRemainingFireTicks();
        if (this.isOnFire() && !flag) {
            entity.igniteForSeconds(5.0f);
        }
        if (entity.hurt(damagesource, (float)j)) {
            if (flag) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                if (!this.level().isClientSide && this.getPierceLevel() <= 0) {
                    livingentity.setArrowCount(livingentity.getArrowCount() + 1);
                }
                this.doKnockback(livingentity, damagesource);
                Level level2 = this.level();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverlevel1 = (ServerLevel)level2;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverlevel1, (Entity)livingentity, (DamageSource)damagesource, (ItemStack)this.getWeaponItem());
                }
                this.doPostHurtEffects(livingentity);
                if (livingentity != entity1 && livingentity instanceof Player && entity1 instanceof ServerPlayer && !this.isSilent()) {
                    ((ServerPlayer)entity1).connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                }
                if (!entity.isAlive() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add(livingentity);
                }
                if (!this.level().isClientSide && entity1 instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)entity1;
                    if (this.piercedAndKilledEntities != null && this.shotFromCrossbow()) {
                        CriteriaTriggers.KILLED_BY_CROSSBOW.trigger(serverplayer, (Collection)this.piercedAndKilledEntities);
                    } else if (!entity.isAlive() && this.shotFromCrossbow()) {
                        CriteriaTriggers.KILLED_BY_CROSSBOW.trigger(serverplayer, Arrays.asList(entity));
                    }
                }
            }
            this.playSound(this.soundEvent, 1.0f, 1.5f / (this.random.nextFloat() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0) {
                this.discard();
            }
        } else {
            entity.setRemainingFireTicks(i);
            this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), false);
            this.setDeltaMovement(this.getDeltaMovement().scale(this.movementScalar));
            if (!this.level().isClientSide && this.getDeltaMovement().lengthSqr() < 1.0E-7) {
                if (this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            }
        }
    }

    public double getBaseDamage() {
        return this.damage;
    }

    public void setBaseDamageFromMob(float pVelocity) {
        super.setBaseDamageFromMob(this.damage / 2.0f);
    }
}

