/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.world.entity;

import com.fuyuaki.morethanadventure.core.registry.MtaEntityTypes;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Butterfly
extends Animal
implements FlyingAnimal,
GeoEntity {
    public int pattern = 0;
    public int overlay = 0;
    protected static final RawAnimation LANDED = RawAnimation.begin().thenLoop("animation.butterfly.landed");
    protected static final RawAnimation FLIGHT = RawAnimation.begin().thenLoop("animation.butterfly.flight");
    private static final int TICKS_PER_FLAP = Mth.ceil((float)1.4959966f);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> DATA_ID_PATTERN = SynchedEntityData.defineId(Butterfly.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_ID_OVERLAY = SynchedEntityData.defineId(Butterfly.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Byte> DATA_ID_COLOR = SynchedEntityData.defineId(Butterfly.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> DATA_ID_COLOR_OVERLAY = SynchedEntityData.defineId(Butterfly.class, (EntityDataSerializer)EntityDataSerializers.BYTE);

    public Butterfly(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.setPathfindingMalus(PathType.LEAVES, 0.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(2, (Goal)new ButterflyWanderGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new FollowMobGoal((Mob)this, 1.0, 1.0f, 7.0f));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.25, p_335831_ -> p_335831_.is(ItemTags.FLOWERS), false));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(9, (Goal)new FloatGoal((Mob)this));
    }

    public void checkDespawn() {
        super.checkDespawn();
    }

    protected void checkFallDamage(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    public boolean isFood(ItemStack pStack) {
        return pStack.is(ItemTags.FLOWERS);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        Butterfly otherParent = (Butterfly)pOtherParent;
        Butterfly baby = (Butterfly)((EntityType)MtaEntityTypes.BUTTERFLY.get()).create((Level)pLevel);
        if (baby == null) {
            return null;
        }
        int pattern = pLevel.getRandom().nextBoolean() ? this.getPattern() : otherParent.getPattern();
        int overlay = pLevel.getRandom().nextBoolean() ? this.getOverlay() : otherParent.getOverlay();
        DyeColor patColor = pLevel.getRandom().nextBoolean() ? this.getColor() : otherParent.getColor();
        DyeColor overlayColor = pLevel.getRandom().nextBoolean() ? this.getOverlayColor() : otherParent.getOverlayColor();
        baby.setPatternAndColor(pattern, patColor);
        baby.setOverlayAndColor(overlay, overlayColor);
        return baby;
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    protected PathNavigation createNavigation(Level pLevel) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, pLevel);
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(false);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    public boolean isFlapping() {
        return this.isFlying() && this.tickCount % TICKS_PER_FLAP == 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.FOLLOW_RANGE, 7.0).add(Attributes.FLYING_SPEED, 0.5).add(Attributes.MOVEMENT_SPEED, (double)0.1f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_ID_PATTERN, (Object)0);
        pBuilder.define(DATA_ID_OVERLAY, (Object)1);
        pBuilder.define(DATA_ID_COLOR, (Object)1);
        pBuilder.define(DATA_ID_COLOR_OVERLAY, (Object)1);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setPatternAndColor(pCompound.getInt("Pattern"), DyeColor.byId((int)pCompound.getByte("Color")));
        this.setOverlayAndColor(pCompound.getInt("Overlay"), DyeColor.byId((int)pCompound.getByte("OverlayColor")));
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Pattern", this.getPattern());
        pCompound.putInt("Overlay", this.getOverlay());
        pCompound.putByte("Color", (byte)this.getColor().getId());
        pCompound.putByte("OverlayColor", (byte)this.getOverlayColor().getId());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, 10, state -> {
            if (((Butterfly)state.getAnimatable()).onGround()) {
                return state.setAndContinue(LANDED);
            }
            return state.setAndContinue(FLIGHT);
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public DyeColor getColor() {
        return DyeColor.byId((int)((Byte)this.entityData.get(DATA_ID_COLOR)).byteValue());
    }

    public DyeColor getOverlayColor() {
        return DyeColor.byId((int)((Byte)this.entityData.get(DATA_ID_COLOR_OVERLAY)).byteValue());
    }

    public void setPatternAndColor(int id, DyeColor pDyeColor) {
        byte b0 = (Byte)this.entityData.get(DATA_ID_COLOR);
        this.entityData.set(DATA_ID_COLOR, (Object)((byte)(b0 & 0xF0 | pDyeColor.getId() & 0xF)));
        this.entityData.set(DATA_ID_PATTERN, (Object)id);
        this.pattern = id;
    }

    public void setOverlayAndColor(int id, DyeColor pDyeColor) {
        byte b0 = (Byte)this.entityData.get(DATA_ID_COLOR_OVERLAY);
        this.entityData.set(DATA_ID_COLOR_OVERLAY, (Object)((byte)(b0 & 0xF0 | pDyeColor.getId() & 0xF)));
        this.entityData.set(DATA_ID_OVERLAY, (Object)id);
        this.overlay = id;
    }

    public int getPattern() {
        return (Integer)this.entityData.get(DATA_ID_PATTERN);
    }

    public int getOverlay() {
        return (Integer)this.entityData.get(DATA_ID_OVERLAY);
    }

    @javax.annotation.Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pSpawnType, @javax.annotation.Nullable SpawnGroupData pSpawnGroupData) {
        int overlay;
        RandomSource randomsource = pLevel.getRandom();
        Object[] adyecolor = DyeColor.values();
        DyeColor dyecolor = (DyeColor)Util.getRandom((Object[])adyecolor, (RandomSource)randomsource);
        DyeColor dyecolorb = (DyeColor)Util.getRandom((Object[])adyecolor, (RandomSource)randomsource);
        int pattern = pLevel.getRandom().nextInt(2);
        this.overlay = overlay = pLevel.getRandom().nextInt(3);
        this.pattern = pattern;
        this.setPatternAndColor(pattern, dyecolor);
        this.setOverlayAndColor(overlay, dyecolorb);
        return super.finalizeSpawn(pLevel, pDifficulty, pSpawnType, pSpawnGroupData);
    }

    static class ButterflyWanderGoal
    extends WaterAvoidingRandomFlyingGoal {
        public ButterflyWanderGoal(PathfinderMob p_186224_, double p_186225_) {
            super(p_186224_, p_186225_);
        }

        @javax.annotation.Nullable
        protected Vec3 getPosition() {
            Vec3 vec3 = null;
            if (this.mob.isInWater()) {
                vec3 = this.mob.getViewVector(0.0f);
                vec3 = HoverRandomPos.getPos((PathfinderMob)this.mob, (int)12, (int)9, (double)vec3.x, (double)vec3.z, (float)1.5707964f, (int)3, (int)1);
            }
            if (this.mob.getRandom().nextFloat() >= 0.8f) {
                vec3 = LandRandomPos.getPos((PathfinderMob)this.mob, (int)12, (int)7);
            }
            if (this.mob.getRandom().nextFloat() <= this.probability) {
                vec3 = this.getFlowerPos();
            }
            return vec3 == null ? super.getPosition() : vec3;
        }

        @javax.annotation.Nullable
        private Vec3 getFlowerPos() {
            BlockPos blockpos = this.mob.blockPosition();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
            for (BlockPos blockpos1 : BlockPos.betweenClosed((int)Mth.floor((double)(this.mob.getX() - 3.0)), (int)Mth.floor((double)(this.mob.getY() - 6.0)), (int)Mth.floor((double)(this.mob.getZ() - 3.0)), (int)Mth.floor((double)(this.mob.getX() + 3.0)), (int)Mth.floor((double)(this.mob.getY() + 6.0)), (int)Mth.floor((double)(this.mob.getZ() + 3.0)))) {
                BlockState blockstate;
                boolean flag;
                if (blockpos.equals((Object)blockpos1) || !(flag = (blockstate = this.mob.level().getBlockState((BlockPos)blockpos$mutableblockpos1.setWithOffset((Vec3i)blockpos1, Direction.DOWN))).getBlock() instanceof FlowerBlock || blockstate.is(BlockTags.FLOWERS)) || !this.mob.level().isEmptyBlock(blockpos1) || !this.mob.level().isEmptyBlock((BlockPos)blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos1, Direction.UP))) continue;
                return Vec3.atBottomCenterOf((Vec3i)blockpos1);
            }
            return null;
        }
    }
}

