/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.world.entity;

import com.fuyuaki.morethanadventure.core.registry.MtaEntityTypes;
import com.fuyuaki.morethanadventure.core.registry.MtaItems;
import com.fuyuaki.morethanadventure.world.entity.MTATameableAnimal;
import java.util.EnumSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HorseshoeCrab
extends MTATameableAnimal
implements GeoEntity {
    protected static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.horseshoe_crab.walk");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public HorseshoeCrab(EntityType<? extends MTATameableAnimal> pEntityType, Level pLevel) {
        super(40.0f, pEntityType, pLevel);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 0.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new TamableAnimal.TamableAnimalPanicGoal((TamableAnimal)this, 1.5, DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES));
        this.goalSelector.addGoal(2, (Goal)new HorseshoeCrabSitWhenOrderedToGoal(this, this));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 10.0, stack -> stack.is(MtaItems.SHRIMP), false));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 13.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 20));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.FOLLOW_RANGE, 12.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.WATER_MOVEMENT_EFFICIENCY, (double)2.2f).add(Attributes.ARMOR, 3.0);
    }

    public int getMaxAirSupply() {
        return 1480000;
    }

    protected int decreaseAirSupply(int pCurrentAir) {
        return pCurrentAir;
    }

    public boolean isFood(ItemStack pStack) {
        return pStack.is(MtaItems.SHRIMP);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        HorseshoeCrab horseshoeCrab = (HorseshoeCrab)((EntityType)MtaEntityTypes.HORSESHOE_CRAB.get()).create((Level)pLevel);
        return horseshoeCrab;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, 10, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(WALK);
            }
            return state.setAndContinue(DefaultAnimations.IDLE);
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.setClimbing(this.horizontalCollision);
        }
    }

    public boolean onClimbable() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        return ((Byte)this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean pClimbing) {
        byte b0 = (Byte)this.entityData.get(DATA_FLAGS_ID);
        b0 = pClimbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.entityData.set(DATA_FLAGS_ID, (Object)b0);
    }

    class HorseshoeCrabSitWhenOrderedToGoal
    extends Goal {
        private final TamableAnimal mob;

        public HorseshoeCrabSitWhenOrderedToGoal(HorseshoeCrab this$0, TamableAnimal pMob) {
            this.mob = pMob;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean canContinueToUse() {
            return this.mob.isOrderedToSit();
        }

        public boolean canUse() {
            if (!this.mob.isTame()) {
                return false;
            }
            if (!this.mob.isInWaterOrBubble()) {
                return false;
            }
            LivingEntity livingentity = this.mob.getOwner();
            if (livingentity == null) {
                return true;
            }
            return this.mob.distanceToSqr((Entity)livingentity) < 144.0 && livingentity.getLastHurtByMob() != null ? false : this.mob.isOrderedToSit();
        }

        public void start() {
            this.mob.getNavigation().stop();
            this.mob.setInSittingPose(true);
        }

        public void stop() {
            this.mob.setInSittingPose(false);
        }
    }
}

