/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.world.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public interface MTAPlacementTypes
extends SpawnPlacementTypes {
    public static final SpawnPlacementType VALID_GROUND = new SpawnPlacementType(){

        public boolean isSpawnPositionOk(LevelReader levelReader, BlockPos pos, @Nullable EntityType<?> entityType) {
            if (entityType != null && levelReader.getWorldBorder().isWithinBounds(pos)) {
                BlockPos blockpos = pos.above();
                BlockPos below = pos.below();
                BlockState blockstate = levelReader.getBlockState(below);
                if (blockstate.isValidSpawn((BlockGetter)levelReader, below, entityType)) {
                    return this.isValidEmptySpawnBlock(levelReader, pos, entityType) && this.isValidEmptySpawnBlock(levelReader, blockpos, entityType);
                }
                return levelReader.getFluidState(pos).is(FluidTags.WATER) && !levelReader.getBlockState(blockpos).isRedstoneConductor((BlockGetter)levelReader, blockpos) && !levelReader.getBlockState(below.below(2)).isAir();
            }
            return false;
        }

        private boolean isValidEmptySpawnBlock(LevelReader reader, BlockPos pos, EntityType<?> type) {
            BlockState blockstate = reader.getBlockState(pos);
            return NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)reader, (BlockPos)pos, (BlockState)blockstate, (FluidState)blockstate.getFluidState(), type);
        }
    };
    public static final SpawnPlacementType GROUND_OR_AIR = new SpawnPlacementType(){

        public boolean isSpawnPositionOk(LevelReader levelReader, BlockPos pos, @Nullable EntityType<?> entityType) {
            if (entityType != null && levelReader.getWorldBorder().isWithinBounds(pos)) {
                BlockPos blockpos = pos.above();
                BlockPos belowPos = pos.below();
                BlockState blockstate = levelReader.getBlockState(belowPos);
                if (blockstate.isValidSpawn((BlockGetter)levelReader, belowPos, entityType)) {
                    return this.isValidEmptySpawnBlock(levelReader, pos, entityType) && this.isValidEmptySpawnBlock(levelReader, blockpos, entityType);
                }
                return levelReader.getBlockState(pos).isAir() && !levelReader.getBlockState(belowPos.below(2)).isAir();
            }
            return false;
        }

        private boolean isValidEmptySpawnBlock(LevelReader reader, BlockPos pos, EntityType<?> type) {
            BlockState blockstate = reader.getBlockState(pos);
            return NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)reader, (BlockPos)pos, (BlockState)blockstate, (FluidState)blockstate.getFluidState(), type);
        }
    };
    public static final SpawnPlacementType GROUND_OR_WATER = new SpawnPlacementType(){

        public boolean isSpawnPositionOk(LevelReader levelReader, BlockPos pos, @Nullable EntityType<?> entityType) {
            if (entityType != null && levelReader.getWorldBorder().isWithinBounds(pos)) {
                BlockPos blockpos = pos.above();
                BlockPos blockpos1 = pos.below();
                BlockState blockstate = levelReader.getBlockState(blockpos1);
                return !blockstate.isValidSpawn((BlockGetter)levelReader, blockpos1, entityType) ? levelReader.getFluidState(pos).is(FluidTags.WATER) && !levelReader.getBlockState(blockpos).isRedstoneConductor((BlockGetter)levelReader, blockpos) : (this.isValidEmptySpawnBlock(levelReader, pos, entityType) || levelReader.getFluidState(pos).is(FluidTags.WATER)) && this.isValidEmptySpawnBlock(levelReader, blockpos, entityType);
            }
            return false;
        }

        private boolean isValidEmptySpawnBlock(LevelReader reader, BlockPos pos, EntityType<?> type) {
            BlockState blockstate = reader.getBlockState(pos);
            return NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)reader, (BlockPos)pos, (BlockState)blockstate, (FluidState)blockstate.getFluidState(), type);
        }
    };
}

