/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.world.entity;

import com.fuyuaki.morethanadventure.core.registry.MtaItems;
import com.fuyuaki.morethanadventure.world.item.MTAEnchantmentProvider;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WitherJuggernaut
extends Monster
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> STUNNED = SynchedEntityData.defineId(WitherJuggernaut.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> STUN_TIME = SynchedEntityData.defineId(WitherJuggernaut.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final RawAnimation MOVE = RawAnimation.begin().thenLoop("animation.wither_juggernaut.walk");
    protected static final RawAnimation SWING = RawAnimation.begin().thenPlay("animation.wither_juggernaut.swing");
    protected static final RawAnimation STUN = RawAnimation.begin().then("animation.wither_juggernaut.enter_stun", Animation.LoopType.PLAY_ONCE).thenLoop("animation.wither_juggernaut.stun");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);
    private static final int stunTimeMax = 200;

    public WitherJuggernaut(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.xpReward = 200;
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
    }

    protected void populateDefaultEquipmentSlots(RandomSource pRandom, DifficultyInstance pDifficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)MtaItems.WRATHFUL_BERSERKERS_BATTLEAXE.get()));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pSpawnType, @Nullable SpawnGroupData pSpawnGroupData) {
        RandomSource randomsource = pLevel.getRandom();
        this.populateDefaultEquipmentSlots(randomsource, pDifficulty);
        this.populateDefaultEquipmentEnchantments(pLevel, randomsource, pDifficulty);
        return super.finalizeSpawn(pLevel, pDifficulty, pSpawnType, pSpawnGroupData);
    }

    public boolean isWithinMeleeAttackRange(LivingEntity pEntity) {
        return this.getAttackBoundingBox().inflate(1.5).intersects(pEntity.getHitbox());
    }

    protected void enchantSpawnedWeapon(ServerLevelAccessor pLevel, RandomSource pRandom, DifficultyInstance pDifficulty) {
        this.enchantSpawnedEquipment(pLevel, EquipmentSlot.MAINHAND, pRandom, 1.0f, pDifficulty);
    }

    private void enchantSpawnedEquipment(ServerLevelAccessor pLevel, EquipmentSlot pSlot, RandomSource pRandom, float pEnchantChance, DifficultyInstance pDifficulty) {
        ItemStack itemstack = this.getItemBySlot(pSlot);
        if (!itemstack.isEmpty() && pRandom.nextFloat() < pEnchantChance) {
            EnchantmentHelper.enchantItemFromProvider((ItemStack)itemstack, (RegistryAccess)pLevel.registryAccess(), MTAEnchantmentProvider.WITHER_JUGGERNAUT, (DifficultyInstance)pDifficulty, (RandomSource)pRandom);
            this.setItemSlot(pSlot, itemstack);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(STUNNED, (Object)false);
        pBuilder.define(STUN_TIME, (Object)0);
    }

    public boolean isStunned() {
        return (Boolean)this.entityData.get(STUNNED);
    }

    public void setStunned(boolean stunned) {
        this.entityData.set(STUNNED, (Object)stunned);
        this.setStunTime(0);
    }

    public int getStunTime() {
        return (Integer)this.entityData.get(STUN_TIME);
    }

    public void setStunTime(int stunTime) {
        this.entityData.set(STUN_TIME, (Object)stunTime);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (!this.isStunned()) {
            return false;
        }
        return super.hurt(pSource, pAmount);
    }

    public void onExplosionHit(@Nullable Entity pEntity) {
        this.setStunned(true);
        super.onExplosionHit(pEntity);
    }

    protected void customServerAiStep() {
        if (!this.level().isClientSide && this.isStunned()) {
            if (this.getStunTime() < 0) {
                this.setStunTime(0);
            }
            this.setStunTime(this.getStunTime() + 1);
            this.setNoActionTime(5);
            if (this.getStunTime() >= 200) {
                this.setStunned(false);
            }
        }
        super.customServerAiStep();
        this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new CustomMeleeAttackGoal(this, this, 1.0, true));
        this.goalSelector.addGoal(3, (Goal)new CustomRandomStrollGoal(this, this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new CustomRandomLookAroundGoal(this, this));
        this.goalSelector.addGoal(6, (Goal)new CustomLookAtPlayerGoal(this, this, Player.class, 16.0f));
        this.addTargetGoals();
    }

    protected void dropCustomDeathLoot(ServerLevel pLevel, DamageSource pDamageSource, boolean pRecentlyHit) {
        super.dropCustomDeathLoot(pLevel, pDamageSource, pRecentlyHit);
        ItemEntity itementity = this.spawnAtLocation((ItemLike)Items.WITHER_SKELETON_SKULL);
        if (itementity != null) {
            itementity.setExtendedLifetime();
        }
    }

    public boolean addEffect(MobEffectInstance pEffectInstance, @javax.annotation.Nullable Entity pEntity) {
        return false;
    }

    private void addTargetGoals() {
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Pillager.class, true));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Piglin.class, true));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, PiglinBrute.class, true));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Hoglin.class, true));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Zoglin.class, true));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Skeleton.class, true));
    }

    public void setCustomName(@javax.annotation.Nullable Component pName) {
        super.setCustomName(pName);
        this.bossEvent.setName(this.getDisplayName());
    }

    public void startSeenByPlayer(ServerPlayer pPlayer) {
        super.startSeenByPlayer(pPlayer);
        this.bossEvent.addPlayer(pPlayer);
    }

    public void stopSeenByPlayer(ServerPlayer pPlayer) {
        super.stopSeenByPlayer(pPlayer);
        this.bossEvent.removePlayer(pPlayer);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 200.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ARMOR, 20.0).add(Attributes.ARMOR_TOUGHNESS, 2.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.STEP_HEIGHT, 2.0).add(Attributes.SAFE_FALL_DISTANCE, 6.0).add(Attributes.ENTITY_INTERACTION_RANGE, 5.0).add(ALObjects.Attributes.LIFE_STEAL, (double)0.3f);
    }

    public void tick() {
        super.tick();
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.WITHER_SKELETON_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return SoundEvents.WITHER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WITHER_SKELETON_DEATH;
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    public boolean canAttackType(EntityType<?> pType) {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 0, state -> {
            if (((WitherJuggernaut)state.getAnimatable()).isStunned()) {
                return state.setAndContinue(STUN);
            }
            if (state.isMoving()) {
                return state.setAndContinue(MOVE);
            }
            return state.setAndContinue(DefaultAnimations.IDLE);
        }), new AnimationController((GeoAnimatable)this, "attack_controller", state -> PlayState.STOP).triggerableAnim("attack_animation", SWING).transitionLength(5).setAnimationSpeed(2.0)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public class CustomMeleeAttackGoal
    extends MeleeAttackGoal {
        protected final WitherJuggernaut mob;
        private int attackAnimSync = -1;

        public CustomMeleeAttackGoal(WitherJuggernaut this$0, WitherJuggernaut pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.mob = pMob;
        }

        public boolean canUse() {
            if (this.mob.isStunned()) {
                return false;
            }
            return super.canUse();
        }

        public void tick() {
            super.tick();
            LivingEntity livingentity = this.mob.getTarget();
            if (this.attackAnimSync > 0) {
                --this.attackAnimSync;
            }
            if (this.attackAnimSync == 0) {
                if (livingentity != null) {
                    this.mob.doHurtTarget((Entity)livingentity);
                }
                this.attackAnimSync = -1;
            }
        }

        protected void checkAndPerformAttack(LivingEntity pTarget) {
            if (super.canPerformAttack(pTarget)) {
                this.resetAttackCooldown();
                this.triggerAnimation();
                this.mob.swing(InteractionHand.MAIN_HAND);
                this.attackAnimSync = this.adjustedTickDelay(5);
            }
        }

        protected void triggerAnimation() {
            this.mob.triggerAnim("attack_controller", "attack_animation");
        }

        public boolean canContinueToUse() {
            if (this.mob.isStunned()) {
                return false;
            }
            return super.canContinueToUse();
        }
    }

    public class CustomRandomStrollGoal
    extends RandomStrollGoal {
        protected final WitherJuggernaut mob;

        public CustomRandomStrollGoal(WitherJuggernaut this$0, WitherJuggernaut pMob, double pSpeedModifier) {
            super((PathfinderMob)pMob, pSpeedModifier);
            this.mob = pMob;
        }

        public boolean canUse() {
            if (this.mob.isStunned()) {
                return false;
            }
            return super.canUse();
        }

        public void tick() {
            super.tick();
            if (this.mob.isStunned()) {
                this.stop();
            }
        }

        public boolean canContinueToUse() {
            if (this.mob.isStunned()) {
                return false;
            }
            return super.canContinueToUse();
        }
    }

    public class CustomRandomLookAroundGoal
    extends RandomLookAroundGoal {
        protected final WitherJuggernaut mob;

        public CustomRandomLookAroundGoal(WitherJuggernaut this$0, WitherJuggernaut pMob) {
            super((Mob)pMob);
            this.mob = pMob;
        }

        public boolean canUse() {
            if (this.mob.isStunned()) {
                return false;
            }
            return super.canUse();
        }

        public boolean canContinueToUse() {
            if (this.mob.isStunned()) {
                return false;
            }
            return super.canContinueToUse();
        }
    }

    public class CustomLookAtPlayerGoal
    extends LookAtPlayerGoal {
        protected final WitherJuggernaut mob;

        public CustomLookAtPlayerGoal(WitherJuggernaut this$0, WitherJuggernaut pMob, Class<? extends LivingEntity> pLookAtType, float pLookDistance) {
            super((Mob)pMob, pLookAtType, pLookDistance);
            this.mob = pMob;
        }

        public boolean canUse() {
            if (this.mob.isStunned()) {
                return false;
            }
            return super.canUse();
        }

        public boolean canContinueToUse() {
            if (this.mob.isStunned()) {
                return false;
            }
            return super.canContinueToUse();
        }
    }
}

