/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.world.entity;

import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class YukiOnna
extends Monster
implements GeoEntity,
FlyingAnimal {
    private static final EntityDataAccessor<Boolean> DATA_IS_BLOWING = SynchedEntityData.defineId(YukiOnna.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.yukionna.idle");
    protected static final RawAnimation CHASE = RawAnimation.begin().thenLoop("animation.yukionna.chase");
    protected static final RawAnimation BLOW = RawAnimation.begin().thenPlay("animation.yukionna.blow").thenLoop("animation.yukionna.idle");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public YukiOnna(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.xpReward = 5;
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
    }

    protected PathNavigation createNavigation(Level pLevel) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, pLevel);
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(true);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_IS_BLOWING, (Object)false);
    }

    public boolean isBlowing() {
        return (Boolean)this.entityData.get(DATA_IS_BLOWING);
    }

    public void setBlowing(boolean blowing) {
        this.entityData.set(DATA_IS_BLOWING, (Object)blowing);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FreezingBlowGoal(this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 16.0f));
        this.addTargetGoals();
    }

    private void addTargetGoals() {
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 18.0).add(Attributes.FOLLOW_RANGE, 12.0).add(ALObjects.Attributes.ARMOR_SHRED, 1.0).add(ALObjects.Attributes.COLD_DAMAGE, 2.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.FLYING_SPEED, (double)0.4f).add(Attributes.MOVEMENT_SPEED, (double)0.1f);
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    public boolean doHurtTarget(Entity pEntity) {
        pEntity.setTicksFrozen(pEntity.getTicksFrozen() + 100);
        return super.doHurtTarget(pEntity);
    }

    public void tick() {
        if (this.level().isRaining() && this.level().getBiome(this.blockPosition()).is(Tags.Biomes.IS_COLD)) {
            this.addEffect(new MobEffectInstance(ALObjects.MobEffects.REGENERATION));
        }
        super.tick();
    }

    public boolean isFreezing() {
        return false;
    }

    protected void checkFallDamage(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (pSource.is(DamageTypeTags.IS_FIRE)) {
            pAmount *= 2.0f;
        }
        return super.hurt(pSource, pAmount);
    }

    public void aiStep() {
        if (this.isAlive() && this.isSunBurnTick()) {
            this.igniteForSeconds(8.0f);
        }
        super.aiStep();
    }

    public boolean shouldRenderAtSqrDistance(double pDistance) {
        return true;
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.PHANTOM_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return SoundEvents.PHANTOM_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.PHANTOM_DEATH;
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    public boolean canAttackType(EntityType<?> pType) {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, 10, state -> {
            if (((YukiOnna)state.getAnimatable()).isBlowing()) {
                return state.setAndContinue(BLOW);
            }
            if (((YukiOnna)state.getAnimatable()).isAggressive()) {
                return state.setAndContinue(CHASE);
            }
            return state.setAndContinue(IDLE);
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static boolean canSpawn(EntityType<YukiOnna> pType, ServerLevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return YukiOnna.checkMonsterSpawnRules(pType, (ServerLevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom) && pLevel.canSeeSky(pPos.above().above()) && pLevel.getBiome(pPos).is(Tags.Biomes.IS_SNOWY);
    }

    private void createParticles(Level level, double pX, double pY, double pZ) {
        if (!level.isClientSide()) {
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SNOWFLAKE, pX, pY, pZ, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected class FreezingBlowGoal
    extends Goal {
        private YukiOnna mob;
        private long lastCanUseCheck;
        private static final long COOLDOWN = 460L;
        private int ticksUntilDamage;

        public FreezingBlowGoal(YukiOnna pMob) {
            this.mob = pMob;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            long i = this.mob.level().getGameTime();
            if (i - this.lastCanUseCheck < 460L) {
                return false;
            }
            this.lastCanUseCheck = i;
            LivingEntity livingentity = this.mob.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            return this.mob.distanceTo((Entity)livingentity) < 32.0f && this.mob.distanceTo((Entity)livingentity) > 4.0f;
        }

        public void start() {
            this.mob.setAggressive(true);
            this.ticksUntilDamage = 40;
            this.mob.setBlowing(true);
        }

        public void stop() {
            LivingEntity livingentity = this.mob.getTarget();
            if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingentity)) {
                this.mob.setTarget(null);
            }
            this.mob.setBlowing(false);
        }

        public void tick() {
            LivingEntity livingentity = this.mob.getTarget();
            if (livingentity != null) {
                --this.ticksUntilDamage;
                Level level = this.mob.level();
                this.mob.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
                if (this.ticksUntilDamage > 0) {
                    for (int a = 1; a <= 10; ++a) {
                        Vec3 distb = this.mob.getEyePosition().lerp(livingentity.getEyePosition(), (double)a / 10.0);
                        YukiOnna.this.createParticles(this.mob.level(), distb.x, distb.y, distb.z);
                    }
                } else {
                    livingentity.hurt(new DamageSource(this.mob.damageSources().freeze().typeHolder(), (Entity)this.mob), 6.0f);
                    level.playSound(null, livingentity.blockPosition(), SoundEvents.GLASS_BREAK, SoundSource.HOSTILE, 0.6f, 2.0f);
                    level.playSound(null, livingentity.blockPosition(), SoundEvents.PLAYER_HURT_FREEZE, SoundSource.HOSTILE);
                    livingentity.setTicksFrozen(500);
                    this.stop();
                }
            }
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = this.mob.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            if (this.ticksUntilDamage < -1) {
                return false;
            }
            return !this.mob.isWithinRestriction(livingentity.blockPosition()) ? false : !(livingentity instanceof Player) || !livingentity.isSpectator() && !((Player)livingentity).isCreative();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }
    }
}

