/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.world.event;

import com.fuyuaki.morethanadventure.core.registry.MtaBlocks;
import com.fuyuaki.morethanadventure.world.block.SandPathBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="morethanadventure", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class MTACommonEvents {
    @SubscribeEvent
    public static void onRightClickEvent(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        BlockState block = level.getBlockState(pos);
        if (event.getItemStack().canPerformAction(ItemAbilities.SHOVEL_FLATTEN) && !event.getHitVec().getDirection().equals((Object)Direction.DOWN)) {
            if (block.is(Blocks.SAND) && level.getBlockState(pos.above()).isAir()) {
                level.setBlockAndUpdate(pos, ((SandPathBlock)((Object)MtaBlocks.SAND_PATH.get())).defaultBlockState());
                event.getItemStack().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)event.getHand()));
                level.playSound(player, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)((SandPathBlock)((Object)MtaBlocks.SAND_PATH.get())).defaultBlockState()));
                player.swing(event.getHand());
            }
            if (block.is(Blocks.DIRT_PATH) && level.getBlockState(pos.above()).isAir()) {
                level.setBlockAndUpdate(pos, ((Block)MtaBlocks.COARSE_DIRT_PATH.get()).defaultBlockState());
                event.getItemStack().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)event.getHand()));
                level.playSound(player, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)((Block)MtaBlocks.COARSE_DIRT_PATH.get()).defaultBlockState()));
                player.swing(event.getHand());
            }
        }
    }
}

