/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.world.event;

import com.fuyuaki.morethanadventure.core.registry.MtaEntityTypes;
import com.fuyuaki.morethanadventure.game.capabilities.block.SprinkerWrapper;
import com.fuyuaki.morethanadventure.world.block.Sprinkler;
import com.fuyuaki.morethanadventure.world.entity.BeardedDragon;
import com.fuyuaki.morethanadventure.world.entity.Butterfly;
import com.fuyuaki.morethanadventure.world.entity.Capybara;
import com.fuyuaki.morethanadventure.world.entity.Duck;
import com.fuyuaki.morethanadventure.world.entity.FallenSamurai;
import com.fuyuaki.morethanadventure.world.entity.Ferret;
import com.fuyuaki.morethanadventure.world.entity.GreatWhiteShark;
import com.fuyuaki.morethanadventure.world.entity.HorseshoeCrab;
import com.fuyuaki.morethanadventure.world.entity.Jellyfish;
import com.fuyuaki.morethanadventure.world.entity.MTAPlacementTypes;
import com.fuyuaki.morethanadventure.world.entity.MTASpawnRules;
import com.fuyuaki.morethanadventure.world.entity.Octopus;
import com.fuyuaki.morethanadventure.world.entity.Owl;
import com.fuyuaki.morethanadventure.world.entity.Penguin;
import com.fuyuaki.morethanadventure.world.entity.Raccoon;
import com.fuyuaki.morethanadventure.world.entity.Shrimp;
import com.fuyuaki.morethanadventure.world.entity.Toucan;
import com.fuyuaki.morethanadventure.world.entity.WitherJuggernaut;
import com.fuyuaki.morethanadventure.world.entity.YukiOnna;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

@EventBusSubscriber(modid="morethanadventure", bus=EventBusSubscriber.Bus.MOD)
public class MTAModEvents {
    @SubscribeEvent
    public static void registerCapabilitiesEvent(RegisterCapabilitiesEvent event) {
        for (Block block : BuiltInRegistries.BLOCK) {
            if (block.getClass() != Sprinkler.class) continue;
            event.registerBlock(Capabilities.FluidHandler.BLOCK, (level, pos, blockState, blockEntity, context) -> new SprinkerWrapper(level, pos), new Block[]{block});
        }
    }

    @SubscribeEvent
    public static void entityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)MtaEntityTypes.YUKI_ONNA.get(), YukiOnna.createAttributes().build());
        event.put((EntityType)MtaEntityTypes.FALLEN_SAMURAI.get(), FallenSamurai.createAttributes().build());
        event.put((EntityType)MtaEntityTypes.WITHER_JUGGERNAUT.get(), WitherJuggernaut.createAttributes().build());
        event.put((EntityType)MtaEntityTypes.BUTTERFLY.get(), Butterfly.createAttributes().build());
        event.put((EntityType)MtaEntityTypes.BEARDED_DRAGON.get(), BeardedDragon.createAttributes().build());
        event.put((EntityType)MtaEntityTypes.CAPIBARA.get(), Capybara.createAttributes().build());
        event.put((EntityType)MtaEntityTypes.DUCK.get(), Duck.createAttributes().build());
        event.put((EntityType)MtaEntityTypes.FERRET.get(), Ferret.createAttributes().build());
        event.put((EntityType)MtaEntityTypes.GREAT_WHITE_SHARK.get(), GreatWhiteShark.createAttributes().build());
        event.put((EntityType)MtaEntityTypes.HORSESHOE_CRAB.get(), HorseshoeCrab.createAttributes().build());
        event.put((EntityType)MtaEntityTypes.JELLYFISH.get(), Jellyfish.createAttributes().build());
        event.put((EntityType)MtaEntityTypes.OCTOPUS.get(), Octopus.createAttributes().build());
        event.put((EntityType)MtaEntityTypes.OWL.get(), Owl.createAttributes().build());
        event.put((EntityType)MtaEntityTypes.PENGUIN.get(), Penguin.createAttributes().build());
        event.put((EntityType)MtaEntityTypes.RACCOON.get(), Raccoon.createAttributes().build());
        event.put((EntityType)MtaEntityTypes.SHRIMP.get(), Shrimp.createAttributes().build());
        event.put((EntityType)MtaEntityTypes.TOUCAN.get(), Toucan.createAttributes().build());
    }

    @SubscribeEvent
    public static void spawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)MtaEntityTypes.YUKI_ONNA.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, YukiOnna::canSpawn, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)MtaEntityTypes.FALLEN_SAMURAI.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)MtaEntityTypes.BUTTERFLY.get(), MTAPlacementTypes.GROUND_OR_AIR, Heightmap.Types.MOTION_BLOCKING, MTASpawnRules::checkBirdSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)MtaEntityTypes.BEARDED_DRAGON.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MTASpawnRules::checkDesertAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)MtaEntityTypes.CAPIBARA.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MTASpawnRules::checkLandSwimmerSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)MtaEntityTypes.DUCK.get(), MTAPlacementTypes.GROUND_OR_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MTASpawnRules::checkLandSwimmerSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)MtaEntityTypes.FERRET.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)MtaEntityTypes.GREAT_WHITE_SHARK.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MTASpawnRules::checkSeaAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)MtaEntityTypes.HORSESHOE_CRAB.get(), MTAPlacementTypes.GROUND_OR_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MTASpawnRules::checkLandSwimmerSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)MtaEntityTypes.JELLYFISH.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MTASpawnRules::checkSeaAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)MtaEntityTypes.OCTOPUS.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.OCEAN_FLOOR, MTASpawnRules::checkWaterAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)MtaEntityTypes.OWL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, MTASpawnRules::checkBirdSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)MtaEntityTypes.PENGUIN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MTASpawnRules::checkSnowAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)MtaEntityTypes.RACCOON.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)MtaEntityTypes.SHRIMP.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MTASpawnRules::checkSeaAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)MtaEntityTypes.TOUCAN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, MTASpawnRules::checkBirdSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register(EntityType.CAMEL, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MTASpawnRules::checkDesertAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
    }

    @SubscribeEvent
    private static void registerScreens(RegisterMenuScreensEvent event) {
    }
}

