/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.world.item;

import com.fuyuaki.morethanadventure.world.entity.Arrows.MTAArrowEntity;
import com.google.common.base.Suppliers;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;

public class AngelBowItem
extends BowItem {
    public static final int MAX_DRAW_DURATION = 20;
    public static final int DEFAULT_RANGE = 60;
    private final Supplier<ItemAttributeModifiers> attributeModifiers = Suppliers.memoize(() -> {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        ResourceLocation location = ResourceLocation.withDefaultNamespace((String)"angel_bow");
        return this.createAttributeModifiers(builder).build();
    });

    public AngelBowItem(Item.Properties pProperties) {
        super(pProperties.stacksTo(1).fireResistant().rarity(Rarity.EPIC));
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.BOW;
    }

    protected ItemAttributeModifiers.Builder createAttributeModifiers(ItemAttributeModifiers.Builder builder) {
        ResourceLocation location = ResourceLocation.withDefaultNamespace((String)"angel_bow");
        builder.add(ALObjects.Attributes.DRAW_SPEED, new AttributeModifier(location, 0.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        return builder;
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.attributeModifiers.get();
    }

    public void releaseUsing(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
        if (pEntityLiving instanceof Player) {
            Player player = (Player)pEntityLiving;
            int i = this.getUseDuration(pStack, pEntityLiving) - pTimeLeft;
            if ((i = EventHooks.onArrowLoose((ItemStack)pStack, (Level)pLevel, (Player)player, (int)i, (boolean)true)) < 0) {
                return;
            }
            float f = AngelBowItem.getPowerForTime((int)i);
            if (!((double)f < 0.1)) {
                List list = AngelBowItem.draw((ItemStack)pStack, (ItemStack)Items.ARROW.getDefaultInstance(), (LivingEntity)player);
                if (pLevel instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)pLevel;
                    this.shoot(serverlevel, (LivingEntity)player, player.getUsedItemHand(), pStack, list, f * 4.0f, 0.0f, f >= 0.8f, null);
                }
                pLevel.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (pLevel.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    public int getDefaultProjectileRange() {
        return 60;
    }

    protected Projectile createProjectile(Level pLevel, LivingEntity pShooter, ItemStack pWeapon, ItemStack pAmmo, boolean pIsCrit) {
        MTAArrowEntity abstractarrow = new MTAArrowEntity(pShooter, pLevel, 10.0f, 0.7f, pWeapon);
        if (pIsCrit) {
            abstractarrow.setCritArrow(true);
        }
        return this.customArrow(abstractarrow, pAmmo, pWeapon);
    }

    public int getEnchantmentValue() {
        return 19;
    }

    protected void shootProjectile(LivingEntity pShooter, Projectile pProjectile, int pIndex, float pVelocity, float pInaccuracy, float pAngle, @Nullable LivingEntity pTarget) {
        pProjectile.shootFromRotation((Entity)pShooter, pShooter.getXRot(), pShooter.getYRot() + pAngle, 0.0f, pVelocity, pInaccuracy);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        InteractionResultHolder ret = EventHooks.onArrowNock((ItemStack)itemstack, (Level)pLevel, (Player)pPlayer, (InteractionHand)pHand, (boolean)true);
        if (ret != null) {
            return ret;
        }
        pPlayer.startUsingItem(pHand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ARROW_ONLY;
    }
}

