/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.world.item;

import com.fuyuaki.morethanadventure.core.registry.MtaArmorMats;
import com.google.common.base.Suppliers;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.NeoForgeMod;

public class MTAArmor
extends ArmorItem {
    protected final UUID FULL_SET_UUID = UUID.fromString("78f6b05d-a0ff-4b5e-86dc-9b397d5b7878");
    private static final ArmorMaterial SENTINEL = (ArmorMaterial)MtaArmorMats.GREAT_SENTINEL.value();
    private static final ArmorMaterial KNIGHT = (ArmorMaterial)MtaArmorMats.HOLY_KNIGHT.value();
    private static final ArmorMaterial MERMAID = (ArmorMaterial)MtaArmorMats.MYSTIC_MERMAID.value();
    private static final ArmorMaterial ANGEL = (ArmorMaterial)MtaArmorMats.TEMPLE_ANGEL.value();
    private static final ArmorMaterial BERSERKER = (ArmorMaterial)MtaArmorMats.WRATHFUL_BERSERKER.value();
    private static final ArmorMaterial ROGUE = (ArmorMaterial)MtaArmorMats.SHADOW_ROGUE.value();
    private final Supplier<ItemAttributeModifiers> attributeModifiers = Suppliers.memoize(() -> {
        int i = ((ArmorMaterial)pMaterial.value()).getDefense(pType);
        float f = ((ArmorMaterial)pMaterial.value()).toughness();
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        EquipmentSlotGroup equipmentslotgroup = EquipmentSlotGroup.bySlot((EquipmentSlot)pType.getSlot());
        ResourceLocation resourcelocation = ResourceLocation.withDefaultNamespace((String)("armor." + pType.getName()));
        builder.add(Attributes.ARMOR, new AttributeModifier(resourcelocation, (double)i, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(resourcelocation, (double)f, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        float f1 = ((ArmorMaterial)pMaterial.value()).knockbackResistance();
        if (f1 > 0.0f) {
            builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(resourcelocation, (double)f1, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        }
        return this.resolveAttributeModifiers(pMaterial, pType, builder).build();
    });

    public MTAArmor(Holder<ArmorMaterial> pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties.stacksTo(1).fireResistant().rarity(Rarity.EPIC));
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.attributeModifiers.get();
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)pEntity;
            if (!pLevel.isClientSide()) {
                this.estimateEffects(living, pLevel, pSlotId);
            }
        }
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    protected void estimateEffects(LivingEntity entity, Level level, int pSlotId) {
        boolean hasHelmet = entity.getItemBySlot(ArmorItem.Type.HELMET.getSlot()).getItem() instanceof ArmorItem;
        boolean hasChestplate = entity.getItemBySlot(ArmorItem.Type.CHESTPLATE.getSlot()).getItem() instanceof ArmorItem;
        boolean hasLeggings = entity.getItemBySlot(ArmorItem.Type.LEGGINGS.getSlot()).getItem() instanceof ArmorItem;
        boolean hasBoots = entity.getItemBySlot(ArmorItem.Type.BOOTS.getSlot()).getItem() instanceof ArmorItem;
        ArmorMaterial helmet = (ArmorMaterial)ArmorMaterials.ARMADILLO.value();
        ArmorMaterial chestplate = (ArmorMaterial)ArmorMaterials.ARMADILLO.value();
        ArmorMaterial leggings = (ArmorMaterial)ArmorMaterials.ARMADILLO.value();
        ArmorMaterial boots = (ArmorMaterial)ArmorMaterials.ARMADILLO.value();
        if (hasHelmet) {
            helmet = (ArmorMaterial)((ArmorItem)entity.getItemBySlot(ArmorItem.Type.HELMET.getSlot()).getItem()).getMaterial().value();
        }
        if (hasChestplate) {
            chestplate = (ArmorMaterial)((ArmorItem)entity.getItemBySlot(ArmorItem.Type.CHESTPLATE.getSlot()).getItem()).getMaterial().value();
        }
        if (hasLeggings) {
            leggings = (ArmorMaterial)((ArmorItem)entity.getItemBySlot(ArmorItem.Type.LEGGINGS.getSlot()).getItem()).getMaterial().value();
        }
        if (hasBoots) {
            boots = (ArmorMaterial)((ArmorItem)entity.getItemBySlot(ArmorItem.Type.BOOTS.getSlot()).getItem()).getMaterial().value();
        }
        this.doSentinelEffects(entity, level, pSlotId, hasHelmet && helmet == SENTINEL, hasChestplate && chestplate == SENTINEL, hasLeggings && leggings == SENTINEL, hasBoots && boots == SENTINEL);
        this.doKnightEffects(entity, level, pSlotId, hasHelmet && helmet == KNIGHT, hasChestplate && chestplate == KNIGHT, hasLeggings && leggings == KNIGHT, hasBoots && boots == KNIGHT);
        this.doMermaidEffects(entity, level, pSlotId, hasHelmet && helmet == MERMAID, hasChestplate && chestplate == MERMAID, hasLeggings && leggings == MERMAID, hasBoots && boots == MERMAID);
        this.doAngelEffects(entity, level, pSlotId, hasHelmet && helmet == ANGEL, hasChestplate && chestplate == ANGEL, hasLeggings && leggings == ANGEL, hasBoots && boots == ANGEL);
        this.doBerserkerEffects(entity, level, pSlotId, hasHelmet && helmet == BERSERKER, hasChestplate && chestplate == BERSERKER, hasLeggings && leggings == BERSERKER, hasBoots && boots == BERSERKER);
        this.doRogueEffects(entity, level, pSlotId, hasHelmet && helmet == ROGUE, hasChestplate && chestplate == ROGUE, hasLeggings && leggings == ROGUE, hasBoots && boots == ROGUE);
    }

    protected void doSentinelEffects(LivingEntity entity, Level level, int pSlotId, boolean head, boolean chest, boolean legs, boolean feet) {
        if (head) {
            // empty if block
        }
        if (chest) {
            // empty if block
        }
        if (legs) {
            // empty if block
        }
        if (feet) {
            // empty if block
        }
        if (head || chest || legs || feet) {
            entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 3, 0, false, false, false));
        }
        if (head && chest && legs && feet) {
            entity.addEffect(new MobEffectInstance(MobEffects.HEALTH_BOOST, 3, 4, false, false, false));
            entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 3, 2, false, false, false));
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 3, 0, false, false, false));
        }
    }

    protected void doKnightEffects(LivingEntity entity, Level level, int pSlotId, boolean head, boolean chest, boolean legs, boolean feet) {
        if (head) {
            // empty if block
        }
        if (chest) {
            // empty if block
        }
        if (legs) {
            // empty if block
        }
        if (feet) {
            // empty if block
        }
        if (head || chest || legs || feet) {
            entity.addEffect(new MobEffectInstance(MobEffects.LUCK, 3, 1, false, false, false));
        }
        if (head && chest && legs && feet) {
            entity.addEffect(new MobEffectInstance(MobEffects.HERO_OF_THE_VILLAGE, 3, 0, false, false, false));
        }
    }

    protected void doMermaidEffects(LivingEntity entity, Level level, int pSlotId, boolean head, boolean chest, boolean legs, boolean feet) {
        if (head) {
            // empty if block
        }
        if (chest) {
            // empty if block
        }
        if (legs) {
            // empty if block
        }
        if (feet) {
            // empty if block
        }
        if (head || chest || legs || feet) {
            // empty if block
        }
        if (head && chest && legs && feet) {
            entity.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 3, 0, false, false, false));
            entity.addEffect(new MobEffectInstance(MobEffects.CONDUIT_POWER, 3, 0, false, false, false));
        }
    }

    protected void doAngelEffects(LivingEntity entity, Level level, int pSlotId, boolean head, boolean chest, boolean legs, boolean feet) {
        if (head) {
            // empty if block
        }
        if (chest) {
            // empty if block
        }
        if (legs) {
            entity.addEffect(new MobEffectInstance(MobEffects.JUMP, 3, 3, false, false, false));
        }
        if (feet) {
            // empty if block
        }
        if (head || chest || legs || feet) {
            // empty if block
        }
        if (head && chest && legs && feet) {
            entity.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 3, 0, false, false, false));
            entity.addEffect(new MobEffectInstance(MobEffects.JUMP, 3, 5, false, false, false));
        }
    }

    protected void doBerserkerEffects(LivingEntity entity, Level level, int pSlotId, boolean head, boolean chest, boolean legs, boolean feet) {
        if (head) {
            // empty if block
        }
        if (chest) {
            // empty if block
        }
        if (legs) {
            // empty if block
        }
        if (feet) {
            // empty if block
        }
        if (head || chest || legs || feet) {
            entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 3, 0, false, false, false));
        }
        if (head && chest && legs && feet) {
            entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 3, 2, false, false, false));
        }
    }

    protected void doRogueEffects(LivingEntity entity, Level level, int pSlotId, boolean head, boolean chest, boolean legs, boolean feet) {
        if (head) {
            // empty if block
        }
        if (chest) {
            // empty if block
        }
        if (legs) {
            // empty if block
        }
        if (feet) {
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 3, 1, false, false, false));
        }
        if (head || chest || legs || feet) {
            // empty if block
        }
        if (head && chest && legs && feet) {
            if (entity.isCrouching()) {
                entity.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 3, 0, false, false, false));
            }
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 3, 2, false, false, false));
        }
    }

    protected ItemAttributeModifiers.Builder resolveAttributeModifiers(Holder<ArmorMaterial> material, ArmorItem.Type type, ItemAttributeModifiers.Builder builder) {
        if (material.value() == SENTINEL) {
            return this.sentinelAttributes(type, builder);
        }
        if (material.value() == KNIGHT) {
            return this.knightAttributes(type, builder);
        }
        if (material.value() == MERMAID) {
            return this.mermaidAttributes(type, builder);
        }
        if (material.value() == ANGEL) {
            return this.angelAttributes(type, builder);
        }
        if (material.value() == BERSERKER) {
            return this.berserkerAttributes(type, builder);
        }
        if (material.value() == ROGUE) {
            return this.rogueAttributes(type, builder);
        }
        return builder;
    }

    protected ItemAttributeModifiers.Builder sentinelAttributes(ArmorItem.Type type, ItemAttributeModifiers.Builder builder) {
        EquipmentSlotGroup slot = EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot());
        ResourceLocation location = ResourceLocation.withDefaultNamespace((String)("armor." + type.getName()));
        if (type == ArmorItem.Type.HELMET) {
            builder.add(ALObjects.Attributes.DODGE_CHANCE, new AttributeModifier(location, (double)0.02f, AttributeModifier.Operation.ADD_VALUE), slot);
            builder.add(ALObjects.Attributes.GHOST_HEALTH, new AttributeModifier(location, 1.0, AttributeModifier.Operation.ADD_VALUE), slot);
        } else if (type == ArmorItem.Type.CHESTPLATE) {
            builder.add(ALObjects.Attributes.DODGE_CHANCE, new AttributeModifier(location, (double)0.1f, AttributeModifier.Operation.ADD_VALUE), slot);
            builder.add(ALObjects.Attributes.GHOST_HEALTH, new AttributeModifier(location, 4.0, AttributeModifier.Operation.ADD_VALUE), slot);
        } else if (type == ArmorItem.Type.LEGGINGS) {
            builder.add(ALObjects.Attributes.DODGE_CHANCE, new AttributeModifier(location, (double)0.05f, AttributeModifier.Operation.ADD_VALUE), slot);
            builder.add(ALObjects.Attributes.GHOST_HEALTH, new AttributeModifier(location, 2.0, AttributeModifier.Operation.ADD_VALUE), slot);
        } else if (type == ArmorItem.Type.BOOTS) {
            builder.add(ALObjects.Attributes.DODGE_CHANCE, new AttributeModifier(location, (double)0.02f, AttributeModifier.Operation.ADD_VALUE), slot);
            builder.add(ALObjects.Attributes.GHOST_HEALTH, new AttributeModifier(location, 1.0, AttributeModifier.Operation.ADD_VALUE), slot);
        }
        builder.add(Attributes.MOVEMENT_SPEED, new AttributeModifier(location, (double)-0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), slot);
        return builder;
    }

    protected ItemAttributeModifiers.Builder knightAttributes(ArmorItem.Type type, ItemAttributeModifiers.Builder builder) {
        EquipmentSlotGroup slot = EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot());
        ResourceLocation location = ResourceLocation.withDefaultNamespace((String)("armor." + type.getName()));
        if (type == ArmorItem.Type.HELMET) {
            builder.add(ALObjects.Attributes.CRIT_CHANCE, new AttributeModifier(location, (double)0.2f, AttributeModifier.Operation.ADD_VALUE), slot);
        } else if (type == ArmorItem.Type.CHESTPLATE) {
            builder.add(ALObjects.Attributes.OVERHEAL, new AttributeModifier(location, (double)0.4f, AttributeModifier.Operation.ADD_VALUE), slot);
        } else if (type == ArmorItem.Type.LEGGINGS) {
            builder.add(ALObjects.Attributes.CURRENT_HP_DAMAGE, new AttributeModifier(location, (double)0.2f, AttributeModifier.Operation.ADD_VALUE), slot);
        } else if (type == ArmorItem.Type.BOOTS) {
            builder.add(Attributes.STEP_HEIGHT, new AttributeModifier(location, 0.5, AttributeModifier.Operation.ADD_VALUE), slot);
        }
        return builder;
    }

    protected ItemAttributeModifiers.Builder mermaidAttributes(ArmorItem.Type type, ItemAttributeModifiers.Builder builder) {
        EquipmentSlotGroup slot = EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot());
        ResourceLocation location = ResourceLocation.withDefaultNamespace((String)("armor." + type.getName()));
        if (type == ArmorItem.Type.HELMET) {
            builder.add(Attributes.OXYGEN_BONUS, new AttributeModifier(location, 4.0, AttributeModifier.Operation.ADD_VALUE), slot);
        } else if (type == ArmorItem.Type.CHESTPLATE) {
            builder.add(Attributes.SUBMERGED_MINING_SPEED, new AttributeModifier(location, 3.0, AttributeModifier.Operation.ADD_VALUE), slot);
        } else if (type == ArmorItem.Type.LEGGINGS) {
            builder.add(NeoForgeMod.SWIM_SPEED, new AttributeModifier(location, (double)0.4f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), slot);
        } else if (type == ArmorItem.Type.BOOTS) {
            builder.add(Attributes.WATER_MOVEMENT_EFFICIENCY, new AttributeModifier(location, (double)0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), slot);
        }
        return builder;
    }

    protected ItemAttributeModifiers.Builder angelAttributes(ArmorItem.Type type, ItemAttributeModifiers.Builder builder) {
        EquipmentSlotGroup slot = EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot());
        ResourceLocation location = ResourceLocation.withDefaultNamespace((String)("armor." + type.getName()));
        if (type != ArmorItem.Type.HELMET) {
            if (type == ArmorItem.Type.CHESTPLATE) {
                builder.add(Attributes.GRAVITY, new AttributeModifier(location, (double)-0.4f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), slot);
            } else if (type != ArmorItem.Type.LEGGINGS && type == ArmorItem.Type.BOOTS) {
                builder.add(Attributes.FALL_DAMAGE_MULTIPLIER, new AttributeModifier(location, (double)-0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), slot);
                builder.add(Attributes.SAFE_FALL_DISTANCE, new AttributeModifier(location, 4.0, AttributeModifier.Operation.ADD_VALUE), slot);
            }
        }
        return builder;
    }

    protected ItemAttributeModifiers.Builder berserkerAttributes(ArmorItem.Type type, ItemAttributeModifiers.Builder builder) {
        EquipmentSlotGroup slot = EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot());
        ResourceLocation location = ResourceLocation.withDefaultNamespace((String)("armor." + type.getName()));
        if (type == ArmorItem.Type.HELMET) {
            builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(location, (double)2.4f, AttributeModifier.Operation.ADD_VALUE), slot);
            builder.add(Attributes.ATTACK_KNOCKBACK, new AttributeModifier(location, (double)0.4f, AttributeModifier.Operation.ADD_VALUE), slot);
        } else if (type == ArmorItem.Type.CHESTPLATE) {
            builder.add(ALObjects.Attributes.LIFE_STEAL, new AttributeModifier(location, (double)0.1f, AttributeModifier.Operation.ADD_VALUE), slot);
            builder.add(ALObjects.Attributes.GHOST_HEALTH, new AttributeModifier(location, 4.0, AttributeModifier.Operation.ADD_VALUE), slot);
        } else if (type == ArmorItem.Type.LEGGINGS) {
            builder.add(ALObjects.Attributes.ARMOR_SHRED, new AttributeModifier(location, (double)0.2f, AttributeModifier.Operation.ADD_VALUE), slot);
            builder.add(Attributes.FALL_DAMAGE_MULTIPLIER, new AttributeModifier(location, (double)0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), slot);
        } else if (type == ArmorItem.Type.BOOTS) {
            builder.add(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE, new AttributeModifier(location, (double)0.1f, AttributeModifier.Operation.ADD_VALUE), slot);
            builder.add(Attributes.SWEEPING_DAMAGE_RATIO, new AttributeModifier(location, (double)0.7f, AttributeModifier.Operation.ADD_VALUE), slot);
            builder.add(Attributes.MOVEMENT_EFFICIENCY, new AttributeModifier(location, (double)0.3f, AttributeModifier.Operation.ADD_VALUE), slot);
            builder.add(Attributes.FALL_DAMAGE_MULTIPLIER, new AttributeModifier(location, (double)0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), slot);
        }
        return builder;
    }

    protected ItemAttributeModifiers.Builder rogueAttributes(ArmorItem.Type type, ItemAttributeModifiers.Builder builder) {
        EquipmentSlotGroup slot = EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot());
        ResourceLocation location = ResourceLocation.withDefaultNamespace((String)("armor." + type.getName()));
        if (type == ArmorItem.Type.HELMET) {
            builder.add(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(location, (double)0.35f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), slot);
        } else if (type == ArmorItem.Type.CHESTPLATE) {
            builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(location, (double)0.2f, AttributeModifier.Operation.ADD_VALUE), slot);
        } else if (type == ArmorItem.Type.LEGGINGS) {
            builder.add(Attributes.JUMP_STRENGTH, new AttributeModifier(location, (double)0.6f, AttributeModifier.Operation.ADD_VALUE), slot);
            builder.add(Attributes.FALL_DAMAGE_MULTIPLIER, new AttributeModifier(location, -0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), slot);
        } else if (type == ArmorItem.Type.BOOTS) {
            builder.add(Attributes.SAFE_FALL_DISTANCE, new AttributeModifier(location, 6.0, AttributeModifier.Operation.ADD_VALUE), slot);
            builder.add(Attributes.GRAVITY, new AttributeModifier(location, (double)-0.4f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), slot);
            builder.add(Attributes.SNEAKING_SPEED, new AttributeModifier(location, (double)0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), slot);
        }
        return builder;
    }
}

