/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.world.item;

import com.fuyuaki.morethanadventure.world.entity.ThrownNetheriteTrident;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class NetheriteTridentItem
extends TridentItem {
    public NetheriteTridentItem(Item.Properties pProperties) {
        super(pProperties.stacksTo(1).fireResistant().rarity(Rarity.EPIC));
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 9.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)-2.9f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public int getEnchantmentValue() {
        return 15;
    }

    public void releaseUsing(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
        if (pEntityLiving instanceof Player) {
            float f;
            Player player = (Player)pEntityLiving;
            int i = this.getUseDuration(pStack, pEntityLiving) - pTimeLeft;
            if (!(i < 10 || (f = EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)pStack, (LivingEntity)player)) > 0.0f && !player.isInWaterOrRain() || NetheriteTridentItem.isTooDamagedToUse(pStack))) {
                Holder holder = EnchantmentHelper.pickHighestLevel((ItemStack)pStack, (DataComponentType)EnchantmentEffectComponents.TRIDENT_SOUND).orElse(SoundEvents.TRIDENT_THROW);
                if (!pLevel.isClientSide) {
                    pStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)pEntityLiving.getUsedItemHand()));
                    if (f == 0.0f) {
                        ThrownNetheriteTrident throwntrident = new ThrownNetheriteTrident(pLevel, (LivingEntity)player, pStack);
                        throwntrident.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.7f, 0.4f);
                        if (player.hasInfiniteMaterials()) {
                            throwntrident.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        pLevel.addFreshEntity((Entity)throwntrident);
                        pLevel.playSound(null, (Entity)throwntrident, (SoundEvent)holder.value(), SoundSource.PLAYERS, 1.0f, 0.2f);
                        if (!player.hasInfiniteMaterials()) {
                            player.getInventory().removeItem(pStack);
                        }
                    }
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                if (f > 0.0f) {
                    float f7 = player.getYRot();
                    float f1 = player.getXRot();
                    float f2 = -Mth.sin((float)(f7 * ((float)Math.PI / 180))) * Mth.cos((float)(f1 * ((float)Math.PI / 180)));
                    float f3 = -Mth.sin((float)(f1 * ((float)Math.PI / 180)));
                    float f4 = Mth.cos((float)(f7 * ((float)Math.PI / 180))) * Mth.cos((float)(f1 * ((float)Math.PI / 180)));
                    float f5 = Mth.sqrt((float)(f2 * f2 + f3 * f3 + f4 * f4));
                    player.push((double)(f2 *= f / f5), (double)(f3 *= f / f5), (double)(f4 *= f / f5));
                    player.startAutoSpinAttack(20, 9.0f, pStack);
                    if (player.onGround()) {
                        float f6 = 1.1999999f;
                        player.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                    }
                    pLevel.playSound(null, (Entity)player, (SoundEvent)holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    public Projectile asProjectile(Level pLevel, Position pPos, ItemStack pStack, Direction pDirection) {
        ThrownNetheriteTrident throwntrident = new ThrownNetheriteTrident(pLevel, pPos.x(), pPos.y(), pPos.z(), pStack.copyWithCount(1));
        throwntrident.pickup = AbstractArrow.Pickup.ALLOWED;
        return throwntrident;
    }

    private static boolean isTooDamagedToUse(ItemStack pStack) {
        return pStack.getDamageValue() >= pStack.getMaxDamage() - 1;
    }
}

