/*
 * Decompiled with CFR 0.152.
 */
package com.fuyuaki.morethanadventure.world.item;

import com.google.common.base.Suppliers;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class RogueDaggerItem
extends SwordItem {
    private final Supplier<ItemAttributeModifiers> attributeModifiers = Suppliers.memoize(() -> {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        ResourceLocation location = ResourceLocation.withDefaultNamespace((String)"dagger");
        return this.createAttributeModifiers(pTier, builder).build();
    });

    public RogueDaggerItem(Tier pTier, Item.Properties pProperties) {
        super(pTier, pProperties.stacksTo(1).fireResistant().rarity(Rarity.EPIC));
    }

    protected ItemAttributeModifiers.Builder createAttributeModifiers(Tier pTier, ItemAttributeModifiers.Builder builder) {
        ResourceLocation location = ResourceLocation.withDefaultNamespace((String)"dagger");
        builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(location, (double)(3.0f + pTier.getAttackDamageBonus()), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(location, (double)-0.9f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        builder.add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(location, -0.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        builder.add(ALObjects.Attributes.ARMOR_PIERCE, new AttributeModifier(location, 3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        builder.add(ALObjects.Attributes.CRIT_CHANCE, new AttributeModifier(location, (double)0.1f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        builder.add(ALObjects.Attributes.CRIT_DAMAGE, new AttributeModifier(location, 2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        return builder;
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.attributeModifiers.get();
    }

    public int getEnchantmentValue() {
        return 25;
    }
}

