/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.provihealth.config;

import com.google.gson.stream.JsonReader;
import com.mojang.blaze3d.systems.RenderSystem;
import com.provismet.provihealth.ProviHealthClient;
import com.provismet.provihealth.config.JsonHelper;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalEntityTypeTags;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.joml.Vector3f;

public class Options {
    public static final Vector3f WHITE = class_243.method_24457((int)0xFFFFFF).method_46409();
    public static int maxHealthBarTicks = 40;
    public static List<String> blacklist = Arrays.asList("minecraft:armor_stand");
    public static List<String> blacklistHUD = Arrays.asList("minecraft:armor_stand");
    public static VisibilityType bosses = VisibilityType.ALWAYS_HIDE;
    public static VisibilityType hostile = VisibilityType.ALWAYS_SHOW;
    public static VisibilityType players = VisibilityType.HIDE_IF_FULL;
    public static VisibilityType others = VisibilityType.HIDE_IF_FULL;
    public static boolean bossesVisibilityOverride = false;
    public static boolean hostileVisibilityOverride = true;
    public static boolean playersVisibilityOverride = true;
    public static boolean othersVisibilityOverride = true;
    public static HUDType bossHUD = HUDType.FULL;
    public static HUDType hostileHUD = HUDType.FULL;
    public static HUDType playerHUD = HUDType.FULL;
    public static HUDType otherHUD = HUDType.FULL;
    public static float hudGlide = 0.5f;
    public static float worldGlide = 0.5f;
    public static boolean showHudIcon = true;
    public static boolean useCustomHudPortraits = true;
    public static int hudOffsetPercent = 0;
    public static HUDPosition hudPosition = HUDPosition.LEFT;
    public static int hudStartColour = 49408;
    public static int hudEndColour = 0xFF0000;
    public static Vector3f unpackedStartHud = class_243.method_24457((int)hudStartColour).method_46409();
    public static Vector3f unpackedEndHud = class_243.method_24457((int)hudEndColour).method_46409();
    public static boolean hudGradient = false;
    public static boolean hudTitles = true;
    public static boolean showTextInWorld = true;
    public static float maxRenderDistance = 24.0f;
    public static float worldHealthBarScale = 1.5f;
    public static int worldStartColour = 49408;
    public static int worldEndColour = 0xFF0000;
    public static Vector3f unpackedStartWorld = class_243.method_24457((int)worldStartColour).method_46409();
    public static Vector3f unpackedEndWorld = class_243.method_24457((int)worldEndColour).method_46409();
    public static boolean worldGradient = false;
    public static boolean overrideLabels = false;
    public static boolean worldShadows = true;
    public static float worldOffsetY = 0.0f;
    public static boolean worldTitles = true;
    public static boolean spawnDamageParticles = true;
    public static boolean spawnHealingParticles = false;
    public static int damageColour = 0xFF0000;
    public static int healingColour = 65280;
    public static Vector3f unpackedDamage = class_243.method_24457((int)damageColour).method_46409();
    public static Vector3f unpackedHealing = class_243.method_24457((int)healingColour).method_46409();
    public static float particleScale = 0.25f;
    public static boolean particleTextShadow = true;
    public static int damageParticleTextColour = 0xFFFFFF;
    public static int healingParticleTextColour = 0xFFFFFF;
    public static DamageParticleType particleType = DamageParticleType.RISING;
    public static float maxParticleDistance = 16.0f;
    public static float damageAlpha = 1.0f;
    public static float healingAlpha = 1.0f;
    public static SeeThroughText seeThroughTextType = SeeThroughText.STANDARD;
    public static boolean compatInWorld = false;
    public static boolean compatInHUD = false;
    public static HUDPortraitCompatMode HUDCompat = HUDPortraitCompatMode.STANDARD;

    public static boolean shouldRenderHealthFor(class_1309 livingEntity) {
        if (blacklist.contains(class_1299.method_5890((class_1299)livingEntity.method_5864()).toString())) {
            return false;
        }
        if (livingEntity.method_5739((class_1297)class_310.method_1551().field_1724) > Math.min(maxRenderDistance, RenderSystem.getShaderFogEnd())) {
            return false;
        }
        class_1297 target = class_310.method_1551().field_1692;
        if (livingEntity.method_5864().method_20210(ConventionalEntityTypeTags.BOSSES)) {
            if (bossesVisibilityOverride && livingEntity == target) {
                return true;
            }
            return Options.shouldRenderHealthFor(bosses, livingEntity);
        }
        if (livingEntity instanceof class_1588) {
            if (hostileVisibilityOverride && livingEntity == target) {
                return true;
            }
            return Options.shouldRenderHealthFor(hostile, livingEntity);
        }
        if (livingEntity instanceof class_1657) {
            if (playersVisibilityOverride && livingEntity == target) {
                return true;
            }
            return Options.shouldRenderHealthFor(players, livingEntity);
        }
        if (othersVisibilityOverride && livingEntity == target) {
            return true;
        }
        return Options.shouldRenderHealthFor(others, livingEntity);
    }

    public static HUDType getHUDFor(class_1309 livingEntity) {
        if (blacklistHUD.contains(class_1299.method_5890((class_1299)livingEntity.method_5864()).toString())) {
            return HUDType.NONE;
        }
        if (livingEntity.method_5864().method_20210(ConventionalEntityTypeTags.BOSSES)) {
            return bossHUD;
        }
        if (livingEntity instanceof class_1588) {
            return hostileHUD;
        }
        if (livingEntity instanceof class_1657) {
            return playerHUD;
        }
        return otherHUD;
    }

    public static Vector3f getBarColour(float percentage, Vector3f start, Vector3f end, boolean shouldGradient) {
        if (shouldGradient) {
            Vector3f colour = new Vector3f();
            colour.x = class_3532.method_16439((float)percentage, (float)end.x, (float)start.x);
            colour.y = class_3532.method_16439((float)percentage, (float)end.y, (float)start.y);
            colour.z = class_3532.method_16439((float)percentage, (float)end.z, (float)start.z);
            return colour;
        }
        return start;
    }

    public static void save() {
        JsonHelper json = new JsonHelper();
        String jsonData = json.start().append("hudDuration", maxHealthBarTicks).newLine().append("hudIcon", showHudIcon).newLine().append("hudPortraits", useCustomHudPortraits).newLine().append("hudGlide", hudGlide).newLine().append("hudPosition", hudPosition.name()).newLine().append("hudOffsetY", hudOffsetPercent).newLine().append("hudGradient", hudGradient).newLine().append("hudStartColour", hudStartColour).newLine().append("hudEndColour", hudEndColour).newLine().append("replaceLabels", overrideLabels).newLine().append("worldGlide", worldGlide).newLine().append("worldHealthText", showTextInWorld).newLine().append("worldTextShadows", worldShadows).newLine().append("maxRenderDistance", maxRenderDistance).newLine().append("barScale", worldHealthBarScale).newLine().append("worldOffsetY", worldOffsetY).newLine().append("worldGradient", worldGradient).newLine().append("worldStartColour", worldStartColour).newLine().append("worldEndColour", worldEndColour).newLine().append("bossHealth", bosses.name()).newLine().append("bossTarget", bossesVisibilityOverride).newLine().append("hostileHealth", hostile.name()).newLine().append("hostileTarget", hostileVisibilityOverride).newLine().append("playerHealth", players.name()).newLine().append("playerTarget", playersVisibilityOverride).newLine().append("otherHealth", others.name()).newLine().append("otherTarget", othersVisibilityOverride).newLine().append("worldTitles", worldTitles).newLine().append("bossHUD", bossHUD.name()).newLine().append("hostileHUD", hostileHUD.name()).newLine().append("playerHUD", playerHUD.name()).newLine().append("otherHUD", otherHUD.name()).newLine().append("hudTitles", hudTitles).newLine().append("damageParticles", spawnDamageParticles).newLine().append("healingParticles", spawnHealingParticles).newLine().append("damageColour", damageColour).newLine().append("damageAlpha", damageAlpha).newLine().append("healingColour", healingColour).newLine().append("healingAlpha", healingAlpha).newLine().append("particleScale", particleScale).newLine().append("particleTextShadow", particleTextShadow).newLine().append("damageParticleTextColour", damageParticleTextColour).newLine().append("healingParticleTextColour", healingParticleTextColour).newLine().append("particleType", particleType.name()).newLine().append("maxParticleDistance", maxParticleDistance).newLine().append("topLayerTextType", seeThroughTextType.name()).newLine().append("compatWorldBar", compatInWorld).newLine().append("compatHudPaperdoll", HUDCompat.name()).newLine().createArray("healthBlacklist", blacklist).newLine().createArray("hudBlacklist", blacklistHUD).newLine(false).closeObject().toString();
        try {
            FileWriter writer = new FileWriter("config/provihealth.json");
            writer.write(jsonData);
            writer.close();
        }
        catch (IOException e) {
            ProviHealthClient.LOGGER.error("Error whilst saving config: ", (Throwable)e);
        }
    }

    public static void load() {
        try {
            FileReader reader = new FileReader("config/provihealth.json");
            JsonReader parser = new JsonReader((Reader)reader);
            parser.beginObject();
            block107: while (parser.hasNext()) {
                String label;
                switch (label = parser.nextName()) {
                    case "hudDuration": {
                        maxHealthBarTicks = parser.nextInt();
                        continue block107;
                    }
                    case "hudIcon": {
                        showHudIcon = parser.nextBoolean();
                        continue block107;
                    }
                    case "hudPortraits": {
                        useCustomHudPortraits = parser.nextBoolean();
                        continue block107;
                    }
                    case "hudGlide": {
                        hudGlide = (float)parser.nextDouble();
                        continue block107;
                    }
                    case "hudPosition": {
                        hudPosition = HUDPosition.valueOf(parser.nextString());
                        continue block107;
                    }
                    case "hudOffsetY": {
                        hudOffsetPercent = parser.nextInt();
                        continue block107;
                    }
                    case "hudGradient": {
                        hudGradient = parser.nextBoolean();
                        continue block107;
                    }
                    case "hudStartColour": {
                        hudStartColour = parser.nextInt();
                        unpackedStartHud = class_243.method_24457((int)hudStartColour).method_46409();
                        continue block107;
                    }
                    case "hudEndColour": {
                        hudEndColour = parser.nextInt();
                        unpackedEndHud = class_243.method_24457((int)hudEndColour).method_46409();
                        continue block107;
                    }
                    case "replaceLabels": {
                        overrideLabels = parser.nextBoolean();
                        continue block107;
                    }
                    case "worldGlide": {
                        worldGlide = (float)parser.nextDouble();
                        continue block107;
                    }
                    case "worldHealthText": {
                        showTextInWorld = parser.nextBoolean();
                        continue block107;
                    }
                    case "worldTextShadows": {
                        worldShadows = parser.nextBoolean();
                        continue block107;
                    }
                    case "maxRenderDistance": {
                        maxRenderDistance = (float)parser.nextDouble();
                        continue block107;
                    }
                    case "barScale": {
                        worldHealthBarScale = (float)parser.nextDouble();
                        continue block107;
                    }
                    case "worldOffsetY": {
                        worldOffsetY = (float)parser.nextDouble();
                        continue block107;
                    }
                    case "worldGradient": {
                        worldGradient = parser.nextBoolean();
                        continue block107;
                    }
                    case "worldStartColour": {
                        worldStartColour = parser.nextInt();
                        unpackedStartWorld = class_243.method_24457((int)worldStartColour).method_46409();
                        continue block107;
                    }
                    case "worldEndColour": {
                        worldEndColour = parser.nextInt();
                        unpackedEndWorld = class_243.method_24457((int)worldEndColour).method_46409();
                        continue block107;
                    }
                    case "bossHealth": {
                        bosses = VisibilityType.valueOf(parser.nextString());
                        continue block107;
                    }
                    case "bossTarget": {
                        bossesVisibilityOverride = parser.nextBoolean();
                        continue block107;
                    }
                    case "bossHUD": {
                        bossHUD = HUDType.valueOf(parser.nextString());
                        continue block107;
                    }
                    case "hostileHealth": {
                        hostile = VisibilityType.valueOf(parser.nextString());
                        continue block107;
                    }
                    case "hostileTarget": {
                        hostileVisibilityOverride = parser.nextBoolean();
                        continue block107;
                    }
                    case "hostileHUD": {
                        hostileHUD = HUDType.valueOf(parser.nextString());
                        continue block107;
                    }
                    case "playerHealth": {
                        players = VisibilityType.valueOf(parser.nextString());
                        continue block107;
                    }
                    case "playerTarget": {
                        playersVisibilityOverride = parser.nextBoolean();
                        continue block107;
                    }
                    case "worldTitles": {
                        worldTitles = parser.nextBoolean();
                        continue block107;
                    }
                    case "playerHUD": {
                        playerHUD = HUDType.valueOf(parser.nextString());
                        continue block107;
                    }
                    case "otherHealth": {
                        others = VisibilityType.valueOf(parser.nextString());
                        continue block107;
                    }
                    case "otherTarget": {
                        othersVisibilityOverride = parser.nextBoolean();
                        continue block107;
                    }
                    case "otherHUD": {
                        otherHUD = HUDType.valueOf(parser.nextString());
                        continue block107;
                    }
                    case "hudTitles": {
                        hudTitles = parser.nextBoolean();
                        continue block107;
                    }
                    case "damageParticles": {
                        spawnDamageParticles = parser.nextBoolean();
                        continue block107;
                    }
                    case "healingParticles": {
                        spawnHealingParticles = parser.nextBoolean();
                        continue block107;
                    }
                    case "damageColour": {
                        damageColour = parser.nextInt();
                        unpackedDamage = class_243.method_24457((int)damageColour).method_46409();
                        continue block107;
                    }
                    case "damageAlpha": {
                        damageAlpha = (float)parser.nextDouble();
                        continue block107;
                    }
                    case "healingColour": {
                        healingColour = parser.nextInt();
                        unpackedHealing = class_243.method_24457((int)healingColour).method_46409();
                        continue block107;
                    }
                    case "healingAlpha": {
                        healingAlpha = (float)parser.nextDouble();
                        continue block107;
                    }
                    case "particleScale": {
                        particleScale = (float)parser.nextDouble();
                        continue block107;
                    }
                    case "particleTextShadow": {
                        particleTextShadow = parser.nextBoolean();
                        continue block107;
                    }
                    case "damageParticleTextColour": {
                        damageParticleTextColour = parser.nextInt();
                        continue block107;
                    }
                    case "healingParticleTextColour": {
                        healingParticleTextColour = parser.nextInt();
                        continue block107;
                    }
                    case "particleType": {
                        particleType = DamageParticleType.valueOf(parser.nextString());
                        continue block107;
                    }
                    case "maxParticleDistance": {
                        maxParticleDistance = (float)parser.nextDouble();
                        continue block107;
                    }
                    case "topLayerTextType": {
                        seeThroughTextType = SeeThroughText.valueOf(parser.nextString());
                        continue block107;
                    }
                    case "compatWorldBar": {
                        compatInWorld = parser.nextBoolean();
                        continue block107;
                    }
                    case "compatHudPaperdoll": {
                        HUDCompat = HUDPortraitCompatMode.valueOf(parser.nextString());
                        continue block107;
                    }
                    case "healthBlacklist": {
                        ArrayList<String> tempBlacklist = new ArrayList<String>();
                        parser.beginArray();
                        while (parser.hasNext()) {
                            tempBlacklist.add(parser.nextString());
                        }
                        parser.endArray();
                        blacklist = tempBlacklist;
                        continue block107;
                    }
                    case "hudBlacklist": {
                        ArrayList<String> tempHudBlacklist = new ArrayList<String>();
                        parser.beginArray();
                        while (parser.hasNext()) {
                            tempHudBlacklist.add(parser.nextString());
                        }
                        parser.endArray();
                        blacklistHUD = tempHudBlacklist;
                        continue block107;
                    }
                }
                ProviHealthClient.LOGGER.warn("Unknown label \"" + label + "\" found in config.");
                parser.skipValue();
            }
            parser.close();
        }
        catch (FileNotFoundException e) {
            ProviHealthClient.LOGGER.info("No config found, creating new one.");
            Options.save();
        }
        catch (IOException e2) {
            ProviHealthClient.LOGGER.error("Error whilst parsing config: ", (Throwable)e2);
        }
    }

    private static boolean shouldRenderHealthFor(VisibilityType type, class_1309 livingEntity) {
        switch (type.ordinal()) {
            case 0: {
                return false;
            }
            case 1: {
                if (livingEntity.method_6032() < livingEntity.method_6063()) {
                    return true;
                }
                if (livingEntity.method_5765()) {
                    for (class_1297 vehicle = livingEntity.method_5854(); vehicle != null; vehicle = vehicle.method_5854()) {
                        class_1309 livingVehicle;
                        if (!(vehicle instanceof class_1309) || !((livingVehicle = (class_1309)vehicle).method_6032() < livingVehicle.method_6063())) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }

    public static enum VisibilityType {
        ALWAYS_HIDE,
        HIDE_IF_FULL,
        ALWAYS_SHOW;


        public String toString() {
            return "enum.provihealth." + super.toString().toLowerCase();
        }
    }

    public static enum HUDType {
        NONE,
        PORTRAIT_ONLY,
        FULL;


        public String toString() {
            return "enum.provihealth." + super.toString().toLowerCase();
        }
    }

    public static enum HUDPosition {
        LEFT(150.0f),
        RIGHT(210.0f);

        public final float portraitYAW;

        private HUDPosition(float portraitYAW) {
            this.portraitYAW = portraitYAW;
        }

        public String toString() {
            return "enum.provihealth." + super.toString().toLowerCase();
        }
    }

    public static enum DamageParticleType {
        RISING,
        GRAVITY,
        STATIC;


        public String toString() {
            return "enum.provihealth." + super.toString().toLowerCase();
        }
    }

    public static enum SeeThroughText {
        STANDARD,
        NONE,
        FULL;


        public String toString() {
            return "enum.provihealth.seethroughtext." + super.toString().toLowerCase();
        }
    }

    public static enum HUDPortraitCompatMode {
        STANDARD,
        COMPAT,
        NONE;


        public String toString() {
            return "enum.provihealth.hudportraitcompatmode." + super.toString().toLowerCase();
        }
    }
}

