/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.provihealth.hud;

import com.provismet.provihealth.ProviHealthClient;
import com.provismet.provihealth.api.ProviHealthApi;
import com.provismet.provihealth.config.Options;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class BorderRegistry {
    private static final HashMap<class_1299<?>, class_2960> borderCache = new HashMap();
    private static final HashMap<class_1299<?>, class_1799> iconCache = new HashMap();
    private static final HashMap<class_6862<class_1299<?>>, BorderPriority> tagBorderPriorities = new HashMap();
    private static final HashMap<class_6862<class_1299<?>>, ItemPriority> tagIconPriorities = new HashMap();
    private static final HashMap<class_1299<?>, BorderPriority> typeBorderPriorities = new HashMap();
    private static final HashMap<class_1299<?>, ItemPriority> typeIconPriorities = new HashMap();
    private static final List<TitlePriority> orderedTitles = new ArrayList<TitlePriority>();
    private static final class_2960 DEFAULT = ProviHealthClient.identifier("textures/gui/healthbars/default.png");

    public static boolean registerBorder(class_6862<class_1299<?>> entityTag, @Nullable class_2960 border, int priority) {
        if (entityTag == null) {
            ProviHealthClient.LOGGER.error("Attempted to register a null object to the border registry.");
            return false;
        }
        if (tagBorderPriorities.containsKey(entityTag) && priority <= tagBorderPriorities.get(entityTag).priority()) {
            return false;
        }
        tagBorderPriorities.put(entityTag, new BorderPriority(border, priority));
        return true;
    }

    public static boolean registerItem(class_6862<class_1299<?>> entityTag, @Nullable class_1799 item, int priority) {
        if (entityTag == null) {
            ProviHealthClient.LOGGER.error("Attempted to register a null EntityGroup to the icon registry.");
            return false;
        }
        if (tagIconPriorities.containsKey(entityTag) && priority <= tagIconPriorities.get(entityTag).priority()) {
            return false;
        }
        tagIconPriorities.put(entityTag, new ItemPriority(item, priority));
        return true;
    }

    public static boolean registerBorder(class_1299<?> type, @Nullable class_2960 border, int priority) {
        if (type == null) {
            ProviHealthClient.LOGGER.error("Attempted to register a null EntityType to the border registry.");
            return false;
        }
        if (typeBorderPriorities.containsKey(type) && priority <= typeBorderPriorities.get(type).priority()) {
            return false;
        }
        typeBorderPriorities.put(type, new BorderPriority(border, priority));
        return true;
    }

    public static boolean registerItem(class_1299<?> type, @Nullable class_1799 item, int priority) {
        if (type == null) {
            ProviHealthClient.LOGGER.error("Attempted to register a null EntityType to the icon registry.");
            return false;
        }
        if (typeIconPriorities.containsKey(type) && priority <= typeIconPriorities.get(type).priority()) {
            return false;
        }
        typeIconPriorities.put(type, new ItemPriority(item, priority));
        return true;
    }

    public static void registerTitle(ProviHealthApi.TitleGenerator titleGen, int order) {
        orderedTitles.add(new TitlePriority(titleGen, order));
    }

    public static void sortTitles() {
        orderedTitles.sort(new Comparator<TitlePriority>(){

            @Override
            public int compare(TitlePriority a, TitlePriority b) {
                return a.order() - b.order();
            }
        });
    }

    public static class_2960 getBorder(@Nullable class_1309 entity) {
        if (entity == null || !Options.useCustomHudPortraits) {
            return DEFAULT;
        }
        if (borderCache.containsKey(entity.method_5864())) {
            return borderCache.get(entity.method_5864());
        }
        int maxPriority = -1000;
        class_2960 bestBorder = DEFAULT;
        for (class_6862<class_1299<?>> class_68622 : tagBorderPriorities.keySet()) {
            if (!entity.method_5864().method_20210(class_68622) || tagBorderPriorities.get(class_68622).priority() <= maxPriority) continue;
            bestBorder = tagBorderPriorities.get(class_68622).borderId();
            maxPriority = tagBorderPriorities.get(class_68622).priority();
        }
        for (class_1299 class_12992 : typeBorderPriorities.keySet()) {
            if (entity.method_5864() != class_12992 || typeBorderPriorities.get(class_12992).priority() <= maxPriority) continue;
            bestBorder = typeBorderPriorities.get(class_12992).borderId();
            maxPriority = typeBorderPriorities.get(class_12992).priority();
        }
        borderCache.put(entity.method_5864(), bestBorder);
        return bestBorder;
    }

    @Nullable
    public static class_1799 getItem(class_1309 entity) {
        if (entity == null) {
            return null;
        }
        if (iconCache.containsKey(entity.method_5864())) {
            return iconCache.get(entity.method_5864());
        }
        int maxPriority = -1000;
        class_1799 bestIcon = null;
        for (class_6862<class_1299<?>> class_68622 : tagIconPriorities.keySet()) {
            if (!entity.method_5864().method_20210(class_68622) || tagIconPriorities.get(class_68622).priority() <= maxPriority) continue;
            bestIcon = tagIconPriorities.get(class_68622).itemStack();
            maxPriority = tagIconPriorities.get(class_68622).priority();
        }
        for (class_1299 class_12992 : typeIconPriorities.keySet()) {
            if (entity.method_5864() != class_12992 || typeIconPriorities.get(class_12992).priority() <= maxPriority) continue;
            bestIcon = typeIconPriorities.get(class_12992).itemStack();
            maxPriority = typeIconPriorities.get(class_12992).priority();
        }
        iconCache.put(entity.method_5864(), bestIcon);
        return bestIcon;
    }

    public static List<class_2561> getTitle(class_1309 entity, boolean world, boolean hud) {
        if (entity == null) {
            return null;
        }
        List<class_2561> titles = orderedTitles.stream().map(title -> title.titleGetter().apply(entity, world, hud)).filter(title -> title != null).toList();
        return titles;
    }

    private record BorderPriority(class_2960 borderId, int priority) {
    }

    private record ItemPriority(class_1799 itemStack, int priority) {
    }

    private record TitlePriority(ProviHealthApi.TitleGenerator titleGetter, int order) {
    }
}

