/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.provihealth.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.provismet.provihealth.ProviHealthClient;
import com.provismet.provihealth.config.Options;
import com.provismet.provihealth.hud.BorderRegistry;
import com.provismet.provihealth.util.Visibility;
import com.provismet.provihealth.world.EntityHealthBar;
import java.util.SequencedCollection;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_898;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class TargetHealthBar
implements HudRenderCallback {
    public static boolean disabledLabels = false;
    private static final class_2960 BARS = ProviHealthClient.identifier("textures/gui/healthbars/bars.png");
    private static final class_2960 COMPAT_BARS = ProviHealthClient.identifier("textures/gui/healthbars/bars_coloured.png");
    private static final class_2960 HEART = ProviHealthClient.identifier("textures/gui/healthbars/icons/heart.png");
    private static final class_2960 MOUNT_HEART = ProviHealthClient.identifier("textures/gui/healthbars/icons/mount_heart.png");
    private static final class_2960 ARMOUR = ProviHealthClient.identifier("textures/gui/healthbars/icons/armour.png");
    private static int OFFSET_X = 0;
    private static int OFFSET_Y = 0;
    private static final int BAR_WIDTH = 128;
    private static final int BAR_HEIGHT = 10;
    private static final int MOUNT_BAR_HEIGHT = 6;
    private static final int MOUNT_BAR_WIDTH = 121;
    private static final int FRAME_LENGTH = 48;
    private static final int LEFT_TEXT_X = 50;
    private static int BAR_X = 43;
    private static int BAR_Y = OFFSET_Y + 24 - 8;
    private static final float BAR_V2 = 0.3125f;
    private static final float MOUNT_BAR_U2 = 0.9453125f;
    private static final float MOUNT_BAR_V1 = 0.3125f;
    private static final float MOUNT_BAR_V2 = 0.5f;
    private static final int BAR_WIDTH_DIFF = 7;
    private class_1309 target = null;
    private float healthBarDuration = 0.0f;
    private int currentHealthWidth;
    private int currentVehicleHealthWidth;

    public void onHudRender(class_332 drawContext, class_9779 tickCounter) {
        float tickDelta = tickCounter.method_60637(true);
        if (this.healthBarDuration > 0.0f) {
            this.healthBarDuration -= tickDelta;
        } else {
            this.reset();
        }
        if (!class_310.method_1498() || class_310.method_1551().method_53526().method_53536() || class_310.method_1551().field_1724.method_7325()) {
            return;
        }
        boolean isNew = false;
        class_1297 class_12972 = class_310.method_1551().field_1692;
        if (class_12972 instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            if (!Visibility.isVisible(living)) {
                return;
            }
            if (!living.equals((Object)this.target)) {
                isNew = true;
            }
            this.target = living;
            this.healthBarDuration = Options.maxHealthBarTicks;
        }
        if (this.healthBarDuration > 0.0f) {
            if (this.target == null) {
                this.reset();
                return;
            }
            this.adjustForScreenSize();
            Options.HUDType hudType = Options.getHUDFor(this.target);
            float healthPercent = class_3532.method_15363((float)(this.target.method_6032() / this.target.method_6063()), (float)0.0f, (float)1.0f);
            float vehicleHealthDeep = 0.0f;
            float vehicleMaxHealthDeep = 0.0f;
            for (class_1297 currentEntity = this.target.method_5854(); currentEntity != null; currentEntity = currentEntity.method_5854()) {
                if (!(currentEntity instanceof class_1309)) continue;
                class_1309 currentLiving = (class_1309)currentEntity;
                vehicleHealthDeep += currentLiving.method_6032();
                vehicleMaxHealthDeep += currentLiving.method_6063();
            }
            float vehicleHealthPercent = vehicleMaxHealthDeep > 0.0f ? class_3532.method_15363((float)(vehicleHealthDeep / vehicleMaxHealthDeep), (float)0.0f, (float)1.0f) : 0.0f;
            int healthWidth = Math.round(128.0f * healthPercent);
            int vehicleHealthWidth = Math.round(121.0f * vehicleHealthPercent);
            if (isNew) {
                this.currentHealthWidth = healthWidth;
                this.currentVehicleHealthWidth = vehicleHealthWidth;
            }
            int nameWidth = class_310.method_1551().field_1772.method_27525((class_5348)this.getName(this.target));
            if (hudType == Options.HUDType.FULL) {
                this.renderBar(drawContext, 128, 1);
                this.renderBar(drawContext, this.glideHealth(healthWidth, tickDelta * Options.hudGlide), 0);
                if (vehicleMaxHealthDeep > 0.0f) {
                    this.renderMountBar(drawContext, 121, 1);
                    this.renderMountBar(drawContext, this.glideVehicleHealth(vehicleHealthWidth, tickDelta * Options.hudGlide), 0);
                }
                int infoLeftX = 50;
                if (Options.hudPosition == Options.HUDPosition.LEFT) {
                    expectedNameX = 50 + nameWidth + 2;
                    if (BorderRegistry.getItem(this.target) != null && Options.showHudIcon) {
                        drawContext.method_51427(BorderRegistry.getItem(this.target), Math.max(BAR_X + 128 - 16, expectedNameX), BAR_Y - 16);
                    }
                } else {
                    expectedNameX = OFFSET_X - 18 - nameWidth;
                    if (BorderRegistry.getItem(this.target) != null && Options.showHudIcon) {
                        drawContext.method_51427(BorderRegistry.getItem(this.target), Math.min(BAR_X, expectedNameX), BAR_Y - 16);
                    }
                    infoLeftX = BAR_X + 3;
                }
                int healthX = drawContext.method_51433(class_310.method_1551().field_1772, String.format("%d/%d", Math.round(this.target.method_6032()), Math.round(this.target.method_6063())), infoLeftX, BAR_Y + 10 + (vehicleMaxHealthDeep > 0.0f ? 6 : 0) + 2, 0xFFFFFF, true);
                drawContext.method_25293(HEART, healthX, BAR_Y + 10 + (vehicleMaxHealthDeep > 0.0f ? 6 : 0) + 1, 9, 9, 0.0f, 0.0f, 9, 9, 9, 9);
                int armourX = class_310.method_1551().field_1772.method_1727(String.format("%d/%d", Math.round(this.target.method_6063()), Math.round(this.target.method_6063()))) + infoLeftX + 18;
                if (this.target.method_6096() > 0) {
                    armourX = drawContext.method_51433(class_310.method_1551().field_1772, String.format("%d", this.target.method_6096()), armourX, BAR_Y + 10 + (vehicleMaxHealthDeep > 0.0f ? 6 : 0) + 2, 0xFFFFFF, true);
                    drawContext.method_25293(ARMOUR, armourX, BAR_Y + 10 + (vehicleMaxHealthDeep > 0.0f ? 6 : 0) + 1, 9, 9, 0.0f, 0.0f, 9, 9, 9, 9);
                }
                if (vehicleMaxHealthDeep > 0.0f) {
                    String mountHealthString = String.format("%d/%d", Math.round(vehicleHealthDeep), Math.round(vehicleMaxHealthDeep));
                    int mountHealthWidth = class_310.method_1551().field_1772.method_1727(mountHealthString) + 9;
                    int expectedLeftPixel = BAR_X + 128 - mountHealthWidth - 3;
                    if (expectedLeftPixel < armourX) {
                        expectedLeftPixel = armourX + 10;
                    }
                    int mountHealthX = drawContext.method_51433(class_310.method_1551().field_1772, mountHealthString, expectedLeftPixel, BAR_Y + 10 + 6 + 2, 0xFFFFFF, true);
                    drawContext.method_25293(MOUNT_HEART, mountHealthX, BAR_Y + 10 + 6 + 1, 9, 9, 0.0f, 0.0f, 9, 9, 9, 9);
                }
                if (Options.hudTitles) {
                    SequencedCollection titles = BorderRegistry.getTitle(this.target, false, true).reversed();
                    int titleX = 5;
                    int titleY = OFFSET_Y + 48 + 5;
                    if (Options.hudPosition == Options.HUDPosition.LEFT) {
                        for (class_2561 title : titles) {
                            drawContext.method_51439(class_310.method_1551().field_1772, title, titleX, titleY, 0xFFFFFF, true);
                            titleY += 10;
                        }
                    } else {
                        for (class_2561 title : titles) {
                            titleX = class_310.method_1551().method_22683().method_4486() - 10 - class_310.method_1551().field_1772.method_27525((class_5348)title);
                            drawContext.method_51439(class_310.method_1551().field_1772, title, titleX, titleY, 0xFFFFFF, true);
                            titleY += 10;
                        }
                    }
                }
            }
            if (hudType != Options.HUDType.NONE) {
                RenderSystem.enableBlend();
                if (Options.hudPosition == Options.HUDPosition.LEFT) {
                    drawContext.method_25293(BorderRegistry.getBorder(this.target), 0, OFFSET_Y, 48, 48, 48.0f, 0.0f, 48, 48, 96, 48);
                    drawContext.method_25291(BorderRegistry.getBorder(this.target), 0, OFFSET_Y, 300, 0.0f, 0.0f, 48, 48, 96, 48);
                    RenderSystem.disableBlend();
                    drawContext.method_51439(class_310.method_1551().field_1772, this.getName(this.target), 50, BAR_Y - 10, 0xFFFFFF, true);
                } else {
                    this.drawHorizontallyMirroredTexturedQuad(BorderRegistry.getBorder(this.target), drawContext, OFFSET_X, OFFSET_X + 48, OFFSET_Y, OFFSET_Y + 48, 0, 0.5f, 1.0f, 0.0f, 1.0f);
                    this.drawHorizontallyMirroredTexturedQuad(BorderRegistry.getBorder(this.target), drawContext, OFFSET_X, OFFSET_X + 48, OFFSET_Y, OFFSET_Y + 48, 300, 0.0f, 0.5f, 0.0f, 1.0f);
                    RenderSystem.disableBlend();
                    drawContext.method_51439(class_310.method_1551().field_1772, this.getName(this.target), OFFSET_X - 1 - nameWidth, BAR_Y - 10, 0xFFFFFF, true);
                }
                if (Options.HUDCompat == Options.HUDPortraitCompatMode.STANDARD) {
                    float renderHeight;
                    float prevTargetHeadYaw = this.target.field_6241;
                    float prevPrevTargetHeadYaw = this.target.field_6259;
                    float prevTargetBodyYaw = this.target.field_6283;
                    float prevPrevTargetBodyYaw = this.target.field_6220;
                    this.target.field_6283 = Options.hudPosition.portraitYAW;
                    this.target.field_6220 = Options.hudPosition.portraitYAW;
                    this.target.field_6241 = Options.hudPosition.portraitYAW;
                    this.target.field_6259 = Options.hudPosition.portraitYAW;
                    if ((double)this.target.method_18381(class_4050.field_18076) >= (double)this.target.method_17682() * 0.6) {
                        renderHeight = this.target.method_18381(this.target.method_18376()) + 0.5f;
                        if (renderHeight < 1.0f) {
                            renderHeight = 1.0f;
                        }
                    } else {
                        renderHeight = this.target.method_18381(this.target.method_18376()) + 0.8f;
                    }
                    drawContext.method_44379(OFFSET_X, OFFSET_Y, OFFSET_X + 48, OFFSET_Y + 48);
                    EntityHealthBar.enabled = false;
                    disabledLabels = true;
                    this.drawEntity(drawContext, 24 + OFFSET_X, OFFSET_Y, 30, new Vector3f(0.0f, renderHeight, 0.0f), new Quaternionf().rotateZ((float)Math.PI), null, this.target);
                    EntityHealthBar.enabled = true;
                    disabledLabels = false;
                    drawContext.method_44380();
                    this.target.field_6241 = prevTargetHeadYaw;
                    this.target.field_6259 = prevPrevTargetHeadYaw;
                    this.target.field_6283 = prevTargetBodyYaw;
                    this.target.field_6220 = prevPrevTargetBodyYaw;
                } else if (Options.HUDCompat == Options.HUDPortraitCompatMode.COMPAT) {
                    float renderHeight;
                    float yawOffset = -(Options.hudPosition.portraitYAW - this.target.method_43078()) / 57.295776f;
                    if ((double)this.target.method_18381(class_4050.field_18076) >= (double)this.target.method_17682() * 0.6) {
                        renderHeight = this.target.method_18381(this.target.method_18376()) + 0.5f;
                        if (renderHeight < 1.0f) {
                            renderHeight = 1.0f;
                        }
                    } else {
                        renderHeight = this.target.method_18381(this.target.method_18376()) + 0.8f;
                    }
                    drawContext.method_44379(OFFSET_X, OFFSET_Y, OFFSET_X + 48, OFFSET_Y + 48);
                    EntityHealthBar.enabled = false;
                    disabledLabels = true;
                    this.drawEntity(drawContext, 24 + OFFSET_X, OFFSET_Y, 30, new Vector3f(0.0f, renderHeight, 0.0f), new Quaternionf().rotateZ((float)Math.PI).rotateY(yawOffset), null, this.target);
                    EntityHealthBar.enabled = true;
                    disabledLabels = false;
                    drawContext.method_44380();
                }
            }
        }
    }

    private class_2561 getName(class_1309 entity) {
        if (entity instanceof class_1657 && entity.method_5756((class_1657)class_310.method_1551().field_1724)) {
            return class_2561.method_43471((String)"entity.provihealth.unknownPlayer");
        }
        return entity.method_5476();
    }

    private int glideHealth(int trueValue, float glideFactor) {
        this.currentHealthWidth = (int)((float)this.currentHealthWidth + (float)(trueValue - this.currentHealthWidth) * class_3532.method_15363((float)glideFactor, (float)0.001f, (float)1.0f));
        return this.currentHealthWidth;
    }

    private int glideVehicleHealth(int trueValue, float glideFactor) {
        this.currentVehicleHealthWidth = (int)((float)this.currentVehicleHealthWidth + (float)(trueValue - this.currentVehicleHealthWidth) * class_3532.method_15363((float)glideFactor, (float)0.001f, (float)1.0f));
        return this.currentVehicleHealthWidth;
    }

    private void renderBar(class_332 drawContext, int width, int barIndex) {
        if (Options.hudPosition == Options.HUDPosition.LEFT) {
            this.drawTexturedQuad(BARS, drawContext, BAR_X, BAR_X + width, BAR_Y, BAR_Y + 10, 0, 0.0f, (float)width / 128.0f, (float)barIndex / 2.0f, 0.3125f + (float)barIndex / 2.0f, Options.getBarColour((float)width / 128.0f, barIndex == 1 ? Options.WHITE : Options.unpackedStartHud, Options.unpackedEndHud, barIndex == 0 && Options.hudGradient));
        } else {
            this.drawHorizontallyMirroredTexturedQuad(BARS, drawContext, BAR_X + (128 - width), BAR_X + 128, BAR_Y, BAR_Y + 10, 0, 0.0f, (float)width / 128.0f, (float)barIndex / 2.0f, 0.3125f + (float)barIndex / 2.0f, Options.getBarColour((float)width / 128.0f, barIndex == 1 ? Options.WHITE : Options.unpackedStartHud, Options.unpackedEndHud, barIndex == 0 && Options.hudGradient));
        }
    }

    private void renderMountBar(class_332 drawContext, int width, int barIndex) {
        if (Options.hudPosition == Options.HUDPosition.LEFT) {
            this.drawTexturedQuad(BARS, drawContext, BAR_X, BAR_X + width, BAR_Y + 10, BAR_Y + 10 + 6, 0, 0.0f, (float)width / 121.0f * 0.9453125f, 0.3125f + (float)barIndex / 2.0f, 0.5f + (float)barIndex / 2.0f, Options.getBarColour((float)width / 121.0f, barIndex == 1 ? Options.WHITE : Options.unpackedStartHud, Options.unpackedEndHud, barIndex == 0 && Options.hudGradient));
        } else {
            this.drawHorizontallyMirroredTexturedQuad(BARS, drawContext, BAR_X + (121 - width) + 7, BAR_X + 7 + 121, BAR_Y + 10, BAR_Y + 10 + 6, 0, 0.0f, (float)width / 121.0f * 0.9453125f, 0.3125f + (float)barIndex / 2.0f, 0.5f + (float)barIndex / 2.0f, Options.getBarColour((float)width / 121.0f, barIndex == 1 ? Options.WHITE : Options.unpackedStartHud, Options.unpackedEndHud, barIndex == 0 && Options.hudGradient));
        }
    }

    private void reset() {
        this.healthBarDuration = 0.0f;
        this.target = null;
        this.currentHealthWidth = 0;
        this.currentVehicleHealthWidth = 0;
    }

    private void adjustForScreenSize() {
        OFFSET_Y = Math.min((int)((float)class_310.method_1551().method_22683().method_4502() * ((float)Options.hudOffsetPercent / 100.0f)), class_310.method_1551().method_22683().method_4502() - 48);
        BAR_Y = OFFSET_Y + 24 - 8;
        if (Options.hudPosition == Options.HUDPosition.LEFT) {
            OFFSET_X = 0;
            BAR_X = 43;
        } else {
            int width = class_310.method_1551().method_22683().method_4486();
            OFFSET_X = width - 48;
            BAR_X = OFFSET_X + 5 - 128;
        }
    }

    private void drawEntity(class_332 context, float x, float y, int size, Vector3f vector3f, Quaternionf quaternionf, @Nullable Quaternionf quaternionf2, class_1309 entity) {
        context.method_51448().method_22903();
        context.method_51448().method_22904((double)x, (double)y, 50.0);
        context.method_51448().method_34425(new Matrix4f().scaling((float)size, (float)size, (float)(-size)));
        context.method_51448().method_46416(vector3f.x, vector3f.y, vector3f.z);
        context.method_51448().method_22907(quaternionf);
        class_308.method_34742();
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        if (quaternionf2 != null) {
            quaternionf2.conjugate();
            entityRenderDispatcher.method_24196(quaternionf2);
        }
        entityRenderDispatcher.method_3948(false);
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.method_3954((class_1297)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, context.method_51448(), (class_4597)context.method_51450(), 0xF000F0));
        context.method_51452();
        entityRenderDispatcher.method_3948(true);
        context.method_51448().method_22909();
        class_308.method_24211();
    }

    private void drawHorizontallyMirroredTexturedQuad(class_2960 texture, class_332 context, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2) {
        context.method_25295(texture, x1, x2, y1, y2, z, u2, u1, v1, v2);
    }

    private void drawTexturedQuad(class_2960 texture, class_332 context, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2, Vector3f colour) {
        context.method_48466(texture, x1, x2, y1, y2, z, u1, u2, v1, v2, colour.x, colour.y, colour.z, 1.0f);
    }

    private void drawHorizontallyMirroredTexturedQuad(class_2960 texture, class_332 context, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2, Vector3f colour) {
        context.method_48466(texture, x1, x2, y1, y2, z, u2, u1, v1, v2, colour.x, colour.y, colour.z, 1.0f);
    }
}

