/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.provihealth.particle;

import com.provismet.lilylib.util.MoreMath;
import com.provismet.provihealth.config.Options;
import com.provismet.provihealth.particle.TextParticleEffect;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_765;
import org.joml.Quaternionf;

public class TextParticle
extends class_4003 {
    private final String text;
    private final float rotationSpeed;
    private final float maxScale;
    private final int textColour;
    private float prevScale;

    protected TextParticle(class_638 clientWorld, double x, double y, double z, TextParticleEffect particleEffect) {
        super(clientWorld, x, y, z);
        this.field_3861 = particleEffect.getColour().x();
        this.field_3842 = particleEffect.getColour().y();
        this.field_3859 = particleEffect.getColour().z();
        this.field_17867 = 0.0f;
        this.prevScale = 0.0f;
        this.field_3841 = particleEffect.alpha;
        this.textColour = particleEffect.textColour;
        this.text = particleEffect.text;
        this.field_3847 = 40;
        this.rotationSpeed = (float)Math.toRadians((this.field_3840.method_43058() * 1.5 + 0.5) * (double)(this.field_3840.method_43056() ? 10 : -10));
        this.maxScale = particleEffect.scale;
        double sign = this.field_3840.method_43056() ? 1.0 : -1.0;
        MoreMath.RightAngledTriangle triangle = new MoreMath.RightAngledTriangle(new class_243(this.field_3874, this.field_3854, this.field_3871), class_310.method_1551().field_1724.method_33571());
        switch (Options.particleType) {
            case RISING: {
                this.method_3063(this.field_3874 + 0.5 * -triangle.cosine() * sign, this.field_3854, this.field_3871 + 0.5 * triangle.sine() * sign);
                this.field_3852 = 0.0;
                this.field_3869 = 0.1;
                this.field_3850 = 0.0;
                this.field_28786 = 0.85f;
                break;
            }
            case GRAVITY: {
                this.method_3063(this.field_3874 + 0.5 * -triangle.cosine() * sign, this.field_3854 + this.field_3840.method_43058() * 0.5, this.field_3871 + 0.5 * triangle.sine() * sign);
                double velBonus = this.field_3840.method_43058() * 0.025 + 0.05;
                this.field_3852 = velBonus * -triangle.cosine() * sign;
                this.field_3869 = 0.125;
                this.field_3850 = velBonus * triangle.sine() * sign;
                break;
            }
            case STATIC: {
                this.method_3063(this.field_3874 + 0.5 * -triangle.cosine() * sign, this.field_3854 + this.field_3840.method_43058() * 0.75, this.field_3871 + 0.5 * triangle.sine() * sign);
                this.field_3852 = 0.0;
                this.field_3869 = 0.0;
                this.field_3850 = 0.0;
                break;
            }
        }
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
    }

    public void method_3070() {
        super.method_3070();
        this.prevScale = this.field_17867;
        if (this.field_3866 > this.field_3847 / 2) {
            this.field_17867 -= this.maxScale / ((float)this.field_3847 / 2.0f);
        } else if (this.field_17867 < this.maxScale) {
            this.field_17867 += this.maxScale / 5.0f;
        }
        this.field_3857 = this.field_3839;
        this.field_3839 += this.rotationSpeed;
        if (Options.particleType == Options.DamageParticleType.GRAVITY) {
            if (this.field_3845) {
                this.field_3852 = 0.0;
                this.field_3869 = 0.0;
                this.field_3850 = 0.0;
            } else {
                this.field_3869 -= 0.025;
            }
        }
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        super.method_3074(vertexConsumer, camera, tickDelta);
        Quaternionf quaternionf = camera.method_23767();
        class_243 cameraPos = camera.method_19326();
        float dX = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3858, (double)this.field_3874) - cameraPos.method_10216());
        float dY = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3838, (double)this.field_3854) - cameraPos.method_10214());
        float dZ = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3856, (double)this.field_3871) - cameraPos.method_10215());
        class_4587 matrices = new class_4587();
        matrices.method_46416(dX, dY, dZ);
        matrices.method_22907(quaternionf);
        float scaleSize = this.method_18132(tickDelta) / 6.0f;
        matrices.method_22905(scaleSize, -scaleSize, scaleSize);
        class_310.method_1551().field_1772.method_27521(this.text, 0.0f, 0.0f, this.textColour, Options.particleTextShadow, matrices.method_23760().method_23761(), (class_4597)class_310.method_1551().method_22940().method_23000(), class_327.class_6415.field_33995, 0, this.method_3068(tickDelta));
    }

    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    public int method_3068(float tint) {
        return class_765.method_23687((int)15, (int)15);
    }

    public String getText() {
        return this.text;
    }

    public int getColour() {
        return this.textColour;
    }

    public float method_18132(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.prevScale, (float)this.field_17867);
    }

    public class_243 getPos() {
        return new class_243(this.field_3874, this.field_3854, this.field_3871);
    }

    public class_243 getPrevPos() {
        return new class_243(this.field_3858, this.field_3838, this.field_3856);
    }

    public static class Factory
    implements class_707<TextParticleEffect> {
        private final class_4002 spriteProvider;

        public Factory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public class_703 createParticle(TextParticleEffect particleEffect, class_638 clientWorld, double x, double y, double z, double velX, double velY, double velZ) {
            TextParticle textParticle = new TextParticle(clientWorld, x, y, z, particleEffect);
            textParticle.method_18140(this.spriteProvider);
            return textParticle;
        }
    }
}

