/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.provihealth.world;

import com.mojang.blaze3d.systems.RenderSystem;
import com.provismet.provihealth.ProviHealthClient;
import com.provismet.provihealth.config.Options;
import com.provismet.provihealth.hud.BorderRegistry;
import com.provismet.provihealth.interfaces.IMixinLivingEntity;
import com.provismet.provihealth.util.Visibility;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import net.minecraft.class_765;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class EntityHealthBar {
    private static final class_2960 BARS = ProviHealthClient.identifier("textures/gui/healthbars/in_world.png");
    private static final class_2960 COMPAT_BARS = ProviHealthClient.identifier("textures/gui/healthbars/in_world_coloured.png");
    private static final float TEXTURE_SIZE = 64.0f;
    public static boolean enabled = true;

    public static void render(class_1297 entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, Quaternionf rotation, class_327 textRenderer) {
        class_287 vertexConsumer;
        class_1309 livingRider;
        class_1297 class_12972;
        class_1309 living;
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 target = living = (class_1309)entity;
        if (!class_310.method_1498()) {
            return;
        }
        if (!enabled || target.method_5782() && (class_12972 = target.method_31483()) instanceof class_1309 && !Options.blacklist.contains(class_1299.method_5890((class_1299)(livingRider = (class_1309)class_12972).method_5864()).toString()) || target == class_310.method_1551().field_1724 || !Visibility.isVisible(living)) {
            return;
        }
        if (!Options.shouldRenderHealthFor(living)) {
            return;
        }
        int light = class_765.method_23687((int)15, (int)15);
        matrices.method_22903();
        matrices.method_46416(0.0f, target.method_17682() + 0.45f - 0.003f / Options.worldHealthBarScale + Options.worldOffsetY, 0.0f);
        matrices.method_22905(Options.worldHealthBarScale, Options.worldHealthBarScale, Options.worldHealthBarScale);
        matrices.method_46416(0.0f, (target.method_5733() || target.method_16914() && target == class_310.method_1551().method_1561().field_4678) && !Options.overrideLabels && !target.method_5756((class_1657)class_310.method_1551().field_1724) ? 0.02f + 0.3f / Options.worldHealthBarScale : 0.0f, 0.0f);
        matrices.method_22907(rotation);
        class_289 tessellator = class_289.method_1348();
        if (Options.compatInWorld) {
            vertexConsumer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)COMPAT_BARS);
        } else {
            vertexConsumer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            RenderSystem.setShader(class_757::method_34543);
            RenderSystem.setShaderTexture((int)0, (class_2960)BARS);
        }
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        Matrix4f model = matrices.method_23760().method_23761();
        EntityHealthBar.renderBar(model, (class_4588)vertexConsumer, 1, 1.0f, false);
        EntityHealthBar.renderBar(model, (class_4588)vertexConsumer, 0, ((IMixinLivingEntity)target).provihealth_glideHealth(tickDelta * Options.worldGlide), false);
        if (target.method_5765()) {
            float vehicleHealthPercent;
            float vehicleHealthDeep = 0.0f;
            float vehicleMaxHealthDeep = 0.0f;
            for (class_1297 currentEntity = target.method_5854(); currentEntity != null; currentEntity = currentEntity.method_5854()) {
                if (!(currentEntity instanceof class_1309)) continue;
                class_1309 currentLiving = (class_1309)currentEntity;
                vehicleHealthDeep += currentLiving.method_6032();
                vehicleMaxHealthDeep += currentLiving.method_6063();
            }
            float f = vehicleHealthPercent = vehicleMaxHealthDeep > 0.0f ? class_3532.method_15363((float)(vehicleHealthDeep / vehicleMaxHealthDeep), (float)0.0f, (float)1.0f) : 0.0f;
            if (vehicleHealthPercent > 0.0f) {
                matrices.method_22903();
                matrices.method_46416(0.0f, -0.109375f, 0.0f);
                Matrix4f mountModel = matrices.method_23760().method_23761();
                EntityHealthBar.renderBar(mountModel, (class_4588)vertexConsumer, 1, 1.0f, true);
                EntityHealthBar.renderBar(mountModel, (class_4588)vertexConsumer, 0, ((IMixinLivingEntity)target).provihealth_glideVehicle(vehicleHealthPercent, tickDelta * Options.worldGlide), true);
                matrices.method_22909();
            }
        }
        class_286.method_43433((class_9801)vertexConsumer.method_60800());
        if (Options.showTextInWorld) {
            matrices.method_22903();
            matrices.method_22905(0.01f, -0.01f, 0.01f);
            Matrix4f textModel = matrices.method_23760().method_23761();
            String healthString = String.format("%d/%d", Math.round(target.method_6032()), Math.round(target.method_6063()));
            float lineHeight = 9.0f;
            List<Object> titles = List.of();
            if (Options.worldTitles) {
                titles = BorderRegistry.getTitle(target, true, false);
            }
            if (Options.overrideLabels) {
                boolean wrapLines;
                class_2561 targetName = EntityHealthBar.getName(target);
                float targetNameWidth = textRenderer.method_27525((class_5348)targetName);
                float leftmost = -50.0f;
                float f = 50.0f;
                float healthX = 50.0f - (float)textRenderer.method_1727(healthString);
                float healthY = -9.0f;
                float nameX = -50.0f;
                float nameY = -9.0f;
                boolean bl = wrapLines = targetNameWidth - 50.0f > healthX - 2.0f;
                if (wrapLines) {
                    healthX = (healthX - 50.0f) / 2.0f;
                    nameX = -targetNameWidth / 2.0f;
                    nameY -= 9.0f;
                }
                if ((target.method_5733() || target.method_16914() && target == class_310.method_1551().field_1692) && !target.method_21751() && Options.seeThroughTextType != Options.SeeThroughText.NONE) {
                    if (Options.seeThroughTextType == Options.SeeThroughText.STANDARD) {
                        if (Options.worldShadows) {
                            EntityHealthBar.renderFullText(textRenderer, targetName, healthString, titles, nameX + 1.0f, nameY + 1.0f, healthX + 1.0f, -8.0f, 9.0f, 1.0f, -12566464, false, textModel, vertexConsumers, class_327.class_6415.field_33993, light);
                        }
                        matrices.method_46416(0.0f, 0.0f, 0.03f);
                        textModel = matrices.method_23760().method_23761();
                        EntityHealthBar.renderFullText(textRenderer, targetName, healthString, titles, nameX, nameY, healthX, -9.0f, 9.0f, 0.0f, -1, false, textModel, vertexConsumers, class_327.class_6415.field_33994, light);
                    } else {
                        EntityHealthBar.renderFullText(textRenderer, targetName, healthString, titles, nameX, nameY, healthX, -9.0f, 9.0f, 0.0f, -1, Options.worldShadows, textModel, vertexConsumers, class_327.class_6415.field_33994, light);
                    }
                } else {
                    EntityHealthBar.renderFullText(textRenderer, targetName, healthString, titles, nameX, nameY, healthX, -9.0f, 9.0f, 0.0f, -1, Options.worldShadows, textModel, vertexConsumers, class_327.class_6415.field_33993, light);
                }
            } else {
                textRenderer.method_27521(healthString, (float)(-textRenderer.method_1727(healthString)) / 2.0f, -9.0f, -1, Options.worldShadows, textModel, vertexConsumers, class_327.class_6415.field_33993, 0, light);
                float titleY = -9.0f;
                for (class_2561 class_25612 : titles) {
                    float titleX = (float)(-textRenderer.method_27525((class_5348)class_25612)) / 2.0f;
                    textRenderer.method_30882(class_25612, titleX, titleY -= 9.0f, -1, Options.worldShadows, textModel, vertexConsumers, class_327.class_6415.field_33993, 0, light);
                }
            }
            matrices.method_22909();
        }
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        matrices.method_22909();
    }

    private static void renderFullText(class_327 textRenderer, class_2561 name, String health, List<class_2561> titles, float nameX, float nameY, float healthX, float healthY, float titleLineHeight, float titleLineOffset, int colour, boolean shadow, Matrix4f model, class_4597 vertexes, class_327.class_6415 layerType, int light) {
        textRenderer.method_30882(name, nameX, nameY, colour, shadow, model, vertexes, layerType, 0, light);
        textRenderer.method_27521(health, healthX, healthY, colour, shadow, model, vertexes, layerType, 0, light);
        float titleY = nameY;
        for (class_2561 title : titles) {
            float titleX = titleLineOffset - (float)textRenderer.method_27525((class_5348)title) / 2.0f;
            textRenderer.method_30882(title, titleX, titleY -= titleLineHeight, colour, shadow, model, vertexes, layerType, 0, light);
        }
    }

    private static class_2561 getName(class_1309 entity) {
        if (entity instanceof class_1657 && entity.method_5756((class_1657)class_310.method_1551().field_1724)) {
            return class_2561.method_43471((String)"entity.provihealth.unknownPlayer");
        }
        return entity.method_5476();
    }

    private static void renderBar(Matrix4f model, class_4588 vertexConsumer, int index, float percentage, boolean isMount) {
        if (isMount) {
            percentage = class_3532.method_16439((float)percentage, (float)0.046875f, (float)0.953125f);
        }
        float MIN_U = 1.0f - percentage;
        float MIN_V = (float)index * 12.0f / 64.0f + (isMount ? 0.109375f : 0.0f);
        float MAX_U = 1.0f;
        float MAX_V = MIN_V + (isMount ? 5.0f : 7.0f) / 64.0f;
        float MAX_X = -0.5f;
        float MIN_X = -0.5f + percentage;
        float MIN_Y = 0.0f;
        float MAX_Y = -1.0f * ((isMount ? 5.0f : 7.0f) / 64.0f);
        float Z = (float)index * -1.0E-4f;
        if (Options.compatInWorld) {
            vertexConsumer.method_22918(model, -0.5f, MAX_Y, Z).method_22913(1.0f, MAX_V);
            vertexConsumer.method_22918(model, MIN_X, MAX_Y, Z).method_22913(MIN_U, MAX_V);
            vertexConsumer.method_22918(model, MIN_X, 0.0f, Z).method_22913(MIN_U, MIN_V);
            vertexConsumer.method_22918(model, -0.5f, 0.0f, Z).method_22913(1.0f, MIN_V);
        } else {
            Vector3f colour = Options.WHITE;
            if (index == 0) {
                colour = Options.getBarColour(percentage, Options.unpackedStartWorld, Options.unpackedEndWorld, Options.worldGradient);
            }
            vertexConsumer.method_22918(model, MIN_X, 0.0f, Z).method_22913(MIN_U, MIN_V).method_22915(colour.x, colour.y, colour.z, 1.0f);
            vertexConsumer.method_22918(model, -0.5f, 0.0f, Z).method_22913(1.0f, MIN_V).method_22915(colour.x, colour.y, colour.z, 1.0f);
            vertexConsumer.method_22918(model, -0.5f, MAX_Y, Z).method_22913(1.0f, MAX_V).method_22915(colour.x, colour.y, colour.z, 1.0f);
            vertexConsumer.method_22918(model, MIN_X, MAX_Y, Z).method_22913(MIN_U, MAX_V).method_22915(colour.x, colour.y, colour.z, 1.0f);
        }
    }
}

