/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.seafarer.common.entity.misc.state;

import com.google.common.collect.ImmutableMap;
import com.peeko32213.seafarer.SeaFarer;
import com.peeko32213.seafarer.common.entity.misc.state.StateHelper;
import com.peeko32213.seafarer.common.entity.misc.state.WeightedRandomState;
import com.peeko32213.seafarer.common.entity.misc.state.WeightedState;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public interface IAttackStateAction {
    default public ImmutableMap<String, StateHelper> getSpecialAttack() {
        return ImmutableMap.of();
    }

    @Nullable
    default public StateHelper getSpecialAttackToPerform() {
        return null;
    }

    default public ImmutableMap<String, StateHelper> getAttackStates() {
        return ImmutableMap.of();
    }

    default public List<WeightedState<StateHelper>> getWeightedAttackStatesToPerform() {
        return Collections.emptyList();
    }

    default public StateHelper getRandomAttackState(Entity entity) {
        StateHelper state = WeightedRandomState.getRandomState(entity.m_9236_().f_46441_, this.getWeightedAttackStatesToPerform());
        if (state == null) {
            throw new RuntimeException("State is null");
        }
        return state;
    }

    default public StateHelper getAttackStateForName(Entity entity, String name) {
        if (this.getAttackStates().containsKey((Object)name)) {
            return (StateHelper)this.getAttackStates().get((Object)name);
        }
        SeaFarer.LOGGER.error("Could not get state {} for {}", (Object)name, (Object)entity.m_20078_());
        return null;
    }

    default public StateHelper getSpecialStateForName(Entity entity, String name) {
        if (this.getSpecialAttack().containsKey((Object)name)) {
            return (StateHelper)this.getSpecialAttack().get((Object)name);
        }
        SeaFarer.LOGGER.error("Could not get state {} for {}", (Object)name, (Object)entity.m_20078_());
        return null;
    }
}

