/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.seafarer.core.events;

import com.peeko32213.seafarer.common.block.entity.SFNetBlockEntity;
import com.peeko32213.seafarer.common.util.AsyncLocator;
import com.peeko32213.seafarer.core.events.BrushingEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="seafarer", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    private static final double MAX_BRUSH_DISTANCE = Math.sqrt(ServerGamePacketListenerImpl.f_215198_) - 1.0;

    @SubscribeEvent
    public static void serverAboutToStart(ServerAboutToStartEvent event) {
        AsyncLocator.handleServerAboutToStartEvent();
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        AsyncLocator.handleServerStoppingEvent();
    }

    @SubscribeEvent
    public static void brushBlockOrEntity(LivingEntityUseItemEvent.Tick event) {
        if (event.getItem().m_150930_(Items.f_271356_)) {
            int duration = event.getDuration();
            ItemStack stack = event.getItem();
            LivingEntity entity = event.getEntity();
            Level level = event.getEntity().m_9236_();
            if (duration >= 0 && entity instanceof Player) {
                boolean flag;
                int i;
                Player player = (Player)entity;
                HitResult hitresult = ForgeEvents.calculateHitResult((LivingEntity)player);
                if (hitresult instanceof BlockHitResult) {
                    BlockHitResult blockhitresult = (BlockHitResult)hitresult;
                    if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
                        i = stack.m_41779_() - duration + 1;
                        boolean bl = flag = i % 10 == 5;
                        if (flag) {
                            BlockPos blockpos = blockhitresult.m_82425_();
                            BrushingEvent.Block brushingEvent = new BrushingEvent.Block(level, stack, player, blockhitresult, blockpos);
                            MinecraftForge.EVENT_BUS.post((Event)brushingEvent);
                        }
                    }
                }
                if (hitresult instanceof EntityHitResult) {
                    EntityHitResult entityHitResult = (EntityHitResult)hitresult;
                    if (hitresult.m_6662_() == HitResult.Type.ENTITY) {
                        i = stack.m_41779_() - duration + 1;
                        boolean bl = flag = i % 10 == 5;
                        if (flag) {
                            Entity targetEntity = entityHitResult.m_82443_();
                            BlockPos pos = targetEntity.m_20183_();
                            BrushingEvent.Entity brushingEvent = new BrushingEvent.Entity(level, stack, player, entityHitResult, targetEntity, pos);
                            MinecraftForge.EVENT_BUS.post((Event)brushingEvent);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void brushSaltFromBlock(BrushingEvent.Block event) {
        SFNetBlockEntity netBlockEntity;
        boolean flag1;
        BlockEntity blockentity;
        ForgeEvents.spawnParticles(null, event.getLevel(), event.getBlockHitResult(), event.getBlockState(), event.getVec(), event.getArm());
        Block block = event.getBlockState().m_60734_();
        Level level = event.getLevel();
        BlockPos blockpos = event.getPos();
        Player player = event.getPlayer();
        BlockHitResult result = event.getBlockHitResult();
        SoundEvent soundevent = event.getSoundEvent();
        ItemStack stack = event.getItem();
        event.getLevel().m_247517_(event.getPlayer(), event.getPos(), soundevent, SoundSource.BLOCKS);
        if (!level.m_5776_() && (blockentity = level.m_7702_(blockpos)) instanceof SFNetBlockEntity && (flag1 = (netBlockEntity = (SFNetBlockEntity)blockentity).brush(level.m_46467_(), player, result.m_82434_()))) {
            EquipmentSlot equipmentslot = stack.equals(player.m_6844_(EquipmentSlot.OFFHAND)) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
            stack.m_41622_(1, (LivingEntity)player, p_279044_ -> p_279044_.m_21166_(equipmentslot));
        }
    }

    private static void spawnEntityParticles(@Nullable ParticleOptions options, Level level, EntityHitResult hitResult, Vec3 vec, HumanoidArm arm) {
        double d0 = 3.0;
        int i = arm == HumanoidArm.RIGHT ? 1 : -1;
        int j = level.m_213780_().m_216339_(7, 12);
        SimpleParticleType blockparticleoption = options == null ? ParticleTypes.f_123795_ : options;
        Direction direction = hitResult.m_82443_().m_6350_();
        DustParticlesDelta brushitem$dustparticlesdelta = DustParticlesDelta.fromDirection(vec, direction);
        Vec3 vec3 = hitResult.m_82450_();
        for (int k = 0; k < j; ++k) {
            level.m_7106_((ParticleOptions)blockparticleoption, vec3.f_82479_ - (double)(direction == Direction.WEST ? 1.0E-6f : 0.0f), vec3.f_82480_, vec3.f_82481_ - (double)(direction == Direction.NORTH ? 1.0E-6f : 0.0f), brushitem$dustparticlesdelta.xd() * (double)i * 3.0 * level.m_213780_().m_188500_(), 0.0, brushitem$dustparticlesdelta.zd() * (double)i * 3.0 * level.m_213780_().m_188500_());
        }
    }

    private static void spawnParticles(@Nullable ParticleOptions options, Level level, BlockHitResult hitResult, BlockState state, Vec3 vec, HumanoidArm arm) {
        double d0 = 3.0;
        int i = arm == HumanoidArm.RIGHT ? 1 : -1;
        int j = level.m_213780_().m_216339_(7, 12);
        ParticleOptions blockparticleoption = options == null ? new BlockParticleOption(ParticleTypes.f_123794_, state) : options;
        Direction direction = hitResult.m_82434_();
        DustParticlesDelta brushitem$dustparticlesdelta = DustParticlesDelta.fromDirection(vec, direction);
        Vec3 vec3 = hitResult.m_82450_();
        for (int k = 0; k < j; ++k) {
            level.m_7106_(blockparticleoption, vec3.f_82479_ - (double)(direction == Direction.WEST ? 1.0E-6f : 0.0f), vec3.f_82480_, vec3.f_82481_ - (double)(direction == Direction.NORTH ? 1.0E-6f : 0.0f), brushitem$dustparticlesdelta.xd() * (double)i * 3.0 * level.m_213780_().m_188500_(), 0.0, brushitem$dustparticlesdelta.zd() * (double)i * 3.0 * level.m_213780_().m_188500_());
        }
    }

    private static HitResult calculateHitResult(LivingEntity entity) {
        return ProjectileUtil.m_278180_((Entity)entity, p_281111_ -> !p_281111_.m_5833_() && p_281111_.m_6087_(), (double)MAX_BRUSH_DISTANCE);
    }

    record DustParticlesDelta(double xd, double yd, double zd) {
        private static final double ALONG_SIDE_DELTA = 1.0;
        private static final double OUT_FROM_SIDE_DELTA = 0.1;

        public static DustParticlesDelta fromDirection(Vec3 p_273421_, Direction p_272987_) {
            double d0 = 0.0;
            return switch (p_272987_) {
                case Direction.DOWN, Direction.UP -> new DustParticlesDelta(p_273421_.m_7094_(), 0.0, -p_273421_.m_7096_());
                case Direction.NORTH -> new DustParticlesDelta(1.0, 0.0, -0.1);
                case Direction.SOUTH -> new DustParticlesDelta(-1.0, 0.0, 0.1);
                case Direction.WEST -> new DustParticlesDelta(-0.1, 0.0, -1.0);
                case Direction.EAST -> new DustParticlesDelta(0.1, 0.0, 1.0);
                default -> throw new IncompatibleClassChangeError();
            };
        }
    }
}

