/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.seafarer.datagen;

import com.google.common.collect.Sets;
import com.peeko32213.seafarer.datagen.BiomeTagsProvider;
import com.peeko32213.seafarer.datagen.BlockTagsGenerator;
import com.peeko32213.seafarer.datagen.BlockstateGenerator;
import com.peeko32213.seafarer.datagen.ItemModelGenerator;
import com.peeko32213.seafarer.datagen.ItemTagsGenerator;
import com.peeko32213.seafarer.datagen.LanguageGenerator;
import com.peeko32213.seafarer.datagen.LootGenerator;
import com.peeko32213.seafarer.datagen.RecipeGenerator;
import com.peeko32213.seafarer.datagen.WorldGenProvider;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="seafarer", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent evt) {
        if (evt.includeServer()) {
            DataGenerators.registerServerProviders(evt.getGenerator(), evt);
        }
    }

    private static void registerServerProviders(DataGenerator generator, GatherDataEvent evt) {
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper helper = evt.getExistingFileHelper();
        HashSet set = Sets.newHashSet();
        Consumer<BlockStateGenerator> consumer = set::add;
        CompletableFuture lookupProvider = evt.getLookupProvider();
        generator.addProvider(true, (DataProvider)new BlockstateGenerator(packOutput, helper));
        generator.addProvider(true, (DataProvider)new ItemModelGenerator(packOutput, helper));
        generator.addProvider(true, (DataProvider)new LanguageGenerator(packOutput));
        generator.addProvider(evt.includeServer(), (DataProvider)LootGenerator.create(packOutput));
        generator.addProvider(true, (DataProvider)new RecipeGenerator(packOutput));
        BlockTagsGenerator blockTagGenerator = (BlockTagsGenerator)generator.addProvider(evt.includeServer(), (DataProvider)new BlockTagsGenerator(packOutput, lookupProvider, helper));
        generator.addProvider(evt.includeServer(), (DataProvider)new ItemTagsGenerator(packOutput, lookupProvider, blockTagGenerator.m_274426_(), helper));
        generator.addProvider(true, (DataProvider)new BiomeTagsProvider(packOutput, lookupProvider, helper));
        generator.addProvider(evt.includeServer(), (DataProvider)new WorldGenProvider(packOutput, lookupProvider));
    }
}

